/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.ui.icon.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.ui.icon.IconProvider;
import org.openhab.core.ui.icon.IconSet;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletAsyncSupported;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@HttpWhiteboardServletAsyncSupported(asyncSupported=true)
@HttpWhiteboardServletName(value="/icon")
@HttpWhiteboardServletPattern(value={"/icon/*"})
@NonNullByDefault
public class IconServlet
extends HttpServlet {
    private static final long serialVersionUID = 2880642275858634578L;
    private final Logger logger = LoggerFactory.getLogger(IconServlet.class);
    static final String SERVLET_PATH = "/icon";
    static final String PARAM_ICONSET = "iconset";
    static final String PARAM_FORMAT = "format";
    static final String PARAM_ANY_FORMAT = "anyFormat";
    static final String PARAM_STATE = "state";
    protected String defaultIconSetId = "classic";
    private final List<IconProvider> iconProvider = new ArrayList<IconProvider>();

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC)
    public void addIconProvider(IconProvider iconProvider) {
        this.iconProvider.add(iconProvider);
    }

    public void removeIconProvider(IconProvider iconProvider) {
        this.iconProvider.remove(iconProvider);
    }

    @Activate
    protected void activate(Map<String, Object> config) {
        this.modified(config);
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        Object iconSetId = config.get("default");
        if (iconSetId instanceof String) {
            String string;
            this.defaultIconSetId = string = (String)iconSetId;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Object provider2;
        String category = this.getCategory(req);
        if (category.isEmpty()) {
            this.logger.debug("URI must start with '{}' but is '{}'", (Object)SERVLET_PATH, (Object)req.getRequestURI());
            resp.sendError(400);
            return;
        }
        String state = req.getParameter(PARAM_STATE);
        String iconSetId = this.getIconSetId(req);
        IconSet.Format format = this.getFormat(req);
        IconSet.Format otherFormat = null;
        if ("true".equalsIgnoreCase(req.getParameter(PARAM_ANY_FORMAT))) {
            otherFormat = format == IconSet.Format.PNG ? IconSet.Format.SVG : IconSet.Format.PNG;
        }
        Object provider = this.getIconProvider(category, iconSetId, format);
        if (otherFormat != null && (provider2 = this.getIconProvider(category, iconSetId, otherFormat)) != null) {
            if (provider == null) {
                provider = provider2;
                format = otherFormat;
            } else if (!provider2.equals(provider)) {
                Integer prio = provider.hasIcon(category, iconSetId, format);
                Integer prio2 = provider2.hasIcon(category, iconSetId, otherFormat);
                if (prio != null && prio2 != null && prio < prio2 || prio == null && prio2 != null) {
                    provider = provider2;
                    format = otherFormat;
                }
            }
        }
        if (provider == null) {
            this.logger.debug("Requested icon category {} provided by no icon provider", (Object)category);
            resp.sendError(404);
            return;
        }
        try {
            provider2 = null;
            Object var10_12 = null;
            try (InputStream is = provider.getIcon(category, iconSetId, state, format);){
                if (is == null) {
                    this.logger.debug("Requested icon category {} provided by no icon provider", (Object)category);
                    resp.sendError(404);
                    return;
                }
                resp.setContentType(IconSet.Format.SVG.equals((Object)format) ? "image/svg+xml" : "image/png");
                resp.setHeader("Cache-Control", "max-age=31536000");
                is.transferTo((OutputStream)resp.getOutputStream());
                resp.flushBuffer();
            }
            catch (Throwable throwable) {
                if (provider2 == null) {
                    provider2 = throwable;
                } else if (provider2 != throwable) {
                    ((Throwable)provider2).addSuppressed(throwable);
                }
                throw provider2;
            }
        }
        catch (IOException e) {
            this.logger.error("Failed sending the icon byte stream as a response: {}", (Object)e.getMessage());
            resp.sendError(500, e.getMessage());
        }
    }

    private String substringAfterLast(@Nullable String str, String separator) {
        if (str == null) {
            return "";
        }
        int index = str.lastIndexOf(separator);
        return index == -1 || index == str.length() - separator.length() ? "" : str.substring(index + separator.length());
    }

    private String substringBeforeLast(String str, String separator) {
        int index = str.lastIndexOf(separator);
        return index == -1 ? str : str.substring(0, index);
    }

    private String getCategory(HttpServletRequest req) {
        String category = this.substringAfterLast(req.getRequestURI(), "/");
        return this.substringBeforeLast(category, ".");
    }

    private IconSet.Format getFormat(HttpServletRequest req) {
        String format = req.getParameter(PARAM_FORMAT);
        if (format == null) {
            String requestURI = req.getRequestURI();
            if (requestURI == null) {
                this.logger.debug("null request URI in HTTP request - falling back to PNG");
                return IconSet.Format.PNG;
            }
            String filename = this.substringAfterLast(requestURI, "/");
            format = this.substringAfterLast(filename, ".");
        }
        try {
            return IconSet.Format.valueOf(format.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("unknown format '{}' in HTTP request - falling back to PNG", (Object)format);
            return IconSet.Format.PNG;
        }
    }

    private String getIconSetId(HttpServletRequest req) {
        String iconSetId = req.getParameter(PARAM_ICONSET);
        if (iconSetId == null || iconSetId.isEmpty()) {
            return this.defaultIconSetId;
        }
        return iconSetId;
    }

    private @Nullable IconProvider getIconProvider(String category, String iconSetId, IconSet.Format format) {
        IconProvider topProvider = null;
        int maxPrio = Integer.MIN_VALUE;
        for (IconProvider provider : this.iconProvider) {
            Integer prio = provider.hasIcon(category, iconSetId, format);
            if (prio == null || prio <= maxPrio) continue;
            maxPrio = prio;
            topProvider = provider;
        }
        return topProvider;
    }
}

