/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.function.TriConsumer;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.util.internal.GUtil;

public class NameMatcher {
    private final SortedSet<String> matches = new TreeSet<String>();
    private final Set<String> candidates = new TreeSet<String>();
    private String pattern;
    private static final String CAMEL_CASE_TRAILING_PATTERN = "[\\p{javaLowerCase}]*";
    private static final String KEBAB_CASE_TRAILING_PATTERN = "[\\p{javaLowerCase}\\p{Digit}]*";
    private static final String KEBAB_CASE_PREFIX_TRAILING_PATTERN = "[\\p{javaLowerCase}\\p{Digit}-]*";
    private static final Pattern CAMEL_CASE_BOUNDARY_PATTERN = Pattern.compile("((^|\\p{Punct})\\p{javaLowerCase}+)|((\\p{javaUpperCase}|\\p{Digit})\\p{javaLowerCase}*)");
    private static final Pattern KEBAB_BOUNDARY_PATTERN = Pattern.compile("((^|\\p{Punct})\\p{javaLowerCase}+)|(\\p{javaUpperCase}\\p{javaLowerCase}*)");

    public <T> T find(String pattern, Map<String, ? extends T> items) {
        String name = this.find(pattern, items.keySet());
        if (name != null) {
            return items.get(name);
        }
        return null;
    }

    public String find(String pattern, Collection<String> items) {
        this.pattern = pattern;
        this.matches.clear();
        this.candidates.clear();
        if (items.contains(pattern)) {
            this.matches.add(pattern);
            return pattern;
        }
        if (pattern.isEmpty()) {
            return null;
        }
        TreeSet<String> caseInsensitiveMatches = new TreeSet<String>();
        String normalisedPattern = pattern.toUpperCase(Locale.ROOT);
        String camelCaseRegex = NameMatcher.getCamelCasePatternForName(pattern);
        Pattern camelCasePattern = Pattern.compile(camelCaseRegex);
        Pattern caseInsensitiveCamelCasePattern = Pattern.compile(camelCaseRegex, 66);
        TreeSet<String> caseInsensitivePrefixMatches = new TreeSet<String>();
        TreeSet<String> caseSensitiveCamelCaseMatches = new TreeSet<String>();
        TreeSet<String> caseInsensitiveCamelCaseMatches = new TreeSet<String>();
        String kebabCaseRegex = NameMatcher.getKebabCasePatternForName(pattern);
        Pattern kebabCasePattern = Pattern.compile(kebabCaseRegex);
        Pattern kebabCasePrefixPattern = Pattern.compile(kebabCaseRegex + KEBAB_CASE_PREFIX_TRAILING_PATTERN);
        TreeSet<String> kebabCaseMatches = new TreeSet<String>();
        TreeSet<String> kebabCasePrefixMatches = new TreeSet<String>();
        for (String candidate : items) {
            boolean found = false;
            if (candidate.equalsIgnoreCase(pattern)) {
                caseInsensitiveMatches.add(candidate);
                found = true;
            }
            if (camelCasePattern.matcher(candidate).matches()) {
                caseSensitiveCamelCaseMatches.add(candidate);
                found = true;
            }
            if (camelCasePattern.matcher(candidate).lookingAt()) {
                caseInsensitivePrefixMatches.add(candidate);
                found = true;
            }
            if (caseInsensitiveCamelCasePattern.matcher(candidate).lookingAt()) {
                caseInsensitiveCamelCaseMatches.add(candidate);
                found = true;
            }
            if (kebabCasePattern.matcher(candidate).matches()) {
                kebabCaseMatches.add(candidate);
                found = true;
            }
            if (kebabCasePrefixPattern.matcher(candidate).matches()) {
                kebabCasePrefixMatches.add(candidate);
                found = true;
            }
            if (found || StringUtils.getLevenshteinDistance((String)normalisedPattern, (String)candidate.toUpperCase(Locale.ROOT)) > Math.min(3, pattern.length() / 2)) continue;
            this.candidates.add(candidate);
        }
        if (!caseInsensitiveMatches.isEmpty()) {
            this.matches.addAll(caseInsensitiveMatches);
        } else if (!caseSensitiveCamelCaseMatches.isEmpty()) {
            this.matches.addAll(caseSensitiveCamelCaseMatches);
        } else if (!caseInsensitivePrefixMatches.isEmpty()) {
            this.matches.addAll(caseInsensitivePrefixMatches);
        } else if (kebabCaseMatches.isEmpty() && kebabCasePrefixMatches.isEmpty()) {
            this.matches.addAll(caseInsensitiveCamelCaseMatches);
        }
        if (!kebabCaseMatches.isEmpty()) {
            this.matches.addAll(kebabCaseMatches);
        } else if (!kebabCasePrefixMatches.isEmpty()) {
            this.matches.addAll(kebabCasePrefixMatches);
        }
        if (this.matches.size() == 1) {
            return this.matches.first();
        }
        return null;
    }

    private static String getCamelCasePatternForName(String name) {
        return NameMatcher.getPatternForName(name, CAMEL_CASE_BOUNDARY_PATTERN, (TriConsumer<StringBuilder, Integer, String>)((TriConsumer)(builder, pos, part) -> {
            builder.append(Pattern.quote(part));
            builder.append(CAMEL_CASE_TRAILING_PATTERN);
        }));
    }

    private static String getKebabCasePatternForName(String name) {
        return NameMatcher.getPatternForName(name, KEBAB_BOUNDARY_PATTERN, (TriConsumer<StringBuilder, Integer, String>)((TriConsumer)(builder, pos, part) -> {
            if (pos > 0) {
                builder.append('-');
            }
            builder.append(Pattern.quote(part.toLowerCase(Locale.ROOT)));
            builder.append(KEBAB_CASE_TRAILING_PATTERN);
        }));
    }

    private static String getPatternForName(String name, Pattern boundaryPattern, TriConsumer<StringBuilder, Integer, String> addPattern) {
        Matcher matcher = boundaryPattern.matcher(name);
        int pos = 0;
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            String prefix = name.substring(pos, matcher.start());
            if (!prefix.isEmpty()) {
                builder.append(Pattern.quote(prefix));
            }
            addPattern.accept((Object)builder, (Object)pos, (Object)matcher.group());
            pos = matcher.end();
        }
        if (pos < name.length()) {
            builder.append(Pattern.quote(name.substring(pos)));
        }
        return builder.toString();
    }

    public Set<String> getMatches() {
        return this.matches;
    }

    public Set<String> getCandidates() {
        return this.candidates;
    }

    public String formatErrorMessage(String singularItemDescription, Object container) {
        if (!this.matches.isEmpty()) {
            return String.format("%s '%s' is ambiguous in %s. Candidates are: %s.", singularItemDescription, this.pattern, container, GUtil.toString(this.matches));
        }
        if (!this.candidates.isEmpty()) {
            return String.format("%s '%s' not found in %s. Some candidates are: %s.", singularItemDescription, this.pattern, container, GUtil.toString(this.candidates));
        }
        return String.format("%s '%s' not found in %s.", singularItemDescription, this.pattern, container);
    }

    public ProblemId problemId() {
        if (!this.getMatches().isEmpty()) {
            return ProblemId.create((String)"ambiguous-matches", (String)"Ambiguous matches", (ProblemGroup)GradleCoreProblemGroup.taskSelection());
        }
        if (!this.getCandidates().isEmpty()) {
            return ProblemId.create((String)"no-matches", (String)"No matches", (ProblemGroup)GradleCoreProblemGroup.taskSelection());
        }
        return ProblemId.create((String)"selection-failed", (String)"Selection failed", (ProblemGroup)GradleCoreProblemGroup.taskSelection());
    }
}

