/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multiset;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.rubygrapefruit.platform.NativeException;
import org.gradle.fileevents.FileWatcher;
import org.gradle.internal.file.FileHierarchySet;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RootTrackingFileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.snapshot.SnapshotVisitResult;
import org.gradle.internal.watch.WatchingNotSupportedException;
import org.gradle.internal.watch.registry.FileWatcherProbeRegistry;
import org.gradle.internal.watch.registry.impl.AbstractFileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.SnapshotCollectingDiffListener;
import org.gradle.internal.watch.registry.impl.SnapshotWatchedDirectoryFinder;
import org.gradle.internal.watch.registry.impl.WatchableHierarchies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonHierarchicalFileWatcherUpdater
extends AbstractFileWatcherUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonHierarchicalFileWatcherUpdater.class);
    private final FileWatcher fileWatcher;
    private final Multiset<String> watchedDirectories = HashMultiset.create();
    private final Map<String, String> watchedDirectoryForSnapshot = new HashMap<String, String>();
    private final Set<String> watchedWatchableHierarchies = new HashSet<String>();

    public NonHierarchicalFileWatcherUpdater(FileWatcher fileWatcher, FileWatcherProbeRegistry probeRegistry, WatchableHierarchies watchableHierarchies, AbstractFileWatcherUpdater.MovedDirectoryHandler movedDirectoryHandler) {
        super(probeRegistry, watchableHierarchies, movedDirectoryHandler);
        this.fileWatcher = fileWatcher;
    }

    @Override
    protected boolean handleVirtualFileSystemContentsChanged(Collection<FileSystemLocationSnapshot> removedSnapshots, Collection<FileSystemLocationSnapshot> addedSnapshots, SnapshotHierarchy root) {
        HashMap<String, Integer> changedWatchedDirectories = new HashMap<String, Integer>();
        removedSnapshots.stream().filter(this.watchableHierarchies::shouldWatch).forEach(snapshot -> {
            String previousWatchedRoot = this.watchedDirectoryForSnapshot.remove(snapshot.getAbsolutePath());
            NonHierarchicalFileWatcherUpdater.decrement(previousWatchedRoot, changedWatchedDirectories);
            snapshot.accept((FileSystemSnapshotHierarchyVisitor)new SubdirectoriesToWatchVisitor(path -> NonHierarchicalFileWatcherUpdater.decrement(path, changedWatchedDirectories)));
        });
        addedSnapshots.stream().filter(this.watchableHierarchies::shouldWatch).forEach(snapshot -> {
            File directoryToWatchForRoot = SnapshotWatchedDirectoryFinder.getDirectoryToWatch(snapshot);
            String pathToWatchForRoot = directoryToWatchForRoot.getAbsolutePath();
            if (!this.watchableHierarchies.isInWatchableHierarchy(pathToWatchForRoot)) {
                return;
            }
            this.watchedDirectoryForSnapshot.put(snapshot.getAbsolutePath(), pathToWatchForRoot);
            NonHierarchicalFileWatcherUpdater.increment(pathToWatchForRoot, changedWatchedDirectories);
            snapshot.accept((FileSystemSnapshotHierarchyVisitor)new SubdirectoriesToWatchVisitor(path -> NonHierarchicalFileWatcherUpdater.increment(path, changedWatchedDirectories)));
        });
        if (changedWatchedDirectories.isEmpty()) {
            return false;
        }
        this.updateWatchedDirectories(changedWatchedDirectories);
        return true;
    }

    @Override
    protected void updateWatchesOnChangedWatchedFiles(FileHierarchySet newWatchedFiles) {
        HashMap<String, Integer> changedWatchDirectories = new HashMap<String, Integer>();
        this.watchedWatchableHierarchies.forEach(absolutePath -> NonHierarchicalFileWatcherUpdater.decrement(absolutePath, changedWatchDirectories));
        this.watchedWatchableHierarchies.clear();
        newWatchedFiles.visitRoots(absolutePath -> {
            this.watchedWatchableHierarchies.add(absolutePath);
            NonHierarchicalFileWatcherUpdater.increment(absolutePath, changedWatchDirectories);
        });
        if (!changedWatchDirectories.isEmpty()) {
            this.updateWatchedDirectories(changedWatchDirectories);
        }
    }

    @Override
    protected WatchableHierarchies.Invalidator createInvalidator() {
        return (location, currentRoot) -> {
            SnapshotCollectingDiffListener diffListener = new SnapshotCollectingDiffListener();
            SnapshotHierarchy invalidatedRoot = currentRoot.invalidate(location, (SnapshotHierarchy.NodeDiffListener)diffListener);
            diffListener.publishSnapshotDiff((removedSnapshots, addedSnapshots) -> this.virtualFileSystemContentsChanged(removedSnapshots, addedSnapshots, invalidatedRoot));
            return invalidatedRoot;
        };
    }

    @Override
    protected void startWatchingProbeDirectory(File probeDirectory) {
        this.updateWatchedDirectories((Map<String, Integer>)ImmutableMap.of((Object)probeDirectory.getAbsolutePath(), (Object)1));
    }

    @Override
    protected void stopWatchingProbeDirectory(File probeDirectory) {
        this.updateWatchedDirectories((Map<String, Integer>)ImmutableMap.of((Object)probeDirectory.getAbsolutePath(), (Object)-1));
    }

    private void updateWatchedDirectories(Map<String, Integer> changedWatchDirectories) {
        HashSet directoriesToStopWatching = new HashSet();
        HashSet directoriesToStartWatching = new HashSet();
        changedWatchDirectories.forEach((absolutePath, value) -> {
            int contained;
            int count = value;
            if (count < 0) {
                int toRemove = -count;
                int contained2 = this.watchedDirectories.remove(absolutePath, toRemove);
                if (contained2 <= toRemove) {
                    directoriesToStopWatching.add(new File((String)absolutePath));
                }
            } else if (count > 0 && (contained = this.watchedDirectories.add(absolutePath, count)) == 0) {
                directoriesToStartWatching.add(new File((String)absolutePath));
            }
        });
        LOGGER.debug("Watching {} directories to track changes", (Object)this.watchedDirectories.entrySet().size());
        try {
            if (!directoriesToStopWatching.isEmpty() && !this.fileWatcher.stopWatching(directoriesToStopWatching)) {
                LOGGER.debug("Couldn't stop watching directories: {}", directoriesToStopWatching);
            }
            if (!directoriesToStartWatching.isEmpty()) {
                this.fileWatcher.startWatching(directoriesToStartWatching);
            }
        }
        catch (NativeException e) {
            if (e.getMessage().contains("Already watching path: ")) {
                throw new WatchingNotSupportedException("Unable to watch same file twice via different paths: " + e.getMessage(), e);
            }
            throw e;
        }
    }

    private static void decrement(String path, Map<String, Integer> changedWatchedDirectories) {
        changedWatchedDirectories.compute(path, (key, value) -> NonHierarchicalFileWatcherUpdater.zeroToNull(NonHierarchicalFileWatcherUpdater.nullToZero(value) - 1));
    }

    private static void increment(String path, Map<String, Integer> changedWatchedDirectories) {
        changedWatchedDirectories.compute(path, (key, value) -> NonHierarchicalFileWatcherUpdater.zeroToNull(NonHierarchicalFileWatcherUpdater.nullToZero(value) + 1));
    }

    @Nullable
    private static Integer zeroToNull(int value) {
        return value == 0 ? null : Integer.valueOf(value);
    }

    private static int nullToZero(@Nullable Integer value) {
        return value == null ? 0 : value;
    }

    private class SubdirectoriesToWatchVisitor
    extends RootTrackingFileSystemSnapshotHierarchyVisitor {
        private final Consumer<String> subDirectoryToWatchConsumer;

        public SubdirectoriesToWatchVisitor(Consumer<String> subDirectoryToWatchConsumer) {
            this.subDirectoryToWatchConsumer = subDirectoryToWatchConsumer;
        }

        public SnapshotVisitResult visitEntry(FileSystemLocationSnapshot snapshot, boolean isRoot) {
            if (isRoot) {
                return SnapshotVisitResult.CONTINUE;
            }
            return (SnapshotVisitResult)snapshot.accept((FileSystemLocationSnapshot.FileSystemLocationSnapshotTransformer)new FileSystemLocationSnapshot.FileSystemLocationSnapshotTransformer<SnapshotVisitResult>(){

                public SnapshotVisitResult visitDirectory(DirectorySnapshot directorySnapshot) {
                    if (NonHierarchicalFileWatcherUpdater.this.watchableHierarchies.ignoredForWatching((FileSystemLocationSnapshot)directorySnapshot)) {
                        return SnapshotVisitResult.SKIP_SUBTREE;
                    }
                    SubdirectoriesToWatchVisitor.this.subDirectoryToWatchConsumer.accept(directorySnapshot.getAbsolutePath());
                    return SnapshotVisitResult.CONTINUE;
                }

                public SnapshotVisitResult visitRegularFile(RegularFileSnapshot fileSnapshot) {
                    return SnapshotVisitResult.CONTINUE;
                }

                public SnapshotVisitResult visitMissing(MissingFileSnapshot missingSnapshot) {
                    return SnapshotVisitResult.CONTINUE;
                }
            });
        }
    }
}

