/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.jvm.toolchain.JavaCompiler;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavadocTool;
import org.gradle.jvm.toolchain.internal.operations.JavaToolchainUsageProgressDetails;

public class DefaultJavaToolchainUsageProgressDetails
implements JavaToolchainUsageProgressDetails {
    private final JavaTool toolName;
    private final JvmInstallationMetadata toolchainMetadata;

    public DefaultJavaToolchainUsageProgressDetails(JavaTool toolName, JvmInstallationMetadata toolchainMetadata) {
        this.toolName = toolName;
        this.toolchainMetadata = toolchainMetadata;
    }

    public String getToolName() {
        return this.toolName.getToolName();
    }

    public JavaToolchainUsageProgressDetails.JavaToolchain getToolchain() {
        final JvmInstallationMetadata metadata = this.toolchainMetadata;
        return new JavaToolchainUsageProgressDetails.JavaToolchain(){

            public String getJavaVersion() {
                return metadata.getJavaVersion();
            }

            public String getJavaVendor() {
                return metadata.getVendor().getDisplayName();
            }

            public String getRuntimeName() {
                return metadata.getRuntimeName();
            }

            public String getRuntimeVersion() {
                return metadata.getRuntimeVersion();
            }

            public String getJvmName() {
                return metadata.getJvmName();
            }

            public String getJvmVersion() {
                return metadata.getJvmVersion();
            }

            public String getJvmVendor() {
                return metadata.getJvmVendor();
            }

            public String getArchitecture() {
                return metadata.getArchitecture();
            }
        };
    }

    public static enum JavaTool {
        COMPILER(JavaCompiler.class.getSimpleName()),
        LAUNCHER(JavaLauncher.class.getSimpleName()),
        JAVADOC(JavadocTool.class.getSimpleName());

        private final String toolName;

        private JavaTool(String toolName) {
            this.toolName = toolName;
        }

        public String getToolName() {
            return this.toolName;
        }
    }
}

