/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.toolchain;

import java.util.Collection;
import java.util.Collections;
import org.gradle.internal.logging.text.DiagnosticsVisitor;
import org.gradle.platform.base.internal.toolchain.SearchResult;

public class ComponentNotFound<T>
implements SearchResult<T> {
    private final String message;
    private final Collection<String> locations;

    public ComponentNotFound(String message) {
        this.message = message;
        this.locations = Collections.emptyList();
    }

    public ComponentNotFound(String message, Collection<String> locations) {
        this.message = message;
        this.locations = locations;
    }

    @Override
    public T getComponent() {
        return null;
    }

    @Override
    public boolean isAvailable() {
        return false;
    }

    @Override
    public void explain(DiagnosticsVisitor visitor) {
        visitor.node(this.message);
        if (!this.locations.isEmpty()) {
            visitor.startChildren();
            for (String location : this.locations) {
                visitor.node(location);
            }
            visitor.endChildren();
        }
    }
}

