/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import jnr.ffi.Platform;
import jnr.netdb.NetDBEntry;
import jnr.netdb.NetDBParser;
import jnr.netdb.Protocol;
import jnr.netdb.ProtocolsDB;

class FileProtocolsDB
implements ProtocolsDB {
    private final File protocolsFile;

    public static final FileProtocolsDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    FileProtocolsDB(File protocolsFile) {
        this.protocolsFile = protocolsFile;
    }

    private static final File locateProtocolsFile() {
        if (Platform.getNativePlatform().getOS().equals((Object)Platform.OS.WINDOWS)) {
            String systemRoot;
            try {
                systemRoot = System.getProperty("SystemRoot", "C:\\windows");
            }
            catch (SecurityException se) {
                systemRoot = "C:\\windows";
            }
            return new File(systemRoot + "\\system32\\drivers\\etc\\protocol");
        }
        return new File("/etc/protocols");
    }

    private static FileProtocolsDB load() {
        try {
            File protocolsFile = FileProtocolsDB.locateProtocolsFile();
            try (NetDBParser parser = new NetDBParser(new FileReader(protocolsFile));){
                parser.iterator().next();
            }
            return new FileProtocolsDB(protocolsFile);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public Protocol getProtocolByName(final String name2) {
        return this.parse(new Filter(){

            @Override
            public boolean filter(Protocol p2) {
                if (p2.getName().equals(name2)) {
                    return true;
                }
                for (String alias : p2.getAliases()) {
                    if (!alias.equals(name2)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public Protocol getProtocolByNumber(final Integer proto) {
        return this.parse(new Filter(){

            @Override
            public boolean filter(Protocol p2) {
                return p2.getProto() == proto.intValue();
            }
        });
    }

    @Override
    public Collection<Protocol> getAllProtocols() {
        final LinkedList allProtocols = new LinkedList();
        this.parse(new Filter(){

            @Override
            public boolean filter(Protocol s2) {
                allProtocols.add(s2);
                return false;
            }
        });
        return Collections.unmodifiableList(allProtocols);
    }

    private final NetDBParser loadProtocolsFile() {
        try {
            return new NetDBParser(new FileReader(this.protocolsFile));
        }
        catch (FileNotFoundException ex) {
            return new NetDBParser(new StringReader(""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Protocol parse(Filter filter) {
        NetDBParser parser = this.loadProtocolsFile();
        try {
            for (NetDBEntry e : parser) {
                try {
                    Protocol p2 = new Protocol(e.name, Integer.parseInt(e.data, 10), e.aliases);
                    if (!filter.filter(p2)) continue;
                    Protocol protocol2 = p2;
                    return protocol2;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        finally {
            try {
                parser.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    static /* synthetic */ FileProtocolsDB access$000() {
        return FileProtocolsDB.load();
    }

    private static interface Filter {
        public boolean filter(Protocol var1);
    }

    private static final class SingletonHolder {
        public static final FileProtocolsDB INSTANCE = FileProtocolsDB.access$000();

        private SingletonHolder() {
        }
    }
}

