/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReceiveIndexedArgBase;
import org.jruby.ir.instructions.RestArgMultipleAsgnInstr;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ReceiveRestArgInstr
extends ReceiveIndexedArgBase
implements FixedArityInstr {
    public final int required;

    public ReceiveRestArgInstr(Variable result2, Variable keywords, int argIndex, int required) {
        super(Operation.RECV_REST_ARG, result2, keywords, argIndex);
        this.required = required;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"index: " + this.getArgIndex(), "req: " + this.required};
    }

    @Override
    public Instr clone(CloneInfo info) {
        if (info instanceof SimpleCloneInfo) {
            return new ReceiveRestArgInstr(info.getRenamedVariable(this.result), info.getRenamedVariable(this.getKeywords()), this.argIndex, this.required);
        }
        InlineCloneInfo ii = (InlineCloneInfo)info;
        if (ii.canMapArgsStatically()) {
            return new CopyInstr(ii.getRenamedVariable(this.result), ii.getArg(this.argIndex, true));
        }
        return new RestArgMultipleAsgnInstr(ii.getRenamedVariable(this.result), ii.getArgs(), this.argIndex, this.argIndex, this.required - this.argIndex);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.required);
    }

    public static ReceiveRestArgInstr decode(IRReaderDecoder d) {
        return new ReceiveRestArgInstr(d.decodeVariable(), d.decodeVariable(), d.decodeInt(), d.decodeInt());
    }

    @Override
    public IRubyObject receiveArg(ThreadContext context, IRubyObject self2, DynamicScope currDynScope, StaticScope currScope, Object[] temp, IRubyObject[] args2, boolean ruby2keyword) {
        IRubyObject keywords = (IRubyObject)this.getKeywords().retrieve(context, self2, currScope, currDynScope, temp);
        return IRRuntimeHelpers.receiveRestArg(context, args2, keywords, this.required, this.argIndex);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ReceiveRestArgInstr(this);
    }
}

