/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.ext;

import java.nio.CharBuffer;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.api.Convert;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ext.JavaExtensions;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Inspector;
import org.jruby.util.RubyStringBuilder;

public abstract class JavaNio {
    public static void define(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        JavaExtensions.put(runtime2, java.nio.Buffer.class, proxy2 -> Buffer.define(context, (RubyClass)proxy2));
        JavaExtensions.put(runtime2, CharBuffer.class, proxy2 -> proxy2.addMethod(context, "inspect", new InspectBuffer((RubyModule)proxy2)));
    }

    private static final class InspectBuffer
    extends JavaMethod.JavaMethodZero {
        InspectBuffer(RubyModule implClass) {
            super(implClass, Visibility.PUBLIC, "inspect");
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
            java.nio.Buffer obj = (java.nio.Buffer)JavaUtil.unwrapIfJavaObject(self2);
            RubyString buf = Inspector.inspectPrefix(context, self2.getMetaClass(), System.identityHashCode(obj));
            RubyStringBuilder.cat(context.runtime, buf, Inspector.SPACE);
            buf.catString("position=" + obj.position() + ", limit=" + obj.limit() + ", capacity=" + obj.capacity() + ", readOnly=" + obj.isReadOnly());
            RubyStringBuilder.cat(context.runtime, buf, Inspector.GT);
            return buf;
        }
    }

    @JRubyModule(name={"Java::JavaNio::Buffer"})
    public static class Buffer {
        static RubyModule define(ThreadContext context, RubyClass proxy2) {
            ((RubyModule)proxy2.defineMethods(context, Buffer.class)).addMethod(context, "inspect", new InspectBuffer(proxy2));
            return proxy2;
        }

        @JRubyMethod(name={"length", "size"})
        public static IRubyObject length(ThreadContext context, IRubyObject self2) {
            java.nio.Buffer obj = self2.toJava(java.nio.Buffer.class);
            return Convert.asFixnum(context, obj.remaining());
        }
    }
}

