/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.opto;

import java.lang.invoke.SwitchPoint;
import java.util.List;
import org.jruby.RubyModule;
import org.jruby.runtime.opto.GenerationInvalidator;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.runtime.opto.SwitchPointInvalidator;

public class GenerationAndSwitchPointInvalidator
implements Invalidator {
    private final GenerationInvalidator generationInvalidator;
    private final SwitchPointInvalidator switchPointInvalidator;

    public GenerationAndSwitchPointInvalidator(RubyModule module) {
        this.generationInvalidator = new GenerationInvalidator(module);
        this.switchPointInvalidator = new SwitchPointInvalidator();
    }

    @Override
    public void invalidate() {
        this.generationInvalidator.invalidate();
        this.switchPointInvalidator.invalidate();
    }

    @Override
    public void invalidateAll(List<Invalidator> invalidators) {
        if (invalidators.isEmpty()) {
            return;
        }
        SwitchPoint[] switchPoints = new SwitchPoint[invalidators.size()];
        for (int i2 = 0; i2 < invalidators.size(); ++i2) {
            Invalidator invalidator = invalidators.get(i2);
            assert (invalidator instanceof SwitchPointInvalidator);
            SwitchPointInvalidator switchPointInvalidator = (SwitchPointInvalidator)invalidator;
            switchPoints[i2] = switchPointInvalidator.replaceSwitchPoint();
        }
        SwitchPoint.invalidateAll(switchPoints);
    }

    @Override
    public Object getData() {
        return this.switchPointInvalidator.getData();
    }

    @Override
    public void addIfUsed(RubyModule.InvalidatorList invalidators) {
        this.generationInvalidator.invalidate();
        this.switchPointInvalidator.addIfUsed(invalidators);
    }
}

