/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.util.ByteList;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.StringSupport;

public class ByteListHelper {
    public static boolean eachCodePoint(ByteList bytelist, CodePoint each2) {
        int n;
        byte[] bytes2 = bytelist.unsafeBytes();
        int len = bytelist.getRealSize();
        Encoding encoding2 = bytelist.getEncoding();
        int begin2 = bytelist.begin();
        int end2 = begin2 + len;
        for (int i2 = 0; i2 < len; i2 += n) {
            int realIndex = begin2 + i2;
            n = StringSupport.encFastMBCLen(bytes2, realIndex, end2, encoding2);
            if (each2.call(i2, encoding2.mbcToCode(bytes2, realIndex, end2), encoding2)) continue;
            return false;
        }
        return true;
    }

    public static int eachCodePointWhile(Ruby runtime2, ByteList bytelist, int offset2, CodePoint each2) {
        Encoding encoding2 = bytelist.getEncoding();
        if (encoding2 != USASCIIEncoding.INSTANCE) {
            return ByteListHelper.eachMBCCodePointWhile(bytelist, offset2, each2);
        }
        byte[] bytes2 = bytelist.unsafeBytes();
        int len = bytelist.getRealSize();
        int begin2 = bytelist.begin();
        int end2 = begin2 + len;
        for (int i2 = offset2; i2 < end2; ++i2) {
            byte c = bytes2[i2];
            if (!Encoding.isAscii(c)) {
                throw runtime2.newEncodingError(RubyStringBuilder.str(runtime2, "invalid symbol in encoding " + String.valueOf(encoding2) + " :", RubyStringBuilder.inspectIdentifierByteList(runtime2, bytelist)));
            }
            if (each2.call(i2, bytes2[i2] & 0xFF, encoding2)) continue;
            return i2;
        }
        return len;
    }

    private static int eachMBCCodePointWhile(ByteList bytelist, int offset2, CodePoint each2) {
        int n;
        Encoding encoding2 = bytelist.getEncoding();
        byte[] bytes2 = bytelist.unsafeBytes();
        int len = bytelist.getRealSize();
        int begin2 = bytelist.begin();
        int end2 = begin2 + len;
        int i2 = 0;
        for (int p2 = begin2 + offset2; p2 < end2; p2 += n) {
            n = StringSupport.length(encoding2, bytes2, p2, end2);
            if (!each2.call(i2, encoding2.mbcToCode(bytes2, p2, end2), encoding2)) {
                return p2;
            }
            ++i2;
        }
        return len;
    }

    @Deprecated(since="9.4-")
    public static <T> T split(ByteList value2, ByteList pattern, Visit<ByteList, T> bodyVisitor, Visit<ByteList, T> headVisitor) {
        int patternIndex;
        if (headVisitor == null) {
            headVisitor = bodyVisitor;
        }
        Encoding enc = pattern.getEncoding();
        byte[] bytes2 = value2.getUnsafeBytes();
        int begin2 = value2.getBegin();
        int realSize = value2.getRealSize();
        int end2 = begin2 + realSize;
        int currentOffset = 0;
        int i2 = 0;
        Object current2 = null;
        while (currentOffset < realSize && (patternIndex = value2.indexOf(pattern, currentOffset)) >= 0) {
            int t = enc.rightAdjustCharHead(bytes2, currentOffset + begin2, patternIndex + begin2, end2) - begin2;
            if (t != patternIndex) {
                currentOffset = t;
            } else {
                current2 = bodyVisitor.call(i2, value2.makeShared(currentOffset, patternIndex - currentOffset), current2);
                if (current2 == null) {
                    return null;
                }
                currentOffset = patternIndex + pattern.getRealSize();
            }
            ++i2;
        }
        return headVisitor.call(i2, value2.makeShared(currentOffset, realSize - currentOffset), current2);
    }

    public static interface CodePoint {
        public boolean call(int var1, int var2, Encoding var3);
    }

    public static interface Visit<T, U> {
        public U call(int var1, T var2, U var3);
    }
}

