/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import java.io.IOException;
import java.io.OutputStream;
import json.ext.ByteListTranscoder;
import json.ext.Utils;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ByteList;

final class StringEncoder
extends ByteListTranscoder {
    private final boolean asciiOnly;
    private final boolean scriptSafe;
    private OutputStream out;
    private final byte[] aux = new byte[]{92, 117, 0, 0, 0, 0, 92, 117, 0, 0, 0, 0, 92, 0};
    private static final int ESCAPE_UNI1_OFFSET = 0;
    private static final int ESCAPE_UNI2_OFFSET = 6;
    private static final int ESCAPE_CHAR_OFFSET = 12;
    private final char[] utf16 = new char[2];
    private static final byte[] HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    StringEncoder(boolean bl, boolean bl2) {
        this.asciiOnly = bl;
        this.scriptSafe = bl2;
    }

    void encode(ThreadContext threadContext, ByteList byteList, OutputStream outputStream) throws IOException {
        this.init(byteList);
        this.out = outputStream;
        this.append(34);
        while (this.hasNext()) {
            this.handleChar(this.readUtf8Char(threadContext));
        }
        this.quoteStop(this.pos);
        this.append(34);
    }

    void encodeASCII(ThreadContext threadContext, ByteList byteList, OutputStream outputStream) throws IOException {
        this.init(byteList);
        this.out = outputStream;
        this.append(34);
        while (this.hasNext()) {
            this.handleChar(this.readASCIIChar());
        }
        this.quoteStop(this.pos);
        this.append(34);
    }

    @Override
    protected void append(int n) throws IOException {
        this.out.write(n);
    }

    @Override
    protected void append(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    private void handleChar(int n) throws IOException {
        switch (n) {
            case 34: 
            case 92: {
                this.escapeChar((char)n);
                break;
            }
            case 10: {
                this.escapeChar('n');
                break;
            }
            case 13: {
                this.escapeChar('r');
                break;
            }
            case 9: {
                this.escapeChar('t');
                break;
            }
            case 12: {
                this.escapeChar('f');
                break;
            }
            case 8: {
                this.escapeChar('b');
                break;
            }
            case 47: {
                if (this.scriptSafe) {
                    this.escapeChar((char)n);
                    break;
                }
            }
            case 8232: 
            case 8233: {
                if (this.scriptSafe) {
                    this.quoteStop(this.charStart);
                    this.escapeUtf8Char(n);
                    break;
                }
            }
            default: {
                if (n >= 32 && n <= 127 || n >= 128 && !this.asciiOnly) {
                    this.quoteStart();
                    break;
                }
                this.quoteStop(this.charStart);
                this.escapeUtf8Char(n);
            }
        }
    }

    private void escapeChar(char c) throws IOException {
        this.quoteStop(this.charStart);
        this.aux[13] = (byte)c;
        this.append(this.aux, 12, 2);
    }

    private void escapeUtf8Char(int n) throws IOException {
        int n2 = Character.toChars(n, this.utf16, 0);
        this.escapeCodeUnit(this.utf16[0], 2);
        if (n2 > 1) {
            this.escapeCodeUnit(this.utf16[1], 8);
        }
        this.append(this.aux, 0, 6 * n2);
    }

    private void escapeCodeUnit(char c, int n) {
        for (int i = 0; i < 4; ++i) {
            this.aux[n + i] = HEX[c >>> 12 - 4 * i & 0xF];
        }
    }

    @Override
    protected RaiseException invalidUtf8(ThreadContext threadContext) {
        return Utils.newException(threadContext, "GeneratorError", "source sequence is illegal/malformed utf-8");
    }
}

