/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.DummyX509KeyManager;
import org.bouncycastle.jsse.provider.JsseSecurityParameters;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.NamedGroupInfo;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvDHGroupVerifier;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.SignatureSchemeInfo;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatusRequest;
import org.bouncycastle.tls.CertificateStatusRequestItemV2;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.OCSPStatusRequest;
import org.bouncycastle.tls.ProtocolName;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerName;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.SignatureAlgorithm;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsDHGroupVerifier;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsServerCertificate;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.TrustedAuthority;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.IPAddress;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvTlsClient
extends DefaultTlsClient
implements ProvTlsPeer {
    private static final Logger LOG = Logger.getLogger(ProvTlsClient.class.getName());
    private static final boolean provClientEnableCA = PropertyUtils.getBooleanSystemProperty("jdk.tls.client.enableCAExtension", false);
    private static final boolean provClientEnableSessionResumption = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.client.enableSessionResumption", true);
    private static final boolean provClientEnableStatusRequest = PropertyUtils.getBooleanSystemProperty("jdk.tls.client.enableStatusRequestExtension", true);
    private static final boolean provClientEnableTrustedCAKeys = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.client.enableTrustedCAKeysExtension", false);
    private static final boolean provClientOmitSigAlgsCert = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.client.omitSigAlgsCertExtension", true);
    private static final boolean provEnableSNIExtension = PropertyUtils.getBooleanSystemProperty("jsse.enableSNIExtension", true);
    protected final String clientID;
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected final JsseSecurityParameters jsseSecurityParameters = new JsseSecurityParameters();
    protected ProvSSLSession sslSession = null;
    protected boolean handshakeComplete = false;

    ProvTlsClient(ProvTlsManager provTlsManager, ProvSSLParameters provSSLParameters) {
        super(provTlsManager.getContextData().getCrypto());
        this.clientID = JsseUtils.getPeerID("client", provTlsManager);
        this.manager = provTlsManager;
        this.sslParameters = provSSLParameters.copyForConnection();
    }

    @Override
    public String getID() {
        return this.clientID;
    }

    @Override
    public ProvSSLSession getSession() {
        return this.sslSession;
    }

    @Override
    public TlsContext getTlsContext() {
        return this.context;
    }

    @Override
    protected Vector<X500Name> getCertificateAuthorities() {
        if (provClientEnableCA) {
            return JsseUtils.getCertificateAuthorities(this.manager.getContextData().getX509TrustManager());
        }
        return null;
    }

    @Override
    protected CertificateStatusRequest getCertificateStatusRequest() {
        if (!provClientEnableStatusRequest) {
            return null;
        }
        OCSPStatusRequest oCSPStatusRequest = new OCSPStatusRequest(null, null);
        return new CertificateStatusRequest(1, oCSPStatusRequest);
    }

    @Override
    protected Vector<CertificateStatusRequestItemV2> getMultiCertStatusRequest() {
        if (!provClientEnableStatusRequest) {
            return null;
        }
        OCSPStatusRequest oCSPStatusRequest = new OCSPStatusRequest(null, null);
        Vector<CertificateStatusRequestItemV2> vector = new Vector<CertificateStatusRequestItemV2>(2);
        vector.add(new CertificateStatusRequestItemV2(2, oCSPStatusRequest));
        vector.add(new CertificateStatusRequestItemV2(1, oCSPStatusRequest));
        return vector;
    }

    @Override
    protected Vector<ProtocolName> getProtocolNames() {
        return JsseUtils.getProtocolNames(this.sslParameters.getApplicationProtocols());
    }

    @Override
    protected Vector<Integer> getSupportedGroups(Vector vector) {
        return NamedGroupInfo.getSupportedGroupsLocalClient(this.jsseSecurityParameters.namedGroups);
    }

    @Override
    protected Vector<ServerName> getSNIServerNames() {
        if (provEnableSNIExtension) {
            Object object;
            List<BCSNIServerName> list = this.sslParameters.getServerNames();
            if (null == list && null != (object = this.manager.getPeerHostSNI()) && ((String)object).indexOf(46) > 0 && !IPAddress.isValid((String)object)) {
                try {
                    list = Collections.singletonList(new BCSNIHostName((String)object));
                }
                catch (RuntimeException runtimeException) {
                    LOG.fine(this.clientID + ": Failed to add peer host as default SNI host_name: " + (String)object);
                }
            }
            if (null != list && !list.isEmpty()) {
                object = new Vector(list.size());
                for (BCSNIServerName bCSNIServerName : list) {
                    ((Vector)object).add(new ServerName((short)bCSNIServerName.getType(), bCSNIServerName.getEncoded()));
                }
                return object;
            }
        }
        return null;
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return this.manager.getContextData().getContext().getActiveCipherSuites(this.getCrypto(), this.sslParameters, this.getProtocolVersions());
    }

    @Override
    protected Vector<SignatureAndHashAlgorithm> getSupportedSignatureAlgorithms() {
        return this.jsseSecurityParameters.signatureSchemes.getLocalSignatureAndHashAlgorithms();
    }

    @Override
    protected Vector<SignatureAndHashAlgorithm> getSupportedSignatureAlgorithmsCert() {
        Vector<SignatureAndHashAlgorithm> vector = this.jsseSecurityParameters.signatureSchemes.getLocalSignatureAndHashAlgorithmsCert();
        if (vector == null && !provClientOmitSigAlgsCert) {
            vector = this.jsseSecurityParameters.signatureSchemes.getLocalSignatureAndHashAlgorithms();
        }
        return vector;
    }

    @Override
    protected ProtocolVersion[] getSupportedVersions() {
        return this.manager.getContextData().getContext().getActiveProtocolVersions(this.sslParameters);
    }

    @Override
    protected Vector<TrustedAuthority> getTrustedCAIndication() {
        Vector<X500Name> vector;
        if (provClientEnableTrustedCAKeys && null != (vector = JsseUtils.getCertificateAuthorities(this.manager.getContextData().getX509TrustManager()))) {
            Vector<TrustedAuthority> vector2 = new Vector<TrustedAuthority>(vector.size());
            for (X500Name x500Name : vector) {
                vector2.add(new TrustedAuthority(2, x500Name));
            }
            return vector2;
        }
        return null;
    }

    @Override
    public boolean allowLegacyResumption() {
        return JsseUtils.allowLegacyResumption();
    }

    @Override
    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    @Override
    public TlsDHGroupVerifier getDHGroupVerifier() {
        return new ProvDHGroupVerifier();
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            @Override
            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                ContextData contextData = ProvTlsClient.this.manager.getContextData();
                SecurityParameters securityParameters = ProvTlsClient.this.context.getSecurityParametersHandshake();
                ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
                boolean bl = TlsUtils.isTLSv13(protocolVersion);
                Principal[] principalArray = securityParameters.getServerSigAlgs();
                Object object = securityParameters.getServerSigAlgsCert();
                Object object2 = contextData.getSignatureSchemes((Vector<SignatureAndHashAlgorithm>)principalArray);
                List<SignatureSchemeInfo> list = null;
                if (object != principalArray) {
                    list = contextData.getSignatureSchemes((Vector<SignatureAndHashAlgorithm>)object);
                }
                ProvTlsClient.this.jsseSecurityParameters.signatureSchemes.notifyPeerData((List<SignatureSchemeInfo>)object2, list);
                if (LOG.isLoggable(Level.FINEST)) {
                    String string = ProvTlsClient.this.clientID + " peer signature_algorithms";
                    LOG.finest(JsseUtils.getSignatureAlgorithmsReport(string, object2));
                    if (list != null) {
                        string = ProvTlsClient.this.clientID + " peer signature_algorithms_cert";
                        LOG.finest(JsseUtils.getSignatureAlgorithmsReport(string, list));
                    }
                }
                if (DummyX509KeyManager.INSTANCE == contextData.getX509KeyManager()) {
                    return null;
                }
                principalArray = JsseUtils.toX500Principals(certificateRequest.getCertificateAuthorities());
                object = certificateRequest.getCertificateRequestContext();
                if (bl != (null != object)) {
                    throw new TlsFatalAlert(80);
                }
                object2 = certificateRequest.getCertificateTypes();
                if (bl != (null == object2)) {
                    throw new TlsFatalAlert(80);
                }
                if (bl) {
                    return ProvTlsClient.this.selectClientCredentials13(principalArray, (byte[])object);
                }
                if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion)) {
                    return ProvTlsClient.this.selectClientCredentials12(principalArray, (short[])object2);
                }
                return ProvTlsClient.this.selectClientCredentialsLegacy(principalArray, (short[])object2);
            }

            @Override
            public void notifyServerCertificate(TlsServerCertificate tlsServerCertificate) throws IOException {
                if (null == tlsServerCertificate || null == tlsServerCertificate.getCertificate() || tlsServerCertificate.getCertificate().isEmpty()) {
                    throw new TlsFatalAlert(40);
                }
                X509Certificate[] x509CertificateArray = JsseUtils.getX509CertificateChain(ProvTlsClient.this.getCrypto(), tlsServerCertificate.getCertificate());
                String string = JsseUtils.getAuthTypeServer(ProvTlsClient.this.context.getSecurityParametersHandshake().getKeyExchangeAlgorithm());
                ProvTlsClient.this.jsseSecurityParameters.statusResponses = JsseUtils.getStatusResponses(tlsServerCertificate.getCertificateStatus());
                ProvTlsClient.this.manager.checkServerTrusted(x509CertificateArray, string);
            }
        };
    }

    @Override
    public JcaTlsCrypto getCrypto() {
        return this.manager.getContextData().getCrypto();
    }

    @Override
    public int getMaxCertificateChainLength() {
        return JsseUtils.getMaxCertificateChainLength();
    }

    @Override
    public int getMaxHandshakeMessageSize() {
        return JsseUtils.getMaxHandshakeMessageSize();
    }

    @Override
    public TlsSession getSessionToResume() {
        if (provClientEnableSessionResumption) {
            SessionParameters sessionParameters;
            Object object;
            ProvSSLSession provSSLSession = this.sslParameters.getSessionToResume();
            if (null == provSSLSession) {
                object = this.manager.getContextData().getClientSessionContext();
                provSSLSession = ((ProvSSLSessionContext)object).getSessionImpl(this.manager.getPeerHost(), this.manager.getPeerPort());
            }
            if (null != provSSLSession && null != (sessionParameters = this.getResumableSessionParameters(provSSLSession, (TlsSession)(object = provSSLSession.getTlsSession())))) {
                this.sslSession = provSSLSession;
                if (!this.manager.getEnableSessionCreation()) {
                    this.cipherSuites = new int[]{sessionParameters.getCipherSuite()};
                }
                return object;
            }
        }
        JsseUtils.checkSessionCreationEnabled(this.manager);
        return null;
    }

    @Override
    public void notifyAlertRaised(short s, short s2, String string, Throwable throwable) {
        Level level;
        super.notifyAlertRaised(s, s2, string, throwable);
        Level level2 = s == 1 ? Level.FINE : (level = s2 == 80 ? Level.WARNING : Level.INFO);
        if (LOG.isLoggable(level)) {
            String string2 = JsseUtils.getAlertRaisedLogMessage(this.clientID, s, s2);
            if (string != null) {
                string2 = string2 + ": " + string;
            }
            LOG.log(level, string2, throwable);
        }
    }

    @Override
    public void notifyAlertReceived(short s, short s2) {
        Level level;
        super.notifyAlertReceived(s, s2);
        Level level2 = level = s == 1 ? Level.FINE : Level.INFO;
        if (LOG.isLoggable(level)) {
            String string = JsseUtils.getAlertReceivedLogMessage(this.clientID, s, s2);
            LOG.log(level, string);
        }
    }

    @Override
    public void notifyConnectionClosed() {
        super.notifyConnectionClosed();
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info(this.clientID + " disconnected from " + JsseUtils.getPeerReport(this.manager));
        }
    }

    @Override
    public void notifyHandshakeBeginning() throws IOException {
        super.notifyHandshakeBeginning();
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info(this.clientID + " opening connection to " + JsseUtils.getPeerReport(this.manager));
        }
        ContextData contextData = this.manager.getContextData();
        ProtocolVersion[] protocolVersionArray = this.getProtocolVersions();
        this.jsseSecurityParameters.namedGroups = contextData.getNamedGroupsClient(this.sslParameters, protocolVersionArray);
        this.jsseSecurityParameters.signatureSchemes = contextData.getSignatureSchemesClient(this.sslParameters, protocolVersionArray, this.jsseSecurityParameters.namedGroups);
    }

    @Override
    public synchronized void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        this.handshakeComplete = true;
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info(this.clientID + " established connection with " + JsseUtils.getPeerReport(this.manager));
        }
        TlsSession tlsSession = this.context.getSession();
        if (null == this.sslSession || this.sslSession.getTlsSession() != tlsSession) {
            ProvSSLSessionContext provSSLSessionContext = this.manager.getContextData().getClientSessionContext();
            String string = this.manager.getPeerHost();
            int n = this.manager.getPeerPort();
            JsseSessionParameters jsseSessionParameters = new JsseSessionParameters(this.sslParameters.getEndpointIdentificationAlgorithm(), null);
            boolean bl = provClientEnableSessionResumption && !TlsUtils.isTLSv13(this.context);
            this.sslSession = provSSLSessionContext.reportSession(string, n, tlsSession, jsseSessionParameters, bl);
        }
        this.manager.notifyHandshakeComplete(new ProvSSLConnection(this));
    }

    @Override
    public void notifySecureRenegotiation(boolean bl) throws IOException {
        boolean bl2;
        if (!bl && !(bl2 = PropertyUtils.getBooleanSystemProperty("sun.security.ssl.allowLegacyHelloMessages", true))) {
            throw new TlsFatalAlert(40);
        }
    }

    @Override
    public void notifySelectedCipherSuite(int n) {
        String string = this.manager.getContextData().getContext().validateNegotiatedCipherSuite(this.sslParameters, n);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.clientID + " notified of selected cipher suite: " + string);
        }
        super.notifySelectedCipherSuite(n);
    }

    @Override
    public void notifyServerVersion(ProtocolVersion protocolVersion) throws IOException {
        String string = this.manager.getContextData().getContext().validateNegotiatedProtocol(this.sslParameters, protocolVersion);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.clientID + " notified of selected protocol version: " + string);
        }
        super.notifyServerVersion(protocolVersion);
    }

    @Override
    public void notifySessionToResume(TlsSession tlsSession) {
        if (null == tlsSession) {
            JsseUtils.checkSessionCreationEnabled(this.manager);
        }
        super.notifySessionToResume(tlsSession);
    }

    @Override
    public void notifySessionID(byte[] byArray) {
        boolean bl;
        boolean bl2 = bl = !TlsUtils.isNullOrEmpty(byArray) && null != this.sslSession && Arrays.areEqual((byte[])byArray, (byte[])this.sslSession.getId());
        if (bl) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.clientID + ": Server resumed session: " + Hex.toHexString((byte[])byArray));
            }
        } else {
            this.sslSession = null;
            if (LOG.isLoggable(Level.FINE)) {
                if (TlsUtils.isNullOrEmpty(byArray)) {
                    LOG.fine(this.clientID + ": Server did not specify a session ID");
                } else {
                    LOG.fine(this.clientID + ": Server specified new session: " + Hex.toHexString((byte[])byArray));
                }
            }
            JsseUtils.checkSessionCreationEnabled(this.manager);
        }
        this.manager.notifyHandshakeSession(this.manager.getContextData().getClientSessionContext(), this.context.getSecurityParametersHandshake(), this.jsseSecurityParameters, this.sslSession);
    }

    @Override
    public void processServerExtensions(Hashtable hashtable) throws IOException {
        super.processServerExtensions(hashtable);
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        if (null != securityParameters.getClientServerNames()) {
            boolean bl = TlsExtensionsUtils.hasServerNameExtensionServer(hashtable);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this.clientID + ": Server accepted SNI?: " + bl);
            }
        }
    }

    @Override
    public boolean requiresCloseNotify() {
        return JsseUtils.requireCloseNotify();
    }

    @Override
    public boolean requiresExtendedMasterSecret() {
        return !JsseUtils.allowLegacyMasterSecret();
    }

    @Override
    public boolean shouldUseCompatibilityMode() {
        return JsseUtils.useCompatibilityMode();
    }

    @Override
    public boolean shouldUseExtendedMasterSecret() {
        return JsseUtils.useExtendedMasterSecret();
    }

    protected String[] getKeyTypesLegacy(short[] sArray) throws IOException {
        String[] stringArray = new String[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            stringArray[i] = JsseUtils.getKeyTypeLegacyClient(sArray[i]);
        }
        return stringArray;
    }

    protected SessionParameters getResumableSessionParameters(ProvSSLSession provSSLSession, TlsSession tlsSession) {
        JsseSessionParameters jsseSessionParameters;
        String string;
        if (null == tlsSession || !tlsSession.isResumable()) {
            return null;
        }
        SessionParameters sessionParameters = tlsSession.exportSessionParameters();
        if (null == sessionParameters || !Arrays.contains((int[])this.getCipherSuites(), (int)sessionParameters.getCipherSuite())) {
            return null;
        }
        Object object = sessionParameters.getNegotiatedVersion();
        if (!ProtocolVersion.contains(this.getProtocolVersions(), (ProtocolVersion)object)) {
            return null;
        }
        if (TlsUtils.isTLSv13((ProtocolVersion)object)) {
            return null;
        }
        object = this.sslParameters.getEndpointIdentificationAlgorithm();
        if (null != object && !((String)object).equalsIgnoreCase(string = (jsseSessionParameters = provSSLSession.getJsseSessionParameters()).getEndpointIDAlgorithm())) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this.clientID + ": Session not resumable - endpoint ID algorithm mismatch; connection: " + (String)object + ", session: " + string);
            }
            return null;
        }
        return sessionParameters;
    }

    protected TlsCredentials selectClientCredentials12(Principal[] principalArray, short[] sArray) throws IOException {
        String string;
        SignatureSchemeInfo.PerConnection perConnection = this.jsseSecurityParameters.signatureSchemes;
        LinkedHashMap<String, SignatureSchemeInfo> linkedHashMap = new LinkedHashMap<String, SignatureSchemeInfo>();
        for (SignatureSchemeInfo object2 : perConnection.getPeerSigSchemes()) {
            short signatureSchemeInfo;
            short s;
            string = object2.getKeyType();
            if (linkedHashMap.containsKey(string) || (s = SignatureAlgorithm.getClientCertificateType(signatureSchemeInfo = object2.getSignatureAlgorithm())) < 0 || !Arrays.contains((short[])sArray, (short)s) || !object2.isSupportedPre13() || !perConnection.hasLocalSignatureScheme(object2)) continue;
            linkedHashMap.put(string, object2);
        }
        if (linkedHashMap.isEmpty()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.clientID + " (1.2) found no usable signature schemes");
            }
            return null;
        }
        String[] stringArray = linkedHashMap.keySet().toArray(TlsUtils.EMPTY_STRINGS);
        BCX509Key bCX509Key = this.manager.chooseClientKey(stringArray, principalArray);
        if (null == bCX509Key) {
            this.handleKeyManagerMisses(linkedHashMap, null);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.clientID + " (1.2) did not select any credentials");
            }
            return null;
        }
        string = bCX509Key.getKeyType();
        this.handleKeyManagerMisses(linkedHashMap, string);
        SignatureSchemeInfo signatureSchemeInfo = linkedHashMap.get(string);
        if (null == signatureSchemeInfo) {
            throw new TlsFatalAlert(80, "Key manager returned invalid key type");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.clientID + " (1.2) selected credentials for signature scheme '" + signatureSchemeInfo + "' (keyType '" + string + "'), with private key algorithm '" + JsseUtils.getPrivateKeyAlgorithm(bCX509Key.getPrivateKey()) + "'");
        }
        return JsseUtils.createCredentialedSigner(this.context, this.getCrypto(), bCX509Key, signatureSchemeInfo.getSignatureAndHashAlgorithm());
    }

    protected TlsCredentials selectClientCredentials13(Principal[] principalArray, byte[] byArray) throws IOException {
        String string;
        SignatureSchemeInfo.PerConnection perConnection = this.jsseSecurityParameters.signatureSchemes;
        LinkedHashMap<String, SignatureSchemeInfo> linkedHashMap = new LinkedHashMap<String, SignatureSchemeInfo>();
        for (SignatureSchemeInfo object2 : perConnection.getPeerSigSchemes()) {
            string = object2.getKeyType13();
            if (linkedHashMap.containsKey(string) || !object2.isSupportedPost13() || !perConnection.hasLocalSignatureScheme(object2)) continue;
            linkedHashMap.put(string, object2);
        }
        if (linkedHashMap.isEmpty()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.clientID + " (1.3) found no usable signature schemes");
            }
            return null;
        }
        String[] stringArray = linkedHashMap.keySet().toArray(TlsUtils.EMPTY_STRINGS);
        BCX509Key bCX509Key = this.manager.chooseClientKey(stringArray, principalArray);
        if (null == bCX509Key) {
            this.handleKeyManagerMisses(linkedHashMap, null);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.clientID + " (1.3) did not select any credentials");
            }
            return null;
        }
        string = bCX509Key.getKeyType();
        this.handleKeyManagerMisses(linkedHashMap, string);
        SignatureSchemeInfo signatureSchemeInfo = linkedHashMap.get(string);
        if (null == signatureSchemeInfo) {
            throw new TlsFatalAlert(80, "Key manager returned invalid key type");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.clientID + " (1.3) selected credentials for signature scheme '" + signatureSchemeInfo + "' (keyType '" + string + "'), with private key algorithm '" + JsseUtils.getPrivateKeyAlgorithm(bCX509Key.getPrivateKey()) + "'");
        }
        return JsseUtils.createCredentialedSigner13(this.context, this.getCrypto(), bCX509Key, signatureSchemeInfo.getSignatureAndHashAlgorithm(), byArray);
    }

    protected TlsCredentials selectClientCredentialsLegacy(Principal[] principalArray, short[] sArray) throws IOException {
        String[] stringArray = this.getKeyTypesLegacy(sArray);
        if (stringArray.length < 1) {
            return null;
        }
        BCX509Key bCX509Key = this.manager.chooseClientKey(stringArray, principalArray);
        if (null == bCX509Key) {
            return null;
        }
        return JsseUtils.createCredentialedSigner(this.context, this.getCrypto(), bCX509Key, null);
    }

    private void handleKeyManagerMisses(LinkedHashMap<String, SignatureSchemeInfo> linkedHashMap, String string) {
        Map.Entry<String, SignatureSchemeInfo> entry;
        String string2;
        Iterator<Map.Entry<String, SignatureSchemeInfo>> iterator = linkedHashMap.entrySet().iterator();
        while (iterator.hasNext() && !(string2 = (entry = iterator.next()).getKey()).equals(string)) {
            if (!LOG.isLoggable(Level.FINER)) continue;
            SignatureSchemeInfo signatureSchemeInfo = entry.getValue();
            LOG.finer(this.clientID + " found no credentials for signature scheme '" + signatureSchemeInfo + "' (keyType '" + string2 + "')");
        }
    }
}

