/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.spi;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.kubernetes.spi.Property;
import java.util.Optional;

public final class KubernetesPortBuildItem
extends MultiBuildItem {
    private final int port;
    private final String name;
    private final boolean enabled;
    private final Optional<Property<Integer>> source;

    public KubernetesPortBuildItem(int port, Feature feature) {
        this(port, feature.getName(), true, Optional.empty());
    }

    public KubernetesPortBuildItem(int port, String name) {
        this(port, name, true, Optional.empty());
    }

    public KubernetesPortBuildItem(int port, String name, boolean enabled, Optional<Property<Integer>> source) {
        this.port = port;
        this.name = name;
        this.source = source;
        this.enabled = enabled;
    }

    public static KubernetesPortBuildItem fromRuntimeConfiguration(String name, String propertyName, Integer defaultValue, boolean enabled) {
        Property<Integer> origin = Property.fromRuntimeConfiguration(propertyName, Integer.class, defaultValue);
        Integer port = origin.getValue().orElse(defaultValue);
        return new KubernetesPortBuildItem(port, name, enabled, Optional.of(origin));
    }

    public static KubernetesPortBuildItem fromRuntimeConfiguration(String name, String propertyName, Integer defaultValue) {
        Property<Integer> origin = Property.fromRuntimeConfiguration(propertyName, Integer.class, defaultValue);
        Integer port = origin.getValue().orElse(defaultValue);
        return new KubernetesPortBuildItem(port, name, origin.getValue().isPresent(), Optional.of(origin));
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Optional<Property<Integer>> getSource() {
        return this.source;
    }
}

