/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.catalog.processor;

import io.quarkus.platform.catalog.processor.MetadataValue;
import io.quarkus.registry.catalog.Category;
import io.quarkus.registry.catalog.Extension;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class ProcessedCategory {
    private final Category category;
    private final Collection<Extension> extensions;

    public ProcessedCategory(Category category, Collection<Extension> extensions) {
        this.category = Objects.requireNonNull(category);
        this.extensions = Objects.requireNonNull(extensions);
    }

    public Category getCategory() {
        return this.category;
    }

    public Collection<Extension> getExtensions() {
        return this.extensions;
    }

    public List<Extension> getSortedExtensions() {
        return this.extensions.stream().sorted(this.extensionsComparator()).collect(Collectors.toList());
    }

    private Comparator<Extension> extensionsComparator() {
        List<String> pinnedList = MetadataValue.get(this.category.getMetadata(), "pinned").asStringList();
        return Comparator.comparingInt(e -> this.getPinnedIndex(pinnedList, (Extension)e)).thenComparing(Extension::getName, String.CASE_INSENSITIVE_ORDER);
    }

    private int getPinnedIndex(List<String> pinnedList, Extension e) {
        int index = pinnedList.indexOf(e.managementKey());
        return index >= 0 ? index : Integer.MAX_VALUE;
    }
}

