/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.spi;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.resteasy.reactive.spi.RuntimeTypeItem;
import jakarta.ws.rs.RuntimeType;
import java.util.Collections;
import java.util.List;

public final class MessageBodyWriterBuildItem
extends MultiBuildItem
implements RuntimeTypeItem {
    private final String className;
    private final String handledClassName;
    private final List<String> mediaTypeStrings;
    private final RuntimeType runtimeType;
    private final boolean builtin;
    private final Integer priority;

    public MessageBodyWriterBuildItem(String className, String handledClassName, List<String> mediaTypeStrings) {
        this(className, handledClassName, mediaTypeStrings, null, false, 5000);
    }

    public MessageBodyWriterBuildItem(String className, String handledClassName, List<String> mediaTypeStrings, RuntimeType runtimeType, boolean builtin, Integer priority) {
        this.className = className;
        this.handledClassName = handledClassName;
        this.mediaTypeStrings = mediaTypeStrings;
        this.runtimeType = runtimeType;
        this.builtin = builtin;
        this.priority = priority;
    }

    MessageBodyWriterBuildItem(Builder builder) {
        this.className = builder.className;
        this.handledClassName = builder.handledClassName;
        this.mediaTypeStrings = builder.mediaTypeStrings;
        this.runtimeType = builder.runtimeType;
        this.builtin = builder.builtin;
        this.priority = builder.priority;
    }

    public String getClassName() {
        return this.className;
    }

    public String getHandledClassName() {
        return this.handledClassName;
    }

    public List<String> getMediaTypeStrings() {
        return this.mediaTypeStrings;
    }

    @Override
    public RuntimeType getRuntimeType() {
        return this.runtimeType;
    }

    public boolean isBuiltin() {
        return this.builtin;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public static class Builder {
        private final String className;
        private final String handledClassName;
        private List<String> mediaTypeStrings = Collections.emptyList();
        private RuntimeType runtimeType = null;
        private boolean builtin = false;
        private Integer priority = 5000;

        public Builder(String className, String handledClassName) {
            this.className = className;
            this.handledClassName = handledClassName;
        }

        public Builder setMediaTypeStrings(List<String> mediaTypeStrings) {
            this.mediaTypeStrings = mediaTypeStrings;
            return this;
        }

        public Builder setRuntimeType(RuntimeType runtimeType) {
            this.runtimeType = runtimeType;
            return this;
        }

        public Builder setBuiltin(boolean builtin) {
            this.builtin = builtin;
            return this;
        }

        public Builder setPriority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public MessageBodyWriterBuildItem build() {
            return new MessageBodyWriterBuildItem(this);
        }
    }
}

