/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.identity;

import java.util.Map;
import org.keycloak.authorization.attribute.Attributes;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;

public class UserModelIdentity
implements Identity {
    protected RealmModel realm;
    protected UserModel user;

    public UserModelIdentity(RealmModel realm, UserModel user) {
        this.realm = realm;
        this.user = user;
    }

    @Override
    public String getId() {
        return this.user.getId();
    }

    @Override
    public Attributes getAttributes() {
        Map attr = this.user.getAttributes();
        return Attributes.from(attr);
    }

    @Override
    public boolean hasRealmRole(String roleName) {
        RoleModel role = this.realm.getRole(roleName);
        if (role == null) {
            return false;
        }
        return this.user.hasRole(role);
    }

    @Override
    public boolean hasOneClientRole(String clientId, String ... roleNames) {
        ClientModel client = this.realm.getClientByClientId(clientId);
        for (String roleName : roleNames) {
            RoleModel role = client.getRole(roleName);
            if (role == null || !this.user.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasClientRole(String clientId, String roleName) {
        ClientModel client = this.realm.getClientByClientId(clientId);
        RoleModel role = client.getRole(roleName);
        if (role == null) {
            return false;
        }
        return this.user.hasRole(role);
    }
}

