/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.persistence.remote.configuration.AbstractSecurityConfigurationChildBuilder;
import org.infinispan.persistence.remote.configuration.KeyStoreConfiguration;
import org.infinispan.persistence.remote.configuration.SecurityConfigurationBuilder;

public class KeyStoreConfigurationBuilder
extends AbstractSecurityConfigurationChildBuilder
implements Builder<KeyStoreConfiguration> {
    private static final Log log = LogFactory.getLog(KeyStoreConfigurationBuilder.class);

    protected KeyStoreConfigurationBuilder(SecurityConfigurationBuilder builder) {
        super(builder, KeyStoreConfiguration.attributeDefinitionSet());
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public KeyStoreConfigurationBuilder keyStoreFileName(String keyStoreFileName) {
        this.attributes.attribute(KeyStoreConfiguration.KEYSTORE_FILENAME).set((Object)keyStoreFileName);
        return this;
    }

    public KeyStoreConfigurationBuilder keyStoreType(String keyStoreType) {
        this.attributes.attribute(KeyStoreConfiguration.KEYSTORE_TYPE).set((Object)keyStoreType);
        return this;
    }

    public KeyStoreConfigurationBuilder keyStorePassword(char[] keyStorePassword) {
        this.attributes.attribute(KeyStoreConfiguration.KEYSTORE_PASSWORD).set((Object)new String(keyStorePassword));
        return this;
    }

    public KeyStoreConfigurationBuilder keyAlias(String keyAlias) {
        this.attributes.attribute(KeyStoreConfiguration.KEY_ALIAS).set((Object)keyAlias);
        return this;
    }

    public KeyStoreConfiguration create() {
        return new KeyStoreConfiguration(this.attributes.protect());
    }

    public KeyStoreConfigurationBuilder read(KeyStoreConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }
}

