/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.condition.AbstractClientPolicyConditionProviderFactory;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.condition.ClientUpdaterSourceHostsCondition;

public class ClientUpdaterSourceHostsConditionFactory
extends AbstractClientPolicyConditionProviderFactory {
    public static final String PROVIDER_ID = "client-updater-source-host";
    public static final String TRUSTED_HOSTS = "trusted-hosts";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public ClientPolicyConditionProvider create(KeycloakSession session) {
        return new ClientUpdaterSourceHostsCondition(session);
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "The condition checks the host/domain of the entity who tries to create/update the client to determine whether the policy is applied.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    static {
        ClientUpdaterSourceHostsConditionFactory.addCommonConfigProperties(configProperties);
        ProviderConfigProperty property = new ProviderConfigProperty(TRUSTED_HOSTS, "client-updater-trusted-hosts.label", "client-updater-trusted-hosts.tooltip", "MultivaluedString", null);
        configProperties.add(property);
    }
}

