/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.internal;

import java.util.Locale;
import java.util.function.BiConsumer;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.ast.MutationGroup;
import org.hibernate.sql.model.ast.TableMutation;

public class MutationGroupSingle
implements MutationGroup {
    private final MutationType mutationType;
    private final MutationTarget<?> mutationTarget;
    private final TableMutation<?> tableMutation;

    public MutationGroupSingle(MutationType mutationType, MutationTarget<?> mutationTarget, TableMutation<?> tableMutation) {
        this.mutationType = mutationType;
        this.mutationTarget = mutationTarget;
        this.tableMutation = tableMutation;
    }

    @Override
    public MutationType getMutationType() {
        return this.mutationType;
    }

    @Override
    public MutationTarget<?> getMutationTarget() {
        return this.mutationTarget;
    }

    @Override
    public int getNumberOfTableMutations() {
        return 1;
    }

    @Override
    public TableMutation getSingleTableMutation() {
        return this.tableMutation;
    }

    public TableMutation getTableMutation(String tableName) {
        assert (this.tableMutation.getMutatingTable().getTableName().equals(tableName));
        return this.tableMutation;
    }

    @Override
    public <O extends MutationOperation, M extends TableMutation<O>> void forEachTableMutation(BiConsumer<Integer, M> action) {
        action.accept(0, this.tableMutation);
    }

    @Override
    public TableMutation getTableMutation(int i) {
        return this.tableMutation;
    }

    public String toString() {
        return String.format(Locale.ROOT, "MutationSqlGroup( %s:`%s` )", this.mutationType.name(), this.mutationTarget.getNavigableRole().getFullPath());
    }
}

