/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.util.List;
import twitter4j.HttpResponse;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;
import twitter4j.StallWarningImpl;
import twitter4j.StatusDeletionNoticeImpl;
import twitter4j.StatusStreamBase;
import twitter4j.TwitterException;
import twitter4j.v1.RawStreamListener;
import twitter4j.v1.StatusListener;
import twitter4j.v1.StreamListener;

class StatusStreamImpl
extends StatusStreamBase {
    String line;

    StatusStreamImpl(HttpResponse response, List<StreamListener> streamListeners, List<RawStreamListener> rawStreamListeners, boolean jsonStoreEnabled, boolean prettyDebug) throws IOException {
        super(response, streamListeners, rawStreamListeners, jsonStoreEnabled, prettyDebug);
    }

    @Override
    protected void onClose() {
    }

    @Override
    public void next(List<StreamListener> listeners) throws TwitterException {
        this.handleNextElement(listeners, null);
    }

    @Override
    public void next(List<StreamListener> listeners, List<RawStreamListener> rawStreamListeners) throws TwitterException {
        this.handleNextElement(listeners, rawStreamListeners);
    }

    @Override
    protected String parseLine(String line) {
        this.line = line;
        return line;
    }

    @Override
    protected void onMessage(String rawString, RawStreamListener listener) {
        if (listener != null) {
            listener.onMessage(rawString);
        }
    }

    @Override
    protected void onStatus(JSONObject json, List<StreamListener> listeners) throws TwitterException {
        for (StreamListener listener : listeners) {
            ((StatusListener)listener).onStatus(this.asStatus(json));
        }
    }

    @Override
    protected void onDelete(JSONObject json, List<StreamListener> listeners) throws JSONException {
        JSONObject deletionNotice = json.getJSONObject("delete");
        if (deletionNotice.has("status")) {
            for (StreamListener listener : listeners) {
                ((StatusListener)listener).onDeletionNotice(new StatusDeletionNoticeImpl(deletionNotice.getJSONObject("status")));
            }
        }
    }

    @Override
    protected void onLimit(JSONObject json, List<StreamListener> listeners) throws JSONException {
        for (StreamListener listener : listeners) {
            ((StatusListener)listener).onTrackLimitationNotice(ParseUtil.getInt("track", json.getJSONObject("limit")));
        }
    }

    @Override
    protected void onStallWarning(JSONObject json, List<StreamListener> listeners) throws TwitterException, JSONException {
        for (StreamListener listener : listeners) {
            ((StatusListener)listener).onStallWarning(new StallWarningImpl(json));
        }
    }

    @Override
    protected void onScrubGeo(JSONObject json, List<StreamListener> listeners) throws TwitterException, JSONException {
        JSONObject scrubGeo = json.getJSONObject("scrub_geo");
        for (StreamListener listener : listeners) {
            ((StatusListener)listener).onScrubGeo(ParseUtil.getLong("user_id", scrubGeo), ParseUtil.getLong("up_to_status_id", scrubGeo));
        }
    }

    @Override
    public void onException(Exception e, List<StreamListener> listeners) {
        for (StreamListener listener : listeners) {
            listener.onException(e);
        }
    }
}

