/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor.generation.exceptionmappers;

import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.RestResponse;
import org.jboss.resteasy.reactive.common.processor.HashUtil;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.server.SimpleResourceInfo;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.exceptionmappers.AsyncExceptionMappingUtil;
import org.jboss.resteasy.reactive.server.jaxrs.ContainerRequestContextImpl;
import org.jboss.resteasy.reactive.server.jaxrs.HttpHeadersImpl;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.processor.generation.multipart.GeneratorUtils;
import org.jboss.resteasy.reactive.server.processor.util.ResteasyReactiveServerDotNames;
import org.jboss.resteasy.reactive.server.spi.AsyncExceptionMapperContext;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveAsyncExceptionMapper;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveExceptionMapper;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public final class ServerExceptionMapperGenerator {
    private static final DotName THROWABLE = DotName.createSimple((String)Throwable.class.getName());
    private static final DotName EXCEPTION = DotName.createSimple((String)Exception.class.getName());

    private ServerExceptionMapperGenerator() {
    }

    public static Map<String, String> generatePerClassMapper(MethodInfo targetMethod, ClassOutput classOutput, Set<DotName> unwrappableTypes, Set<String> additionalBeanAnnotations) {
        ReturnType returnType = ServerExceptionMapperGenerator.determineReturnType(targetMethod);
        ServerExceptionMapperGenerator.checkModifiers(targetMethod);
        ClassInfo targetClass = targetMethod.declaringClass();
        Type[] handledExceptionTypes = ServerExceptionMapperGenerator.getHandledExceptionTypes(targetMethod);
        HashMap<String, String> result = new HashMap<String, String>();
        boolean handlesMultipleExceptions = handledExceptionTypes.length > 1;
        Set<String> commonHierarchyOfExceptions = ServerExceptionMapperGenerator.getCommonHierarchyOfExceptions(handledExceptionTypes);
        for (Type handledExceptionType : handledExceptionTypes) {
            String generatedClassName;
            block12: {
                generatedClassName = ServerExceptionMapperGenerator.getGeneratedClassName(targetMethod, handledExceptionType);
                try (ClassCreator cc = ClassCreator.builder().className(generatedClassName).interfaces(new Class[]{ServerExceptionMapperGenerator.determineInterfaceType(returnType)}).classOutput(classOutput).build();){
                    cc.addAnnotation(Singleton.class);
                    for (String an : additionalBeanAnnotations) {
                        cc.addAnnotation(an);
                    }
                    MethodCreator ctor = cc.getMethodCreator("<init>", "V", new String[0]);
                    ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), ctor.getThis(), new ResultHandle[0]);
                    ctor.returnValue(null);
                    if (returnType == ReturnType.RESPONSE || returnType == ReturnType.REST_RESPONSE) {
                        MethodDescriptor specToResponseDescriptor = ServerExceptionMapperGenerator.generateSpecToResponse(handledExceptionType, generatedClassName, cc);
                        ServerExceptionMapperGenerator.generateSpecToResponseBridge(handledExceptionType, cc, specToResponseDescriptor);
                        MethodDescriptor rrToResponseDescriptor = ServerExceptionMapperGenerator.toResponseDescriptor(handledExceptionType, generatedClassName);
                        if (!THROWABLE.equals((Object)handledExceptionType.name())) {
                            ServerExceptionMapperGenerator.generateRRResponseBridge(handledExceptionType, cc, rrToResponseDescriptor);
                        }
                        ServerExceptionMapperGenerator.generateRRResponse(targetMethod, targetClass, handledExceptionType, cc, rrToResponseDescriptor, returnType, handlesMultipleExceptions, commonHierarchyOfExceptions, (method, contextHandle) -> {
                            ResultHandle endpointInstanceHandle = method.invokeVirtualMethod(MethodDescriptor.ofMethod(ResteasyReactiveRequestContext.class, (String)"getEndpointInstance", Object.class, (Class[])new Class[0]), contextHandle, new ResultHandle[0]);
                            return method.checkCast(endpointInstanceHandle, targetClass.name().toString());
                        }, unwrappableTypes);
                        break block12;
                    }
                    if (returnType == ReturnType.UNI_RESPONSE || returnType == ReturnType.UNI_REST_RESPONSE) {
                        MethodDescriptor rrAsyncResponseDescriptor = ServerExceptionMapperGenerator.asyncResponseDescriptor(handledExceptionType, generatedClassName);
                        if (!THROWABLE.equals((Object)handledExceptionType.name())) {
                            ServerExceptionMapperGenerator.generateRRUniResponseBridge(handledExceptionType, cc, rrAsyncResponseDescriptor);
                        }
                        ServerExceptionMapperGenerator.generateRRUniResponse(targetMethod, targetClass, handledExceptionType, cc, rrAsyncResponseDescriptor, returnType, handlesMultipleExceptions, commonHierarchyOfExceptions, (method, contextHandle) -> {
                            ResultHandle endpointInstanceHandle = method.invokeVirtualMethod(MethodDescriptor.ofMethod(ResteasyReactiveRequestContext.class, (String)"getEndpointInstance", Object.class, (Class[])new Class[0]), contextHandle, new ResultHandle[0]);
                            return method.checkCast(endpointInstanceHandle, targetClass.name().toString());
                        }, unwrappableTypes);
                        break block12;
                    }
                    throw new IllegalStateException("ReturnType: '" + String.valueOf((Object)returnType) + "' is not supported");
                }
            }
            result.put(handledExceptionType.name().toString(), generatedClassName);
        }
        return result;
    }

    public static Map<String, String> generateGlobalMapper(MethodInfo targetMethod, ClassOutput classOutput, Set<DotName> unwrappableTypes, Set<String> additionalBeanAnnotations, Predicate<MethodInfo> isOptionalMapper) {
        ReturnType returnType = ServerExceptionMapperGenerator.determineReturnType(targetMethod);
        ServerExceptionMapperGenerator.checkModifiers(targetMethod);
        ClassInfo targetClass = targetMethod.declaringClass();
        Type[] handledExceptionTypes = ServerExceptionMapperGenerator.getHandledExceptionTypes(targetMethod);
        HashMap<String, String> result = new HashMap<String, String>();
        boolean handlesMultipleExceptions = handledExceptionTypes.length > 1;
        Set<String> commonHierarchyOfExceptions = ServerExceptionMapperGenerator.getCommonHierarchyOfExceptions(handledExceptionTypes);
        for (Type handledExceptionType : handledExceptionTypes) {
            String generatedClassName;
            block14: {
                generatedClassName = ServerExceptionMapperGenerator.getGeneratedClassName(targetMethod, handledExceptionType);
                try (ClassCreator cc = ClassCreator.builder().className(generatedClassName).interfaces(new Class[]{ServerExceptionMapperGenerator.determineInterfaceType(returnType)}).classOutput(classOutput).build();){
                    cc.addAnnotation(Singleton.class);
                    for (String an : additionalBeanAnnotations) {
                        cc.addAnnotation(an);
                    }
                    FieldDescriptor delegateField = ((FieldCreator)cc.getFieldCreator("delegate", targetClass.name().toString()).setModifiers(18)).getFieldDescriptor();
                    boolean isOptional = isOptionalMapper.test(targetMethod);
                    MethodCreator ctor = isOptional ? (MethodCreator)cc.getMethodCreator("<init>", Void.TYPE, new Class[]{Instance.class}).setSignature(String.format("(L%s<L%s;>;)V", Instance.class.getName().replace('.', '/'), targetClass.name().toString().replace('.', '/'))) : cc.getMethodCreator("<init>", Void.TYPE, new Object[]{targetClass.name().toString()});
                    ctor.setModifiers(1);
                    ctor.addAnnotation(Inject.class);
                    ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), ctor.getThis(), new ResultHandle[0]);
                    ResultHandle self = ctor.getThis();
                    ResultHandle param = ctor.getMethodParam(0);
                    if (isOptional) {
                        ctor.writeInstanceField(delegateField, self, ctor.invokeInterfaceMethod(MethodDescriptor.ofMethod(Instance.class, (String)"get", Object.class, (Class[])new Class[0]), param, new ResultHandle[0]));
                    } else {
                        ctor.writeInstanceField(delegateField, self, param);
                    }
                    ctor.returnValue(null);
                    if (returnType == ReturnType.RESPONSE || returnType == ReturnType.REST_RESPONSE) {
                        MethodDescriptor specToResponseDescriptor = ServerExceptionMapperGenerator.generateSpecToResponse(handledExceptionType, generatedClassName, cc);
                        ServerExceptionMapperGenerator.generateSpecToResponseBridge(handledExceptionType, cc, specToResponseDescriptor);
                        MethodDescriptor rrToResponseDescriptor = ServerExceptionMapperGenerator.toResponseDescriptor(handledExceptionType, generatedClassName);
                        if (!THROWABLE.equals((Object)handledExceptionType.name())) {
                            ServerExceptionMapperGenerator.generateRRResponseBridge(handledExceptionType, cc, rrToResponseDescriptor);
                        }
                        ServerExceptionMapperGenerator.generateRRResponse(targetMethod, targetClass, handledExceptionType, cc, rrToResponseDescriptor, returnType, handlesMultipleExceptions, commonHierarchyOfExceptions, (method, contextHandle) -> method.readInstanceField(delegateField, method.getThis()), unwrappableTypes);
                        break block14;
                    }
                    if (returnType == ReturnType.UNI_RESPONSE || returnType == ReturnType.UNI_REST_RESPONSE) {
                        MethodDescriptor rrAsyncResponseDescriptor = ServerExceptionMapperGenerator.asyncResponseDescriptor(handledExceptionType, generatedClassName);
                        if (!THROWABLE.equals((Object)handledExceptionType.name())) {
                            ServerExceptionMapperGenerator.generateRRUniResponseBridge(handledExceptionType, cc, rrAsyncResponseDescriptor);
                        }
                        ServerExceptionMapperGenerator.generateRRUniResponse(targetMethod, targetClass, handledExceptionType, cc, rrAsyncResponseDescriptor, returnType, handlesMultipleExceptions, commonHierarchyOfExceptions, (method, contextHandle) -> method.readInstanceField(delegateField, method.getThis()), unwrappableTypes);
                        break block14;
                    }
                    throw new IllegalStateException("ReturnType: '" + String.valueOf((Object)returnType) + "' is not supported");
                }
            }
            result.put(handledExceptionType.name().toString(), generatedClassName);
        }
        return result;
    }

    private static Type[] getHandledExceptionTypes(MethodInfo targetMethod) {
        Type[] valueArray;
        AnnotationValue annotationValue = targetMethod.annotation(ResteasyReactiveDotNames.SERVER_EXCEPTION_MAPPER).value();
        if (annotationValue != null && (valueArray = annotationValue.asClassArray()) != null && valueArray.length > 0) {
            return valueArray;
        }
        Type deducedHandledExceptionType = null;
        List methodParameters = targetMethod.parameterTypes();
        for (Type methodParameter : methodParameters) {
            Class<?> methodParameterClass;
            if (methodParameter.kind() != Type.Kind.CLASS || (methodParameterClass = ServerExceptionMapperGenerator.getClassByName(methodParameter.name().toString())) == null || !Throwable.class.isAssignableFrom(methodParameterClass)) continue;
            if (deducedHandledExceptionType != null) {
                throw new IllegalArgumentException("Multiple method parameters found that extend 'Throwable'. When using '@ServerExceptionMapper', only one parameter can be of type 'Throwable'. Offending method is '" + targetMethod.name() + "' of class '" + targetMethod.declaringClass().name().toString() + "'");
            }
            deducedHandledExceptionType = methodParameter;
        }
        if (deducedHandledExceptionType == null) {
            throw new IllegalArgumentException("When '@ServerExceptionMapper' is used without a value, then the annotated method must contain a method parameter that extends 'Throwable'. Offending method is '" + targetMethod.name() + "' of class '" + targetMethod.declaringClass().name().toString() + "'");
        }
        return new Type[]{deducedHandledExceptionType};
    }

    private static Set<String> getCommonHierarchyOfExceptions(Type[] handledExceptions) {
        HashSet<String> commonHierarchy = new HashSet<String>();
        boolean first = true;
        for (Type handledException : handledExceptions) {
            for (Class<?> handledExceptionClass = ServerExceptionMapperGenerator.getClassByName(handledException.name().toString()); handledExceptionClass != null && !handledExceptionClass.equals(Throwable.class); handledExceptionClass = handledExceptionClass.getSuperclass()) {
                String handledExceptionClassName = handledExceptionClass.getName();
                if (first) {
                    commonHierarchy.add(handledExceptionClassName);
                    continue;
                }
                if (commonHierarchy.contains(handledExceptionClassName)) continue;
                commonHierarchy.remove(handledExceptionClassName);
            }
            first = false;
        }
        return commonHierarchy;
    }

    private static Class<?> getClassByName(String className) {
        try {
            return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    private static MethodDescriptor toResponseDescriptor(Type handledExceptionType, String generatedClassName) {
        return MethodDescriptor.ofMethod((String)generatedClassName, (String)"toResponse", (String)Response.class.getName(), (String[])new String[]{handledExceptionType.name().toString(), ServerRequestContext.class.getName()});
    }

    private static MethodDescriptor asyncResponseDescriptor(Type handledExceptionType, String generatedClassName) {
        return MethodDescriptor.ofMethod((String)generatedClassName, (String)"asyncResponse", (String)Void.TYPE.getName(), (String[])new String[]{handledExceptionType.name().toString(), AsyncExceptionMapperContext.class.getName()});
    }

    private static Class<?> determineInterfaceType(ReturnType returnType) {
        if (returnType == ReturnType.RESPONSE || returnType == ReturnType.REST_RESPONSE) {
            return ResteasyReactiveExceptionMapper.class;
        }
        if (returnType == ReturnType.UNI_RESPONSE || returnType == ReturnType.UNI_REST_RESPONSE) {
            return ResteasyReactiveAsyncExceptionMapper.class;
        }
        throw new IllegalStateException("ReturnType: '" + String.valueOf((Object)returnType) + "' is not supported");
    }

    private static void generateSpecToResponseBridge(Type handledExceptionType, ClassCreator cc, MethodDescriptor specToResponseDescriptor) {
        MethodCreator mc = cc.getMethodCreator("toResponse", Response.class, new Class[]{Throwable.class});
        ResultHandle bridgeSpecParam = mc.getMethodParam(0);
        ResultHandle castedBridgeSpecMethodParam = mc.checkCast(bridgeSpecParam, handledExceptionType.name().toString());
        mc.returnValue(mc.invokeVirtualMethod(specToResponseDescriptor, mc.getThis(), new ResultHandle[]{castedBridgeSpecMethodParam}));
    }

    private static MethodDescriptor generateSpecToResponse(Type handledExceptionType, String generatedClassName, ClassCreator cc) {
        MethodDescriptor specToResponseDescriptor = MethodDescriptor.ofMethod((String)generatedClassName, (String)"toResponse", (String)Response.class.getName(), (String[])new String[]{handledExceptionType.name().toString()});
        MethodCreator specToResponse = cc.getMethodCreator(specToResponseDescriptor);
        specToResponse.throwException(IllegalStateException.class, "This should never be called");
        return specToResponseDescriptor;
    }

    private static void generateRRResponseBridge(Type handledExceptionType, ClassCreator cc, MethodDescriptor rrToResponseDescriptor) {
        MethodCreator bridgeRRToResponse = cc.getMethodCreator("toResponse", Response.class, new Class[]{Throwable.class, ServerRequestContext.class});
        ResultHandle bridgeRRExceptionParam = bridgeRRToResponse.getMethodParam(0);
        ResultHandle bridgeRRContextParam = bridgeRRToResponse.getMethodParam(1);
        ResultHandle castedBridgeRRMethodParam = bridgeRRToResponse.checkCast(bridgeRRExceptionParam, handledExceptionType.name().toString());
        bridgeRRToResponse.returnValue(bridgeRRToResponse.invokeVirtualMethod(rrToResponseDescriptor, bridgeRRToResponse.getThis(), new ResultHandle[]{castedBridgeRRMethodParam, bridgeRRContextParam}));
    }

    private static void generateRRResponse(MethodInfo targetMethod, ClassInfo targetClass, Type handledExceptionType, ClassCreator cc, MethodDescriptor rrToResponseDescriptor, ReturnType returnType, boolean handlesMultipleExceptions, Set<String> commonHierarchyOfExceptions, BiFunction<MethodCreator, ResultHandle, ResultHandle> targetInstanceHandleCreator, Set<DotName> unwrappableTypes) {
        MethodCreator mc = cc.getMethodCreator(rrToResponseDescriptor);
        ResultHandle exceptionHandle = mc.getMethodParam(0);
        ResultHandle contextHandle = mc.checkCast(mc.getMethodParam(1), ResteasyReactiveRequestContext.class);
        ResultHandle targetInstanceHandle = targetInstanceHandleCreator.apply(mc, contextHandle);
        if (targetMethod.parameterTypes().isEmpty()) {
            ResultHandle resultHandle = mc.invokeVirtualMethod(MethodDescriptor.ofMethod((String)targetClass.name().toString(), (String)targetMethod.name(), (String)targetMethod.returnType().name().toString(), (String[])new String[0]), targetInstanceHandle, new ResultHandle[0]);
            if (returnType == ReturnType.REST_RESPONSE) {
                resultHandle = mc.invokeVirtualMethod(MethodDescriptor.ofMethod(RestResponse.class, (String)"toResponse", Response.class, (Class[])new Class[0]), resultHandle, new ResultHandle[0]);
            }
            mc.returnValue(resultHandle);
        } else {
            TargetMethodParamsInfo targetMethodParamsInfo = ServerExceptionMapperGenerator.getTargetMethodParamsInfo(targetMethod, targetClass, handledExceptionType, mc, exceptionHandle, contextHandle, handlesMultipleExceptions, commonHierarchyOfExceptions, unwrappableTypes);
            ResultHandle resultHandle = mc.invokeVirtualMethod(MethodDescriptor.ofMethod((String)targetClass.name().toString(), (String)targetMethod.name(), (String)targetMethod.returnType().name().toString(), (String[])targetMethodParamsInfo.getTypes()), targetInstanceHandle, targetMethodParamsInfo.getHandles());
            if (returnType == ReturnType.REST_RESPONSE) {
                resultHandle = mc.invokeVirtualMethod(MethodDescriptor.ofMethod(RestResponse.class, (String)"toResponse", Response.class, (Class[])new Class[0]), resultHandle, new ResultHandle[0]);
            }
            mc.returnValue(resultHandle);
        }
    }

    private static void generateRRUniResponseBridge(Type handledExceptionType, ClassCreator cc, MethodDescriptor rrAsyncResponseDescriptor) {
        MethodCreator mc = cc.getMethodCreator("asyncResponse", Void.TYPE, new Class[]{Throwable.class, AsyncExceptionMapperContext.class});
        ResultHandle bridgeRRExceptionParam = mc.getMethodParam(0);
        ResultHandle bridgeRRContextParam = mc.getMethodParam(1);
        ResultHandle castedBridgeRRMethodParam = mc.checkCast(bridgeRRExceptionParam, handledExceptionType.name().toString());
        mc.returnValue(mc.invokeVirtualMethod(rrAsyncResponseDescriptor, mc.getThis(), new ResultHandle[]{castedBridgeRRMethodParam, bridgeRRContextParam}));
    }

    private static void generateRRUniResponse(MethodInfo targetMethod, ClassInfo targetClass, Type handledExceptionType, ClassCreator cc, MethodDescriptor rrAsyncResponseDescriptor, ReturnType returnType, boolean handlesMultipleExceptions, Set<String> commonHierarchyOfExceptions, BiFunction<MethodCreator, ResultHandle, ResultHandle> targetInstanceHandleCreator, Set<DotName> unwrappableTypes) {
        ResultHandle uniHandle;
        MethodCreator mc = cc.getMethodCreator(rrAsyncResponseDescriptor);
        ResultHandle exceptionHandle = mc.getMethodParam(0);
        ResultHandle asyncContextHandle = mc.getMethodParam(1);
        ResultHandle serverContextHandle = mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(AsyncExceptionMapperContext.class, (String)"serverRequestContext", ServerRequestContext.class, (Class[])new Class[0]), asyncContextHandle, new ResultHandle[0]);
        ResultHandle contextHandle = mc.checkCast(serverContextHandle, ResteasyReactiveRequestContext.class);
        ResultHandle targetInstanceHandle = targetInstanceHandleCreator.apply(mc, contextHandle);
        if (targetMethod.parameterTypes().isEmpty()) {
            uniHandle = mc.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)targetClass.name().toString(), (String)targetMethod.name(), Uni.class, (Object[])new Object[0]), targetInstanceHandle, new ResultHandle[0]);
        } else {
            TargetMethodParamsInfo targetMethodParamsInfo = ServerExceptionMapperGenerator.getTargetMethodParamsInfo(targetMethod, targetClass, handledExceptionType, mc, exceptionHandle, contextHandle, handlesMultipleExceptions, commonHierarchyOfExceptions, unwrappableTypes);
            uniHandle = mc.invokeVirtualMethod(MethodDescriptor.ofMethod((String)targetClass.name().toString(), (String)targetMethod.name(), (String)Uni.class.getName(), (String[])targetMethodParamsInfo.getTypes()), targetInstanceHandle, targetMethodParamsInfo.getHandles());
        }
        String methodName = returnType == ReturnType.UNI_RESPONSE ? "handleUniResponse" : "handleUniRestResponse";
        mc.invokeStaticMethod(MethodDescriptor.ofMethod(AsyncExceptionMappingUtil.class, (String)methodName, Void.TYPE, (Class[])new Class[]{Uni.class, AsyncExceptionMapperContext.class}), new ResultHandle[]{uniHandle, asyncContextHandle});
        mc.returnValue(null);
    }

    private static TargetMethodParamsInfo getTargetMethodParamsInfo(MethodInfo targetMethod, ClassInfo targetClass, Type handledExceptionType, MethodCreator mc, ResultHandle exceptionHandle, ResultHandle contextHandle, boolean handlesMultipleExceptions, Set<String> commonHierarchyOfExceptions, Set<DotName> unwrappableTypes) {
        List parameters = targetMethod.parameterTypes();
        ResultHandle[] targetMethodParamHandles = new ResultHandle[parameters.size()];
        String[] parameterTypes = new String[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            BranchResult ifNullBranch;
            AssignableResultHandle resourceInfo;
            ResultHandle runtimeResourceHandle;
            Type parameter = (Type)parameters.get(i);
            DotName paramDotName = parameter.name();
            parameterTypes[i] = paramDotName.toString();
            String parameterName = targetMethod.parameterName(i);
            if (paramDotName.equals((Object)THROWABLE)) {
                targetMethodParamHandles[i] = exceptionHandle;
                continue;
            }
            if (paramDotName.equals((Object)handledExceptionType.name())) {
                if (handlesMultipleExceptions && !commonHierarchyOfExceptions.contains(paramDotName.toString())) {
                    throw new RuntimeException("Parameter '" + parameterName + "' of method '" + targetMethod.name() + " of class '" + String.valueOf(targetClass.name()) + "' cannot be of type '" + String.valueOf(handledExceptionType.name()) + "' because the method handles multiple exceptions. You can use '" + Throwable.class.getName() + "' instead.");
                }
                targetMethodParamHandles[i] = exceptionHandle;
                continue;
            }
            if (commonHierarchyOfExceptions.contains(paramDotName.toString())) {
                targetMethodParamHandles[i] = exceptionHandle;
                continue;
            }
            if (paramDotName.equals((Object)handledExceptionType.name())) {
                targetMethodParamHandles[i] = exceptionHandle;
                continue;
            }
            if (ResteasyReactiveDotNames.CONTAINER_REQUEST_CONTEXT.equals((Object)paramDotName) || ResteasyReactiveServerDotNames.QUARKUS_REST_CONTAINER_REQUEST_CONTEXT.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = mc.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)ResteasyReactiveRequestContext.class.getName(), (String)"getContainerRequestContext", ContainerRequestContextImpl.class, (Object[])new Object[0]), contextHandle, new ResultHandle[0]);
                continue;
            }
            if (ResteasyReactiveDotNames.URI_INFO.equals((Object)paramDotName)) {
                GeneratorUtils.paramHandleFromReqContextMethod(mc, contextHandle, targetMethodParamHandles, i, "getUriInfo", ResteasyReactiveDotNames.URI_INFO);
                continue;
            }
            if (ResteasyReactiveDotNames.HTTP_HEADERS.equals((Object)paramDotName)) {
                GeneratorUtils.paramHandleFromReqContextMethod(mc, contextHandle, targetMethodParamHandles, i, "getHttpHeaders", HttpHeadersImpl.class);
                continue;
            }
            if (ResteasyReactiveDotNames.REQUEST.equals((Object)paramDotName)) {
                GeneratorUtils.paramHandleFromReqContextMethod(mc, contextHandle, targetMethodParamHandles, i, "getRequest", ResteasyReactiveDotNames.REQUEST);
                continue;
            }
            if (unwrappableTypes.contains(paramDotName)) {
                targetMethodParamHandles[i] = GeneratorUtils.unwrapObject(mc, contextHandle, paramDotName);
                continue;
            }
            if (ResteasyReactiveDotNames.RESOURCE_INFO.equals((Object)paramDotName)) {
                runtimeResourceHandle = GeneratorUtils.runtimeResourceHandle(mc, contextHandle);
                resourceInfo = mc.createVariable(ResourceInfo.class);
                ifNullBranch = mc.ifNull(runtimeResourceHandle);
                ifNullBranch.trueBranch().assign(resourceInfo, ifNullBranch.trueBranch().readStaticField(FieldDescriptor.of(SimpleResourceInfo.NullValues.class, (String)"INSTANCE", SimpleResourceInfo.NullValues.class)));
                ifNullBranch.falseBranch().assign(resourceInfo, ifNullBranch.falseBranch().invokeVirtualMethod(MethodDescriptor.ofMethod(RuntimeResource.class, (String)"getLazyMethod", ResteasyReactiveResourceInfo.class, (Class[])new Class[0]), runtimeResourceHandle, new ResultHandle[0]));
                targetMethodParamHandles[i] = resourceInfo;
                continue;
            }
            if (ResteasyReactiveServerDotNames.SIMPLIFIED_RESOURCE_INFO.equals((Object)paramDotName)) {
                runtimeResourceHandle = GeneratorUtils.runtimeResourceHandle(mc, contextHandle);
                resourceInfo = mc.createVariable(SimpleResourceInfo.class);
                ifNullBranch = mc.ifNull(runtimeResourceHandle);
                ifNullBranch.trueBranch().assign(resourceInfo, ifNullBranch.trueBranch().readStaticField(FieldDescriptor.of(SimpleResourceInfo.NullValues.class, (String)"INSTANCE", SimpleResourceInfo.NullValues.class)));
                ifNullBranch.falseBranch().assign(resourceInfo, ifNullBranch.falseBranch().invokeVirtualMethod(MethodDescriptor.ofMethod(RuntimeResource.class, (String)"getSimplifiedResourceInfo", SimpleResourceInfo.class, (Class[])new Class[0]), runtimeResourceHandle, new ResultHandle[0]));
                targetMethodParamHandles[i] = resourceInfo;
                continue;
            }
            throw new RuntimeException("Parameter '" + parameterName + "' of method '" + targetMethod.name() + " of class '" + String.valueOf(targetClass.name()) + "' is not allowed");
        }
        return new TargetMethodParamsInfo(targetMethodParamHandles, parameterTypes);
    }

    private static ReturnType determineReturnType(MethodInfo targetMethod) {
        ParameterizedType parameterizedType;
        if (targetMethod.returnType().name().equals((Object)ResteasyReactiveDotNames.RESPONSE)) {
            return ReturnType.RESPONSE;
        }
        if (targetMethod.returnType().name().equals((Object)ResteasyReactiveDotNames.REST_RESPONSE)) {
            return ReturnType.REST_RESPONSE;
        }
        if (targetMethod.returnType().kind() == Type.Kind.PARAMETERIZED_TYPE && (parameterizedType = targetMethod.returnType().asParameterizedType()).name().equals((Object)ResteasyReactiveDotNames.UNI) && parameterizedType.arguments().size() == 1) {
            if (((Type)parameterizedType.arguments().get(0)).name().equals((Object)ResteasyReactiveDotNames.RESPONSE)) {
                return ReturnType.UNI_RESPONSE;
            }
            if (((Type)parameterizedType.arguments().get(0)).name().equals((Object)ResteasyReactiveDotNames.REST_RESPONSE)) {
                return ReturnType.UNI_REST_RESPONSE;
            }
        }
        throw new RuntimeException("Method '" + targetMethod.name() + " of class '" + String.valueOf(targetMethod.declaringClass().name()) + "' cannot be used as an exception mapper as it does not declare 'Response' or 'Uni<Response>' or as its return type");
    }

    private static void checkModifiers(MethodInfo info) {
        if ((info.flags() & 2) != 0) {
            throw new RuntimeException("Method '" + info.name() + " of class '" + String.valueOf(info.declaringClass().name()) + "' cannot be private as it is annotated with '@" + String.valueOf(ResteasyReactiveDotNames.SERVER_EXCEPTION_MAPPER) + "'");
        }
        if ((info.flags() & 8) != 0) {
            throw new RuntimeException("Method '" + info.name() + " of class '" + String.valueOf(info.declaringClass().name()) + "' cannot be static as it is annotated with '@" + String.valueOf(ResteasyReactiveDotNames.SERVER_EXCEPTION_MAPPER) + "'");
        }
    }

    private static String getGeneratedClassName(MethodInfo targetMethod, Type handledExceptionType) {
        return String.valueOf(targetMethod.declaringClass().name()) + "$ExceptionMapper$" + HashUtil.sha1((String)(targetMethod.name() + handledExceptionType.name().toString()));
    }

    private static enum ReturnType {
        RESPONSE,
        REST_RESPONSE,
        UNI_RESPONSE,
        UNI_REST_RESPONSE;

    }

    private static class TargetMethodParamsInfo {
        private final ResultHandle[] handles;
        private final String[] types;

        public TargetMethodParamsInfo(ResultHandle[] handles, String[] types) {
            this.handles = handles;
            this.types = types;
        }

        public ResultHandle[] getHandles() {
            return this.handles;
        }

        public String[] getTypes() {
            return this.types;
        }
    }
}

