/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.client.authentication;

import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Map;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.KeystoreUtil;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.common.util.Time;
import org.keycloak.crypto.AsymmetricSignatureSignerContext;
import org.keycloak.crypto.ECDSASignatureSignerContext;
import org.keycloak.crypto.JavaAlgorithm;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.protocol.oidc.client.authentication.ClientCredentialsProvider;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.adapters.config.AdapterConfig;

public class JWTClientCredentialsProvider
implements ClientCredentialsProvider {
    public static final String PROVIDER_ID = "jwt";
    private KeyPair keyPair;
    private SignatureSignerContext sigCtx;
    private int tokenTimeout;

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    public void setupKeyPair(KeyPair keyPair) {
        this.setupKeyPair(keyPair, "RS256");
    }

    public void setupKeyPair(KeyPair keyPair, String algorithm) {
        KeyWrapper keyWrapper = new KeyWrapper();
        keyWrapper.setKid(KeyUtils.createKeyId((Key)keyPair.getPublic()));
        keyWrapper.setAlgorithm(algorithm);
        keyWrapper.setPrivateKey(keyPair.getPrivate());
        keyWrapper.setPublicKey(keyPair.getPublic());
        keyWrapper.setType(keyPair.getPublic().getAlgorithm());
        keyWrapper.setUse(KeyUse.SIG);
        switch (keyPair.getPublic().getAlgorithm()) {
            case "RSA": {
                if (!JavaAlgorithm.isRSAJavaAlgorithm(algorithm)) {
                    throw new RuntimeException("Invalid algorithm for a RSA KeyPair: " + algorithm);
                }
                this.sigCtx = new AsymmetricSignatureSignerContext(keyWrapper);
                break;
            }
            case "EC": {
                if (!JavaAlgorithm.isECJavaAlgorithm(algorithm)) {
                    throw new RuntimeException("Invalid algorithm for a EC KeyPair: " + algorithm);
                }
                this.sigCtx = new ECDSASignatureSignerContext(keyWrapper);
                break;
            }
            default: {
                throw new RuntimeException("Invalid KeyPair algorithm: " + keyPair.getPublic().getAlgorithm());
            }
        }
        this.keyPair = keyPair;
    }

    public void setTokenTimeout(int tokenTimeout) {
        this.tokenTimeout = tokenTimeout;
    }

    protected int getTokenTimeout() {
        return this.tokenTimeout;
    }

    public PublicKey getPublicKey() {
        return this.keyPair.getPublic();
    }

    @Override
    public void init(AdapterConfig deployment, Object config) {
        String clientKeyAlias;
        if (!(config instanceof Map)) {
            throw new RuntimeException("Configuration of jwt credentials is missing or incorrect for client '" + deployment.getResource() + "'. Check your adapter configuration");
        }
        Map cfg = (Map)config;
        String clientKeystoreFile = (String)cfg.get("client-keystore-file");
        if (clientKeystoreFile == null) {
            throw new RuntimeException("Missing parameter client-keystore-file in configuration of jwt for client " + deployment.getResource());
        }
        String clientKeystoreType = (String)cfg.get("client-keystore-type");
        KeystoreUtil.KeystoreFormat clientKeystoreFormat = clientKeystoreType == null ? KeystoreUtil.KeystoreFormat.JKS : Enum.valueOf(KeystoreUtil.KeystoreFormat.class, clientKeystoreType.toUpperCase());
        String clientKeystorePassword = (String)cfg.get("client-keystore-password");
        if (clientKeystorePassword == null) {
            throw new RuntimeException("Missing parameter client-keystore-password in configuration of jwt for client " + deployment.getResource());
        }
        String clientKeyPassword = (String)cfg.get("client-key-password");
        if (clientKeyPassword == null) {
            clientKeyPassword = clientKeystorePassword;
        }
        if ((clientKeyAlias = (String)cfg.get("client-key-alias")) == null) {
            clientKeyAlias = deployment.getResource();
        }
        String algorithm = cfg.getOrDefault("algorithm", "RS256");
        KeyPair keyPair = KeystoreUtil.loadKeyPairFromKeystore((String)clientKeystoreFile, (String)clientKeystorePassword, (String)clientKeyPassword, (String)clientKeyAlias, (KeystoreUtil.KeystoreFormat)clientKeystoreFormat);
        this.setupKeyPair(keyPair, algorithm);
        this.tokenTimeout = this.asInt(cfg, "token-timeout", 10);
    }

    private Integer asInt(Map<String, Object> cfg, String cfgKey, int defaultValue) {
        Object cfgObj = cfg.get(cfgKey);
        if (cfgObj == null) {
            return defaultValue;
        }
        if (cfgObj instanceof String) {
            return Integer.parseInt(cfgObj.toString());
        }
        if (cfgObj instanceof Number) {
            return ((Number)cfgObj).intValue();
        }
        throw new IllegalArgumentException("Can't parse " + cfgKey + " from the config. Value is " + cfgObj);
    }

    @Override
    public void setClientCredentials(AdapterConfig deployment, Map<String, String> requestHeaders, Map<String, String> formParams) {
        String signedToken = this.createSignedRequestToken(deployment.getResource(), deployment.getRealmInfoUrl());
        formParams.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        formParams.put("client_assertion", signedToken);
    }

    public String createSignedRequestToken(String clientId, String realmInfoUrl) {
        JsonWebToken jwt = this.createRequestToken(clientId, realmInfoUrl);
        return new JWSBuilder().jsonContent(jwt).sign(this.sigCtx);
    }

    protected JsonWebToken createRequestToken(String clientId, String realmInfoUrl) {
        JsonWebToken reqToken = new JsonWebToken();
        reqToken.id(SecretGenerator.getInstance().generateSecureID());
        reqToken.issuer(clientId);
        reqToken.subject(clientId);
        reqToken.audience(realmInfoUrl);
        long now = Time.currentTime();
        reqToken.iat(now);
        reqToken.exp(now + (long)this.tokenTimeout);
        reqToken.nbf(now);
        return reqToken;
    }
}

