/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style;

import org.jfree.layouting.input.style.CSSDeclarationRule;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.StyleRule;
import org.jfree.layouting.input.style.StyleSheet;
import org.jfree.layouting.input.style.UnmodifiableStyleSheetException;
import org.jfree.layouting.input.style.selectors.CSSSelector;
import org.jfree.layouting.input.style.values.CSSValue;

public class CSSStyleRule
extends CSSDeclarationRule {
    private CSSSelector selector;

    public CSSStyleRule(StyleSheet styleSheet, StyleRule styleRule) {
        super(styleSheet, styleRule);
    }

    public CSSSelector getSelector() {
        return this.selector;
    }

    public void setSelector(CSSSelector cSSSelector) {
        if (this.isReadOnly()) {
            throw new UnmodifiableStyleSheetException();
        }
        this.selector = cSSSelector;
    }

    public void merge(CSSStyleRule cSSStyleRule) {
        if (cSSStyleRule.isEmpty()) {
            return;
        }
        boolean[] blArray = cSSStyleRule.getImportantValues();
        CSSValue[] cSSValueArray = cSSStyleRule.getStyleValues();
        StyleKey[] styleKeyArray = cSSStyleRule.getPropertyKeysAsArray();
        for (int i = 0; i < cSSValueArray.length; ++i) {
            CSSValue cSSValue = cSSValueArray[i];
            if (cSSValue == null) continue;
            StyleKey styleKey = styleKeyArray[i];
            this.setPropertyValue(styleKey, cSSValue, blArray[i] && this.isImportant(styleKey));
        }
    }
}

