/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import org.jfree.layouting.input.style.CSSPageRule;
import org.jfree.layouting.input.style.StyleSheet;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.page.PageStyleKeys;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;

public class StyleSheetUtility {
    private StyleSheetUtility() {
    }

    public static CSSPageRule createRuleForPage(StyleSheet styleSheet, PageFormat pageFormat) {
        CSSPageRule cSSPageRule = new CSSPageRule(styleSheet, null, null, null);
        StyleSheetUtility.updateRuleForPage(cSSPageRule, pageFormat);
        return cSSPageRule;
    }

    public static void updateRuleForPage(CSSPageRule cSSPageRule, PageFormat pageFormat) {
        if (pageFormat == null) {
            cSSPageRule.removeProperty(BoxStyleKeys.MARGIN_TOP);
            cSSPageRule.removeProperty(BoxStyleKeys.MARGIN_LEFT);
            cSSPageRule.removeProperty(BoxStyleKeys.MARGIN_BOTTOM);
            cSSPageRule.removeProperty(BoxStyleKeys.MARGIN_RIGHT);
            cSSPageRule.removeProperty(PageStyleKeys.SIZE);
            cSSPageRule.removeProperty(PageStyleKeys.HORIZONTAL_PAGE_SPAN);
            cSSPageRule.removeProperty(PageStyleKeys.VERTICAL_PAGE_SPAN);
            return;
        }
        double d = pageFormat.getWidth();
        double d2 = pageFormat.getHeight();
        cSSPageRule.setPropertyValueAsString(PageStyleKeys.SIZE, d + "pt " + d2 + "pt");
        cSSPageRule.setPropertyValueAsString(BoxStyleKeys.MARGIN_TOP, pageFormat.getImageableY() + "pt");
        cSSPageRule.setPropertyValueAsString(BoxStyleKeys.MARGIN_LEFT, pageFormat.getImageableX() + "pt");
        double d3 = d - pageFormat.getImageableX() - pageFormat.getImageableWidth();
        double d4 = d2 - pageFormat.getImageableY() - pageFormat.getImageableHeight();
        cSSPageRule.setPropertyValueAsString(BoxStyleKeys.MARGIN_BOTTOM, d4 + "pt");
        cSSPageRule.setPropertyValueAsString(BoxStyleKeys.MARGIN_RIGHT, d3 + "pt");
        cSSPageRule.setPropertyValueAsString(PageStyleKeys.HORIZONTAL_PAGE_SPAN, "1");
        cSSPageRule.setPropertyValueAsString(PageStyleKeys.VERTICAL_PAGE_SPAN, "1");
    }

    public static PageFormat getPageFormat(CSSPageRule cSSPageRule) {
        CSSValue cSSValue = cSSPageRule.getPropertyCSSValue(PageStyleKeys.SIZE);
        if (!(cSSValue instanceof CSSValuePair)) {
            return null;
        }
        CSSValuePair cSSValuePair = (CSSValuePair)cSSValue;
        CSSValue cSSValue2 = cSSValuePair.getFirstValue();
        CSSValue cSSValue3 = cSSValuePair.getSecondValue();
        double d = CSSValueResolverUtility.convertLengthToDouble(cSSValue2);
        double d2 = CSSValueResolverUtility.convertLengthToDouble(cSSValue3);
        if (d == 0.0 || d2 == 0.0) {
            return null;
        }
        double d3 = CSSValueResolverUtility.convertLengthToDouble(cSSPageRule.getPropertyCSSValue(BoxStyleKeys.MARGIN_LEFT));
        double d4 = CSSValueResolverUtility.convertLengthToDouble(cSSPageRule.getPropertyCSSValue(BoxStyleKeys.MARGIN_TOP));
        double d5 = CSSValueResolverUtility.convertLengthToDouble(cSSPageRule.getPropertyCSSValue(BoxStyleKeys.MARGIN_RIGHT));
        double d6 = CSSValueResolverUtility.convertLengthToDouble(cSSPageRule.getPropertyCSSValue(BoxStyleKeys.MARGIN_BOTTOM));
        if (d < d2) {
            Paper paper = new Paper();
            paper.setSize(d, d2);
            paper.setImageableArea(d3, d5, d - d3 - d5, d2 - d4 - d6);
            PageFormat pageFormat = new PageFormat();
            pageFormat.setPaper(paper);
            pageFormat.setOrientation(1);
            return pageFormat;
        }
        Paper paper = new Paper();
        paper.setSize(d2, d);
        paper.setImageableArea(d3, d5, d - d3 - d5, d2 - d4 - d6);
        PageFormat pageFormat = new PageFormat();
        pageFormat.setPaper(paper);
        pageFormat.setOrientation(0);
        return pageFormat;
    }
}

