/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.swing.converter;

import javax.swing.text.Element;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.page.PageSize;
import org.jfree.layouting.input.style.keys.page.PageStyleKeys;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.swing.Converter;
import org.jfree.layouting.input.swing.ConverterAttributeSet;
import org.pentaho.reporting.libraries.base.util.DebugLog;

public class DocumentConverter
implements Converter {
    public static final String PAGE_RULE_TYPE = "@page";
    public static final String RTF_PAGEWIDTH = "paperw";
    public static final String RTF_PAGEHEIGHT = "paperh";
    public static final String RTF_MARGINLEFT = "margl";
    public static final String RTF_MARGINRIGHT = "margr";
    public static final String RTF_MARGINTOP = "margt";
    public static final String RTF_MARGINBOTTOM = "margb";
    public static final String RTF_GUTTERWIDTH = "gutter";
    public static final String RTF_LANDSCAPE = "landscape";

    @Override
    public ConverterAttributeSet convertToCSS(Object object, Object object2, ConverterAttributeSet converterAttributeSet, Element element) {
        if (object instanceof String) {
            return this.handleStringAttributes(object, object2, converterAttributeSet);
        }
        return null;
    }

    private ConverterAttributeSet handleStringAttributes(Object object, Object object2, ConverterAttributeSet converterAttributeSet) {
        ConverterAttributeSet converterAttributeSet2 = new ConverterAttributeSet();
        String string = (String)object;
        if (string.equals(RTF_PAGEWIDTH) || string.equals(RTF_PAGEHEIGHT)) {
            float f = ((Float)object2).floatValue();
            Object object3 = converterAttributeSet.getAttribute(PageStyleKeys.SIZE.getName());
            double d = 0.0;
            double d2 = 0.0;
            if (object3 instanceof PageSize) {
                PageSize pageSize = (PageSize)object3;
                d = pageSize.getWidth();
                d2 = pageSize.getHeight();
            } else if (RTF_LANDSCAPE.equals(object3)) {
                if (string.equals(RTF_PAGEWIDTH)) {
                    d2 = this.twipToInt(f);
                } else {
                    d = this.twipToInt(f);
                }
            } else if (string.equals(RTF_PAGEWIDTH)) {
                d = this.twipToInt(f);
            } else {
                d2 = this.twipToInt(f);
            }
            converterAttributeSet2.addAttribute(PAGE_RULE_TYPE, PageStyleKeys.SIZE.getName(), new PageSize(d, d2));
        } else if (string.equals(RTF_MARGINLEFT)) {
            float f = ((Float)object2).floatValue();
            converterAttributeSet2.addAttribute(PAGE_RULE_TYPE, BoxStyleKeys.MARGIN_LEFT.getName(), CSSNumericValue.createValue(CSSNumericType.PT, f));
        } else if (string.equals(RTF_MARGINRIGHT)) {
            float f = ((Float)object2).floatValue();
            converterAttributeSet2.addAttribute(PAGE_RULE_TYPE, BoxStyleKeys.MARGIN_RIGHT.getName(), CSSNumericValue.createValue(CSSNumericType.PT, f));
        } else if (string.equals(RTF_MARGINTOP)) {
            float f = ((Float)object2).floatValue();
            converterAttributeSet2.addAttribute(PAGE_RULE_TYPE, BoxStyleKeys.MARGIN_TOP.getName(), CSSNumericValue.createValue(CSSNumericType.PT, f));
        } else if (string.equals(RTF_MARGINBOTTOM)) {
            float f = ((Float)object2).floatValue();
            converterAttributeSet2.addAttribute(PAGE_RULE_TYPE, BoxStyleKeys.MARGIN_BOTTOM.getName(), CSSNumericValue.createValue(CSSNumericType.PT, f));
        } else if (string.equals(RTF_LANDSCAPE)) {
            Object object4 = converterAttributeSet.getAttribute(PageStyleKeys.SIZE.getName());
            if (object4 instanceof PageSize) {
                PageSize pageSize = (PageSize)object4;
                converterAttributeSet2.addAttribute(PAGE_RULE_TYPE, PageStyleKeys.SIZE.getName(), new PageSize(pageSize.getHeight(), pageSize.getWidth()));
            } else {
                converterAttributeSet2.addAttribute(PAGE_RULE_TYPE, PageStyleKeys.SIZE.getName(), RTF_LANDSCAPE);
            }
        } else {
            DebugLog.log((Object)("Unkown type of document attribute: " + string));
            return null;
        }
        return converterAttributeSet2;
    }

    private float twipToInt(float f) {
        return f * 20.0f;
    }
}

