/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.content;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.jfree.layouting.DocumentContextUtility;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.box.DisplayRole;
import org.jfree.layouting.input.style.keys.content.ContentStyleKeys;
import org.jfree.layouting.input.style.keys.content.ContentValues;
import org.jfree.layouting.input.style.keys.list.ListStyleKeys;
import org.jfree.layouting.input.style.values.CSSAttrFunction;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSStringType;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.computed.CloseQuoteToken;
import org.jfree.layouting.layouter.content.computed.ContentsToken;
import org.jfree.layouting.layouter.content.computed.CounterToken;
import org.jfree.layouting.layouter.content.computed.OpenQuoteToken;
import org.jfree.layouting.layouter.content.statics.StaticTextToken;
import org.jfree.layouting.layouter.context.ContentSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.counters.CounterStyle;
import org.jfree.layouting.layouter.counters.CounterStyleFactory;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionFactory;
import org.jfree.layouting.layouter.style.functions.content.ContentFunction;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ContentResolveHandler
implements ResolveHandler {
    private static final ContentToken[] DEFAULT_CONTENT = new ContentToken[]{ContentsToken.CONTENTS};
    private static final ContentToken[] PSEUDO_CONTENT = new ContentToken[0];
    private CSSValue listCounter;
    private HashMap tokenMapping = new HashMap();

    public ContentResolveHandler() {
        this.tokenMapping.put(ContentValues.CONTENTS, ContentsToken.CONTENTS);
        this.tokenMapping.put(ContentValues.OPEN_QUOTE, new OpenQuoteToken(false));
        this.tokenMapping.put(ContentValues.NO_OPEN_QUOTE, new OpenQuoteToken(true));
        this.tokenMapping.put(ContentValues.CLOSE_QUOTE, new CloseQuoteToken(false));
        this.tokenMapping.put(ContentValues.NO_CLOSE_QUOTE, new CloseQuoteToken(true));
        CSSStringValue cSSStringValue = new CSSStringValue(CSSStringType.STRING, "list-item");
        this.listCounter = new CSSFunctionValue("counter", new CSSValue[]{cSSStringValue});
    }

    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{ContentStyleKeys.COUNTER_RESET, ContentStyleKeys.COUNTER_INCREMENT, ContentStyleKeys.QUOTES, ContentStyleKeys.STRING_SET};
    }

    @Override
    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        Object object;
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        ContentSpecification contentSpecification = layoutContext.getContentSpecification();
        CSSValue cSSValue = layoutContext.getValue(styleKey);
        if (cSSValue instanceof CSSConstant) {
            if (ContentValues.NONE.equals(cSSValue)) {
                contentSpecification.setAllowContentProcessing(false);
                contentSpecification.setInhibitContent(false);
                contentSpecification.setContents(PSEUDO_CONTENT);
                return;
            }
            if (ContentValues.INHIBIT.equals(cSSValue)) {
                contentSpecification.setAllowContentProcessing(false);
                contentSpecification.setInhibitContent(true);
                contentSpecification.setContents(PSEUDO_CONTENT);
                return;
            }
            if (ContentValues.NORMAL.equals(cSSValue) && layoutContext.isPseudoElement()) {
                if (this.isListMarker(layoutElement)) {
                    this.processListItem(layoutProcess, layoutElement, contentSpecification);
                    return;
                }
                contentSpecification.setAllowContentProcessing(false);
                contentSpecification.setInhibitContent(true);
                contentSpecification.setContents(PSEUDO_CONTENT);
                return;
            }
        }
        contentSpecification.setInhibitContent(false);
        contentSpecification.setAllowContentProcessing(true);
        contentSpecification.setContents(DEFAULT_CONTENT);
        if (cSSValue instanceof CSSAttrFunction) {
            object = this.evaluateFunction((CSSFunctionValue)cSSValue, layoutProcess, layoutElement);
            if (object == null) {
                return;
            }
            contentSpecification.setContents(new ContentToken[]{object});
        }
        if (!(cSSValue instanceof CSSValueList)) {
            return;
        }
        object = new ArrayList();
        CSSValueList cSSValueList = (CSSValueList)cSSValue;
        int n = cSSValueList.getLength();
        for (int i = 0; i < n; ++i) {
            CSSValueList cSSValueList2 = (CSSValueList)cSSValueList.getItem(i);
            for (int j = 0; j < cSSValueList2.getLength(); ++j) {
                CSSValue cSSValue2 = cSSValueList2.getItem(j);
                ContentToken contentToken = this.createToken(layoutProcess, layoutElement, cSSValue2);
                if (contentToken == null) {
                    ((ArrayList)object).clear();
                    break;
                }
                ((ArrayList)object).add(contentToken);
            }
            if (((ArrayList)object).isEmpty()) continue;
            ContentToken[] contentTokenArray = ((ArrayList)object).toArray(new ContentToken[((ArrayList)object).size()]);
            contentSpecification.setContents(contentTokenArray);
            return;
        }
    }

    private void processListItem(LayoutProcess layoutProcess, LayoutElement layoutElement, ContentSpecification contentSpecification) {
        ContentToken contentToken;
        contentSpecification.setAllowContentProcessing(false);
        contentSpecification.setInhibitContent(false);
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(ListStyleKeys.LIST_STYLE_IMAGE);
        if (cSSValue != null && (contentToken = this.createToken(layoutProcess, layoutElement, cSSValue)) != null) {
            contentSpecification.setContents(new ContentToken[]{contentToken});
            return;
        }
        contentToken = this.createToken(layoutProcess, layoutElement, this.listCounter);
        if (contentToken instanceof CounterToken) {
            CounterToken counterToken = (CounterToken)contentToken;
            CounterStyle counterStyle = counterToken.getStyle();
            String string = counterStyle.getSuffix();
            if (string == null || string.length() == 0) {
                contentSpecification.setContents(new ContentToken[]{contentToken});
            } else {
                contentSpecification.setContents(new ContentToken[]{counterToken, new StaticTextToken(string)});
            }
        } else {
            contentSpecification.setContents(new ContentToken[]{contentToken});
        }
    }

    private boolean isListMarker(LayoutElement layoutElement) {
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        if (!"marker".equals(layoutContext.getPseudoElement())) {
            return false;
        }
        LayoutElement layoutElement2 = layoutElement.getParent();
        if (layoutElement2 == null) {
            return false;
        }
        CSSValue cSSValue = layoutElement2.getLayoutContext().getValue(BoxStyleKeys.DISPLAY_ROLE);
        return DisplayRole.LIST_ITEM.equals(cSSValue);
    }

    private ContentToken createToken(LayoutProcess layoutProcess, LayoutElement layoutElement, CSSValue cSSValue) {
        try {
            if (cSSValue instanceof CSSStringValue) {
                CSSStringValue cSSStringValue = (CSSStringValue)cSSValue;
                if (CSSStringType.STRING.equals(cSSStringValue.getType())) {
                    return new StaticTextToken(cSSStringValue.getValue());
                }
                CSSFunctionValue cSSFunctionValue = new CSSFunctionValue("url", new CSSValue[]{cSSStringValue});
                return this.evaluateFunction(cSSFunctionValue, layoutProcess, layoutElement);
            }
            if (cSSValue instanceof CSSConstant) {
                if (ContentValues.DOCUMENT_URL.equals(cSSValue)) {
                    Object object = layoutProcess.getDocumentContext().getMetaAttribute("document-url");
                    if (object != null) {
                        return new StaticTextToken(String.valueOf(object));
                    }
                    ResourceKey resourceKey = DocumentContextUtility.getBaseResource(layoutProcess.getDocumentContext());
                    ResourceManager resourceManager = DocumentContextUtility.getResourceManager(layoutProcess.getDocumentContext());
                    URL uRL = resourceManager.toURL(resourceKey);
                    if (uRL != null) {
                        return new StaticTextToken(uRL.toExternalForm());
                    }
                    return null;
                }
                ContentToken contentToken = (ContentToken)this.tokenMapping.get(cSSValue);
                if (contentToken != null) {
                    return contentToken;
                }
                return this.resolveContentAlias(cSSValue);
            }
            if (cSSValue instanceof CSSFunctionValue) {
                return this.evaluateFunction((CSSFunctionValue)cSSValue, layoutProcess, layoutElement);
            }
        }
        catch (Exception exception) {
            DebugLog.log((Object)("Content-Resolver: Failed to evaluate " + cSSValue));
        }
        return null;
    }

    private ContentToken resolveContentAlias(CSSValue cSSValue) {
        if (ContentValues.FOOTNOTE.equals(cSSValue)) {
            CounterStyle counterStyle = CounterStyleFactory.getInstance().getCounterStyle("normal");
            return new CounterToken("footnote", counterStyle);
        }
        if (ContentValues.ENDNOTE.equals(cSSValue)) {
            CounterStyle counterStyle = CounterStyleFactory.getInstance().getCounterStyle("normal");
            return new CounterToken("endnote", counterStyle);
        }
        if (ContentValues.SECTIONNOTE.equals(cSSValue)) {
            CounterStyle counterStyle = CounterStyleFactory.getInstance().getCounterStyle("normal");
            return new CounterToken("section-note", counterStyle);
        }
        if (ContentValues.LISTITEM.equals(cSSValue)) {
            CounterStyle counterStyle = CounterStyleFactory.getInstance().getCounterStyle("normal");
            return new CounterToken("list-item", counterStyle);
        }
        return null;
    }

    private ContentToken evaluateFunction(CSSFunctionValue cSSFunctionValue, LayoutProcess layoutProcess, LayoutElement layoutElement) {
        ContentFunction contentFunction = FunctionFactory.getInstance().getContentFunction(cSSFunctionValue.getFunctionName());
        if (contentFunction == null) {
            return null;
        }
        try {
            return contentFunction.evaluate(layoutProcess, layoutElement, cSSFunctionValue);
        }
        catch (FunctionEvaluationException functionEvaluationException) {
            DebugLog.log((Object)("Evaluation failed " + (Object)((Object)functionEvaluationException)));
            return null;
        }
    }
}

