/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.table.cols;

import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.util.LongList;

public class TableColumn {
    private Border border;
    private RenderLength definedWidth;
    private long computedMinChunkSize;
    private long computedMaximumWidth;
    private long computedPreferredSize;
    private long effectiveSize;
    private long effectiveCellPosition;
    private LongList minimumChunkSizes;
    private LongList maximumBoxWidths;
    private LongList preferredSizes;
    private boolean autoGenerated;
    private boolean validated;

    public TableColumn(Border border, RenderLength renderLength, boolean bl) {
        if (border == null) {
            throw new NullPointerException();
        }
        if (renderLength == null) {
            throw new NullPointerException();
        }
        this.definedWidth = renderLength;
        this.border = border;
        this.autoGenerated = bl;
        this.minimumChunkSizes = new LongList(10);
        this.maximumBoxWidths = new LongList(10);
        this.preferredSizes = new LongList(10);
    }

    public RenderLength getDefinedWidth() {
        return this.definedWidth;
    }

    public Border getBorder() {
        return this.border;
    }

    public long getComputedPreferredSize() {
        return this.computedPreferredSize;
    }

    public void setComputedPreferredSize(long l) {
        this.computedPreferredSize = l;
    }

    public long getComputedMinChunkSize() {
        return this.computedMinChunkSize;
    }

    public void setComputedMinChunkSize(long l) {
        if (this.isValidated()) {
            throw new IllegalStateException();
        }
        this.computedMinChunkSize = l;
    }

    public long getComputedMaximumWidth() {
        return this.computedMaximumWidth;
    }

    public void setComputedMaximumWidth(long l) {
        if (this.isValidated()) {
            throw new IllegalStateException();
        }
        this.computedMaximumWidth = l;
    }

    public long getEffectiveSize() {
        return this.effectiveSize;
    }

    public void setEffectiveSize(long l) {
        this.effectiveSize = l;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void setValidated(boolean bl) {
        this.validated = bl;
    }

    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public long getMinimumChunkSize(int n) {
        int n2 = n - 1;
        if (n2 < this.minimumChunkSizes.size()) {
            return this.minimumChunkSizes.get(n - 1);
        }
        return 0L;
    }

    public long getMaximumBoxWidth(int n) {
        int n2 = n - 1;
        if (n2 < this.maximumBoxWidths.size()) {
            return this.maximumBoxWidths.get(n - 1);
        }
        return 0L;
    }

    public long getPreferredWidth(int n) {
        int n2 = n - 1;
        if (n2 < this.preferredSizes.size()) {
            return this.preferredSizes.get(n - 1);
        }
        return 0L;
    }

    public void updateMinimumChunkSize(int n, long l) {
        int n2 = n - 1;
        if (this.minimumChunkSizes.size() <= n2) {
            this.minimumChunkSizes.set(n2, l);
        } else if (this.minimumChunkSizes.get(n2) < l) {
            this.minimumChunkSizes.set(n2, l);
        }
    }

    public void updateMaxBoxSize(int n, long l) {
        int n2 = n - 1;
        if (this.maximumBoxWidths.size() <= n2) {
            this.maximumBoxWidths.set(n2, l);
        } else if (this.maximumBoxWidths.get(n2) < l) {
            this.maximumBoxWidths.set(n2, l);
        }
    }

    public void updatePreferredSize(int n, long l) {
        int n2 = n - 1;
        if (this.preferredSizes.size() <= n2) {
            this.preferredSizes.set(n2, l);
        } else if (this.preferredSizes.get(n2) < l) {
            this.preferredSizes.set(n2, l);
        }
    }

    public int getMaxColspan() {
        return this.maximumBoxWidths.size();
    }

    public long getEffectiveCellPosition() {
        return this.effectiveCellPosition;
    }

    public void setEffectiveCellPosition(long l) {
        this.effectiveCellPosition = l;
    }
}

