/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import java.io.Serializable;
import java.util.ArrayList;
import org.jfree.layouting.renderer.model.BoxLayoutProperties;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;

public class ComputeMarginsStep
extends IterateVisualProcessStep {
    private long marginChangeKey;
    private ArrayList marginCollection;

    public void compute(LogicalPageBox logicalPageBox) {
        this.marginChangeKey = logicalPageBox.getChangeTracker();
        this.marginCollection = new ArrayList();
        this.startProcessing(logicalPageBox);
        this.marginChangeKey = 0L;
        this.marginCollection.clear();
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox paragraphRenderBox) {
        this.startProcessing(paragraphRenderBox.getPool());
    }

    @Override
    protected boolean startBlockLevelBox(RenderBox renderBox) {
        RenderNode renderNode;
        Serializable serializable;
        Object object;
        boolean bl;
        BoxLayoutProperties boxLayoutProperties = renderBox.getBoxLayoutProperties();
        if (boxLayoutProperties.getMarginOpenState() == this.marginChangeKey) {
            return true;
        }
        if (renderBox instanceof TableRowRenderBox || renderBox instanceof TableSectionRenderBox || renderBox instanceof TableCellRenderBox) {
            boxLayoutProperties.setMarginOpenState(this.marginChangeKey);
            return true;
        }
        RenderBox renderBox2 = renderBox.getParent();
        RenderNode renderNode2 = renderBox.getVisiblePrev();
        if (renderBox2 == null) {
            bl = renderNode2 == null;
        } else {
            object = renderBox2.getComputedLayoutProperties();
            serializable = renderBox2.getBoxLayoutProperties();
            bl = ((BoxLayoutProperties)serializable).isInfiniteMarginTop() && renderNode2 == null && ((ComputedLayoutProperties)object).getBorderTop() == 0L && ((ComputedLayoutProperties)object).getPaddingTop() != 0L;
        }
        this.marginCollection.clear();
        object = renderBox;
        while (true) {
            this.marginCollection.add(object);
            serializable = ((RenderNode)object).getComputedLayoutProperties();
            if (((ComputedLayoutProperties)serializable).getBorderBottom() != 0L || ((ComputedLayoutProperties)serializable).getPaddingBottom() != 0L || !((renderNode = ((RenderBox)object).getVisibleFirst()) instanceof RenderBox)) break;
            object = (RenderBox)renderNode;
        }
        if (bl) {
            for (int i = 0; i < this.marginCollection.size(); ++i) {
                renderNode = (RenderBox)this.marginCollection.get(i);
                BoxLayoutProperties boxLayoutProperties2 = ((RenderBox)renderNode).getBoxLayoutProperties();
                boxLayoutProperties2.setEffectiveMarginTop(0L);
                boxLayoutProperties2.setInfiniteMarginTop(true);
                boxLayoutProperties2.setMarginOpenState(this.marginChangeKey);
            }
            return true;
        }
        long l = 0L;
        long l2 = 0L;
        ComputedLayoutProperties computedLayoutProperties = renderBox.getComputedLayoutProperties();
        long l3 = computedLayoutProperties.getMarginTop();
        if (l3 < 0L) {
            l2 = l3;
        } else {
            l = l3;
        }
        if (renderNode2 != null) {
            long l4 = renderNode2.getEffectiveMarginBottom();
            if (l4 < 0L) {
                l2 = Math.min(l2, l4);
            } else {
                l = Math.max(l, l4);
            }
        }
        for (int i = 1; i < this.marginCollection.size(); ++i) {
            RenderBox renderBox3 = (RenderBox)this.marginCollection.get(i);
            BoxLayoutProperties boxLayoutProperties3 = renderBox3.getBoxLayoutProperties();
            ComputedLayoutProperties computedLayoutProperties2 = renderBox3.getComputedLayoutProperties();
            long l5 = computedLayoutProperties2.getMarginTop();
            if (l5 < 0L) {
                l2 = Math.min(l2, l5);
            } else {
                l = Math.max(l, l5);
            }
            boxLayoutProperties3.setMarginOpenState(this.marginChangeKey);
            boxLayoutProperties3.setInfiniteMarginTop(false);
            boxLayoutProperties3.setEffectiveMarginTop(0L);
        }
        long l6 = l + l2;
        boxLayoutProperties.setEffectiveMarginTop(l6);
        boxLayoutProperties.setInfiniteMarginTop(false);
        boxLayoutProperties.setMarginOpenState(this.marginChangeKey);
        return true;
    }

    @Override
    protected void finishBlockLevelBox(RenderBox renderBox) {
        RenderBox renderBox2;
        BoxLayoutProperties boxLayoutProperties = renderBox.getBoxLayoutProperties();
        if (boxLayoutProperties.getMarginCloseState() == this.marginChangeKey) {
            return;
        }
        if (renderBox instanceof TableCellRenderBox || renderBox instanceof TableRowRenderBox || renderBox instanceof TableSectionRenderBox) {
            boxLayoutProperties.setMarginCloseState(this.marginChangeKey);
            return;
        }
        this.marginCollection.clear();
        RenderBox renderBox3 = renderBox;
        while (true) {
            ComputedLayoutProperties computedLayoutProperties;
            this.marginCollection.add(renderBox3);
            if (renderBox3.getNext() != null || (renderBox2 = renderBox3.getParent()) == null || (computedLayoutProperties = renderBox2.getComputedLayoutProperties()).getBorderBottom() != 0L || computedLayoutProperties.getPaddingBottom() != 0L) break;
            renderBox3 = renderBox2;
        }
        renderBox2 = (RenderBox)this.marginCollection.get(this.marginCollection.size() - 1);
        if (renderBox2.getParent() == null) {
            for (int i = 0; i < this.marginCollection.size(); ++i) {
                RenderBox renderBox4 = (RenderBox)this.marginCollection.get(i);
                BoxLayoutProperties boxLayoutProperties2 = renderBox4.getBoxLayoutProperties();
                boxLayoutProperties2.setMarginCloseState(this.marginChangeKey);
                boxLayoutProperties2.setInfiniteMarginBottom(true);
                boxLayoutProperties2.setEffectiveMarginBottom(0L);
            }
            return;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < this.marginCollection.size(); ++i) {
            RenderBox renderBox5 = (RenderBox)this.marginCollection.get(i);
            BoxLayoutProperties boxLayoutProperties3 = renderBox5.getBoxLayoutProperties();
            boxLayoutProperties3.setMarginCloseState(this.marginChangeKey);
            boxLayoutProperties3.setInfiniteMarginBottom(false);
            boxLayoutProperties3.setEffectiveMarginBottom(0L);
            ComputedLayoutProperties computedLayoutProperties = renderBox5.getComputedLayoutProperties();
            l = Math.min(l, computedLayoutProperties.getMarginBottom());
            l2 = Math.max(l2, computedLayoutProperties.getMarginBottom());
        }
        BoxLayoutProperties boxLayoutProperties4 = renderBox2.getBoxLayoutProperties();
        boxLayoutProperties4.setEffectiveMarginBottom(l2 + l);
        boxLayoutProperties4.setInfiniteMarginBottom(false);
        boxLayoutProperties4.setMarginCloseState(this.marginChangeKey);
    }

    private boolean isCollapsibleTop(RenderNode renderNode) {
        if (!(renderNode instanceof RenderBox)) {
            return false;
        }
        RenderBox renderBox = (RenderBox)renderNode;
        ComputedLayoutProperties computedLayoutProperties = renderBox.getComputedLayoutProperties();
        if (computedLayoutProperties.getBorderTop() != 0L) {
            return false;
        }
        return computedLayoutProperties.getPaddingTop() == 0L;
    }
}

