/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.input.style.keys.box.DisplayRole;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.renderer.model.PageAreaRenderBox;
import org.jfree.layouting.renderer.model.ParagraphPoolBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableColumnGroupNode;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.process.BoxShifter;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;

public class SimplePaginationStep
extends IterateVisualProcessStep {
    private long shift;
    private long stickyMarker;
    private BoxShifter boxShifter = new BoxShifter();
    private long footerHeight;
    private long headerHeight;

    public void performPagebreak(LogicalPageBox logicalPageBox) {
        this.stickyMarker = logicalPageBox.getChangeTracker();
        this.shift = 0L;
        this.startRootProcessing(logicalPageBox);
    }

    private void startRootProcessing(LogicalPageBox logicalPageBox) {
        PageAreaRenderBox pageAreaRenderBox = logicalPageBox.getHeaderArea();
        this.headerHeight = pageAreaRenderBox.getHeight();
        PageAreaRenderBox pageAreaRenderBox2 = logicalPageBox.getFooterArea();
        this.footerHeight = pageAreaRenderBox2.getHeight();
        this.startProcessing(logicalPageBox);
    }

    @Override
    protected boolean startInlineLevelBox(RenderBox renderBox) {
        return false;
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox paragraphRenderBox) {
        for (RenderNode renderNode = paragraphRenderBox.getVisibleFirst(); renderNode != null; renderNode = renderNode.getVisibleNext()) {
            if (!(renderNode instanceof ParagraphPoolBox)) {
                throw new IllegalStateException("Encountered " + renderNode.getClass());
            }
            ParagraphPoolBox paragraphPoolBox = (ParagraphPoolBox)renderNode;
            if (this.startLine(paragraphPoolBox)) {
                this.processBoxChilds(paragraphPoolBox);
            }
            this.finishLine(paragraphPoolBox);
        }
    }

    private boolean isNodeProcessable(RenderNode renderNode) {
        if (renderNode.getStickyMarker() == this.stickyMarker) {
            return false;
        }
        return !renderNode.isIgnorableForRendering();
    }

    @Override
    protected void processBlockLevelNode(RenderNode renderNode) {
        if (!this.isNodeProcessable(renderNode)) {
            return;
        }
        renderNode.setY(renderNode.getY() + this.shift);
        renderNode.setY(renderNode.getY() + this.shift);
        renderNode.setStickyMarker(this.stickyMarker);
    }

    protected void processTable(TableRenderBox tableRenderBox) {
        long l = this.shift;
        long l2 = tableRenderBox.getHeight();
        long l3 = tableRenderBox.getY();
        long l4 = this.shift + l3 + l2;
        if (tableRenderBox.isIgnorableForRendering()) {
            return;
        }
        tableRenderBox.setY(tableRenderBox.getY() + this.shift);
        tableRenderBox.setStickyMarker(this.stickyMarker);
        this.processTableSection(tableRenderBox, DisplayRole.TABLE_HEADER_GROUP);
        this.processTableSection(tableRenderBox, DisplayRole.TABLE_ROW_GROUP);
        this.processTableSection(tableRenderBox, DisplayRole.TABLE_FOOTER_GROUP);
        long l5 = tableRenderBox.getHeight();
        long l6 = l5 - l2;
        if (l6 < 0L) {
            throw new IllegalStateException("A table can/must not shrink!");
        }
    }

    private void processTableSection(TableRenderBox tableRenderBox, CSSConstant cSSConstant) {
        RenderNode renderNode = tableRenderBox.getFirstChild();
        while (renderNode != null) {
            if (!(renderNode instanceof TableSectionRenderBox)) {
                renderNode = renderNode.getNext();
                continue;
            }
            TableSectionRenderBox tableSectionRenderBox = (TableSectionRenderBox)renderNode;
            if (!cSSConstant.equals(tableSectionRenderBox.getDisplayRole())) {
                renderNode = renderNode.getNext();
                continue;
            }
            this.startProcessing(renderNode);
            renderNode = renderNode.getNext();
        }
    }

    @Override
    protected void processBlockLevelChild(RenderNode renderNode) {
        if (renderNode instanceof TableRenderBox) {
            TableRenderBox tableRenderBox = (TableRenderBox)renderNode;
            this.processTable(tableRenderBox);
        } else {
            super.processBlockLevelChild(renderNode);
        }
    }

    @Override
    protected boolean startBlockLevelBox(RenderBox renderBox) {
        if (!this.isNodeProcessable(renderBox)) {
            return false;
        }
        long l = renderBox.getY();
        if (renderBox instanceof TableCellRenderBox) {
            renderBox.setY(l + this.shift);
            renderBox.setStickyMarker(this.stickyMarker);
            return true;
        }
        if (renderBox instanceof TableColumnGroupNode) {
            throw new IllegalArgumentException("This is not expected here");
        }
        renderBox.setY(renderBox.getY() + this.shift);
        renderBox.setStickyMarker(this.stickyMarker);
        return true;
    }

    protected boolean startLine(ParagraphPoolBox paragraphPoolBox) {
        if (!this.isNodeProcessable(paragraphPoolBox)) {
            return false;
        }
        this.boxShifter.shiftBox(paragraphPoolBox, this.shift);
        return false;
    }

    protected void finishLine(ParagraphPoolBox paragraphPoolBox) {
    }
}

