/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import org.pentaho.reporting.libraries.fonts.io.FileFontDataInputSource;
import org.pentaho.reporting.libraries.fonts.registry.FontContext;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.registry.FontType;
import org.pentaho.reporting.libraries.fonts.truetype.ScalableTrueTypeFontMetrics;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFont;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFontIdentifier;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFontMetrics;

public class TrueTypeFontMetricsFactory
implements FontMetricsFactory {
    private static final Logger logger = Logger.getLogger(TrueTypeFontMetricsFactory.class.getName());
    private HashMap fontRecords = new HashMap();

    @Override
    public FontMetrics createMetrics(FontIdentifier record, FontContext context) {
        if (!FontType.OPENTYPE.equals(record.getFontType())) {
            throw new IllegalArgumentException("This identifier does not belong to the OpenType-font system.");
        }
        TrueTypeFontIdentifier ttfId = (TrueTypeFontIdentifier)record;
        ScalableTrueTypeFontMetrics fromCache = (ScalableTrueTypeFontMetrics)this.fontRecords.get(ttfId);
        if (fromCache != null) {
            return new TrueTypeFontMetrics(fromCache, context.getFontSize());
        }
        try {
            String fontSource = ttfId.getFontSource();
            FileFontDataInputSource fdis = new FileFontDataInputSource(new File(fontSource));
            TrueTypeFont font = new TrueTypeFont(fdis);
            ScalableTrueTypeFontMetrics fontMetrics = new ScalableTrueTypeFontMetrics(font);
            this.fontRecords.put(ttfId, fontMetrics);
            return new TrueTypeFontMetrics(fontMetrics, context.getFontSize());
        }
        catch (IOException e) {
            logger.warning("Unable to read the font: " + e);
            throw new IllegalStateException();
        }
    }
}

