/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.DependencyCollector;
import org.pentaho.reporting.libraries.resourceloader.FactoryParameterKey;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.RootXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractXmlReadHandler
implements XmlReadHandler {
    private static final Logger logger = Logger.getLogger(AbstractXmlReadHandler.class.getName());
    private RootXmlReadHandler rootHandler;
    private String tagName;
    private String uri;
    private boolean firstCall;

    protected AbstractXmlReadHandler() {
    }

    @Override
    public void init(RootXmlReadHandler rootHandler, String uri, String tagName) {
        if (rootHandler == null) {
            throw new NullPointerException("Root handler must not be null");
        }
        if (tagName == null) {
            throw new NullPointerException("Tag name must not be null");
        }
        this.uri = uri;
        this.rootHandler = rootHandler;
        this.tagName = tagName;
        this.firstCall = true;
    }

    @Override
    public final void startElement(String uri, String tagName, Attributes attrs) throws SAXException {
        if (this.firstCall) {
            if (!this.tagName.equals(tagName) || !this.uri.equals(uri)) {
                throw new ParseException("Expected <" + this.tagName + ">, found <" + tagName + '>', this.getLocator());
            }
            this.firstCall = false;
            this.startParsing(attrs);
        } else {
            XmlReadHandler childHandler = this.getHandlerForChild(uri, tagName, attrs);
            if (childHandler == null) {
                logger.warning("Unknown tag <" + uri + ':' + tagName + ">: Start to ignore this element and all of its childs. " + this.getLocatorString());
                logger.config(this.getClass().getName());
                IgnoreAnyChildReadHandler ignoreAnyChildReadHandler = new IgnoreAnyChildReadHandler();
                ignoreAnyChildReadHandler.init(this.getRootHandler(), uri, tagName);
                this.rootHandler.recurse(ignoreAnyChildReadHandler, uri, tagName, attrs);
            } else {
                childHandler.init(this.getRootHandler(), uri, tagName);
                this.rootHandler.recurse(childHandler, uri, tagName, attrs);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public final void endElement(String uri, String tagName) throws SAXException {
        if (!this.tagName.equals(tagName) || !this.uri.equals(uri)) {
            throw new ParseException("Illegal Parser State." + this.toString(), this.getLocator());
        }
        this.doneParsing();
        this.rootHandler.unwind(uri, tagName);
    }

    private String getLocatorString() {
        Locator locator = this.getLocator();
        if (locator == null) {
            return "";
        }
        StringBuffer message = new StringBuffer(100);
        message.append(" [Location: Line=");
        message.append(locator.getLineNumber());
        message.append(" Column=");
        message.append(locator.getColumnNumber());
        message.append("] ");
        return message.toString();
    }

    protected void startParsing(Attributes attrs) throws SAXException {
    }

    protected void doneParsing() throws SAXException {
    }

    protected boolean isSameNamespace(String namespaceURI) {
        return ObjectUtilities.equal((Object)namespaceURI, (Object)this.getUri());
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        return null;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getUri() {
        return this.uri;
    }

    public RootXmlReadHandler getRootHandler() {
        return this.rootHandler;
    }

    public Locator getLocator() {
        return this.rootHandler.getDocumentLocator();
    }

    protected Object performExternalParsing(String file, Class targetClass) throws ParseException, ResourceLoadingException {
        return this.performExternalParsing(file, targetClass, this.deriveParseParameters());
    }

    protected Object performExternalParsing(String file, Class targetClass, Map map) throws ParseException, ResourceLoadingException {
        try {
            ResourceManager resourceManager = this.rootHandler.getResourceManager();
            ResourceKey source = this.rootHandler.getSource();
            ResourceKey target = resourceManager.deriveKey(source, file, map);
            DependencyCollector dc = this.rootHandler.getDependencyCollector();
            Resource resource = resourceManager.create(target, this.rootHandler.getContext(), targetClass);
            dc.add(resource);
            return resource.getResource();
        }
        catch (ResourceLoadingException rle) {
            throw rle;
        }
        catch (ResourceException e) {
            throw new ParseException("Failure while loading data: " + file, (Exception)((Object)e), this.getLocator());
        }
    }

    protected Map deriveParseParameters() {
        RootXmlReadHandler rootHandler = this.getRootHandler();
        HashMap<FactoryParameterKey, Object> map = new HashMap<FactoryParameterKey, Object>();
        for (String name : rootHandler.getHelperObjectNames()) {
            FactoryParameterKey key = new FactoryParameterKey(name);
            map.put(key, rootHandler.getHelperObject(name));
        }
        return map;
    }
}

