/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.loader.AbstractResourceData;

public class URLResourceData
extends AbstractResourceData {
    private long lastDateMetaDataRead;
    private long modificationDate;
    private String filename;
    private Long contentLength;
    private String contentType;
    private boolean metaDataOK;
    private URL url;
    private ResourceKey key;
    private static final long serialVersionUID = -7183025686032509509L;

    public URLResourceData(ResourceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.modificationDate = -1L;
        this.key = key;
        this.url = (URL)key.getIdentifier();
        this.filename = IOUtils.getInstance().getFileName(this.url);
    }

    protected URLResourceData() {
    }

    protected void setUrl(URL url) {
        this.url = url;
    }

    protected void setKey(ResourceKey key) {
        this.key = key;
    }

    protected void setFilename(String filename) {
        this.filename = filename;
    }

    protected URL getUrl() {
        return this.url;
    }

    protected String getFilename() {
        return this.filename;
    }

    private void readMetaData() throws IOException {
        if (this.metaDataOK && System.currentTimeMillis() - this.lastDateMetaDataRead < 5000L) {
            return;
        }
        URLConnection c = this.url.openConnection();
        c.setDoOutput(false);
        c.setAllowUserInteraction(false);
        if (c instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)c;
            httpURLConnection.setRequestMethod("HEAD");
        }
        c.connect();
        this.modificationDate = c.getDate();
        this.contentLength = new Long(c.getContentLength());
        this.contentType = c.getHeaderField("content-type");
        c.getInputStream().close();
        this.metaDataOK = true;
        this.lastDateMetaDataRead = System.currentTimeMillis();
    }

    @Override
    public InputStream getResourceAsStream(ResourceManager caller) throws ResourceLoadingException {
        try {
            URLConnection c = this.url.openConnection();
            c.setDoOutput(false);
            c.setAllowUserInteraction(false);
            return c.getInputStream();
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Failed to open URL connection", e);
        }
    }

    @Override
    public Object getAttribute(String key) {
        if (key.equals("filename")) {
            return this.filename;
        }
        if (key.equals("content-length")) {
            try {
                if (!this.metaDataOK) {
                    this.readMetaData();
                }
                return this.contentLength;
            }
            catch (IOException e) {
                return null;
            }
        }
        if (key.equals("content-type")) {
            try {
                if (!this.metaDataOK) {
                    this.readMetaData();
                }
                return this.contentType;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public long getVersion(ResourceManager caller) throws ResourceLoadingException {
        try {
            this.readMetaData();
            return this.modificationDate;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Override
    public ResourceKey getKey() {
        return this.key;
    }
}

