/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader.resource;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.loader.LoaderUtils;
import org.pentaho.reporting.libraries.resourceloader.loader.resource.ClassloaderResourceData;

public class ClassloaderResourceLoader
implements ResourceLoader {
    public static final String SCHEMA_NAME = ClassloaderResourceLoader.class.getName();
    private static final Logger logger = Logger.getLogger(ClassloaderResourceLoader.class.getName());

    @Override
    public boolean isSupportedKey(ResourceKey key) {
        return SCHEMA_NAME.equals(key.getSchema());
    }

    @Override
    public ResourceKey createKey(Object value, Map factoryKeys) throws ResourceKeyCreationException {
        String valueString;
        if (value instanceof String && (valueString = (String)value).startsWith("res://")) {
            return new ResourceKey(SCHEMA_NAME, value, factoryKeys);
        }
        return null;
    }

    @Override
    public ResourceKey deriveKey(ResourceKey parent, String path, Map factoryKeys) throws ResourceKeyCreationException {
        HashMap map;
        if (!this.isSupportedKey(parent)) {
            throw new ResourceKeyCreationException("Assertation: Unsupported parent key type");
        }
        String resource = path.startsWith("res://") ? path : (path.length() > 0 && path.charAt(0) == '/' ? "res:/" + path : LoaderUtils.mergePaths((String)parent.getIdentifier(), path));
        if (factoryKeys != null) {
            map = new HashMap();
            map.putAll(parent.getFactoryParameters());
            map.putAll(factoryKeys);
        } else {
            map = parent.getFactoryParameters();
        }
        return new ResourceKey(parent.getSchema(), resource, map);
    }

    @Override
    public URL toURL(ResourceKey key) {
        return null;
    }

    @Override
    public ResourceData load(ResourceKey key) throws ResourceLoadingException {
        if (!this.isSupportedKey(key)) {
            throw new ResourceLoadingException("Key format is not recognized.");
        }
        return new ClassloaderResourceData(key);
    }

    public static String createResourceKey(Class c, String resource) {
        if (c == null) {
            return "res://" + resource;
        }
        String className = c.getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot < 0) {
            return "res://" + resource;
        }
        String packageName = className.substring(0, lastDot);
        String packagePath = packageName.replace('.', '/');
        return "res://" + packageName + '/' + packagePath;
    }

    @Override
    public String serialize(ResourceKey bundleKey, ResourceKey key) throws ResourceException {
        if (key == null) {
            throw new NullPointerException("The ResourceKey can not be null");
        }
        if (!this.isSupportedKey(key)) {
            throw new IllegalArgumentException("Key format is not recognized.");
        }
        if (!(key.getIdentifier() instanceof String)) {
            throw new IllegalArgumentException("ResourceKey is invalid - identifier is not a String object");
        }
        logger.config("Serializing a Classloader Resource Key...");
        if (key.getParent() != null) {
            throw new ResourceException("Cannot serialize this key, it contains a parent, but should not contain one at all.");
        }
        String result = ResourceKeyUtils.createStringResourceKey(key.getSchema().toString(), (String)key.getIdentifier(), key.getFactoryParameters());
        logger.config("Serialized Classloader Resource Key: [" + result + "]");
        return result;
    }

    @Override
    public ResourceKey deserialize(ResourceKey bundleKey, String stringKey) throws ResourceKeyCreationException {
        ResourceKeyData keyData = ResourceKeyUtils.parse(stringKey);
        if (!SCHEMA_NAME.equals(keyData.getSchema())) {
            throw new ResourceKeyCreationException("Serialized version of key does not contain correct schema");
        }
        return this.createKey(keyData.getIdentifier(), keyData.getFactoryParameters());
    }

    @Override
    public boolean isSupportedDeserializer(String data) {
        return SCHEMA_NAME.equals(ResourceKeyUtils.readSchemaFromString(data));
    }
}

