/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.function.text.MidFunction;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class ReplaceFunction
implements Function {
    private static final long serialVersionUID = -7678830657739807780L;

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount != 4) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Type newTextType = parameters.getType(3);
        Object newTextValue = parameters.getValue(3);
        Type textType = parameters.getType(0);
        Object textValue = parameters.getValue(0);
        Type startType = parameters.getType(1);
        Object startValue = parameters.getValue(1);
        Type lengthType = parameters.getType(2);
        Object lengthValue = parameters.getValue(2);
        String newText = typeRegistry.convertToText(newTextType, newTextValue);
        String text = typeRegistry.convertToText(textType, textValue);
        Number start = typeRegistry.convertToNumber(startType, startValue);
        if (start.intValue() <= 0) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        Number length = typeRegistry.convertToNumber(lengthType, lengthValue);
        if (length.intValue() < 0) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        String result1 = MidFunction.process(text, 1, start.intValue() - 1);
        String result2 = MidFunction.process(text, start.intValue() + length.intValue(), text.length());
        StringBuffer buffer = new StringBuffer(result1.length() + newText.length() + result2.length());
        buffer.append(result1);
        buffer.append(newText);
        buffer.append(result2);
        return new TypeValuePair(TextType.TYPE, buffer.toString());
    }

    @Override
    public String getCanonicalName() {
        return "REPLACE";
    }
}

