/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSSLEngine;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLEngine;
import org.bouncycastle.jsse.provider.ProvSSLEngine_9;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.jsse.provider.SSLSessionUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class SSLEngineUtil {
    SSLEngineUtil() {
    }

    static ProvSSLEngine create(ContextData contextData) {
        return new ProvSSLEngine_9(contextData);
    }

    static ProvSSLEngine create(ContextData contextData, String string, int n) {
        return new ProvSSLEngine_9(contextData, string, n);
    }

    static BCExtendedSSLSession importHandshakeSession(SSLEngine sSLEngine) {
        SSLSession sSLSession;
        if (sSLEngine instanceof BCSSLEngine) {
            return ((BCSSLEngine)((Object)sSLEngine)).getBCHandshakeSession();
        }
        if (null != sSLEngine && null != (sSLSession = sSLEngine.getHandshakeSession())) {
            return SSLSessionUtil.importSSLSession(sSLSession);
        }
        return null;
    }

    static BCSSLParameters importSSLParameters(SSLEngine sSLEngine) {
        if (sSLEngine instanceof BCSSLEngine) {
            return ((BCSSLEngine)((Object)sSLEngine)).getParameters();
        }
        if (null == sSLEngine) {
            return null;
        }
        SSLParameters sSLParameters = sSLEngine.getSSLParameters();
        if (null == sSLParameters) {
            throw new RuntimeException("SSLEngine.getSSLParameters returned null");
        }
        return SSLParametersUtil.importSSLParameters(sSLParameters);
    }
}

