/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html.renderer;

import com.vladsch.flexmark.html.UriContentResolver;
import com.vladsch.flexmark.html.UriContentResolverFactory;
import com.vladsch.flexmark.html.renderer.LinkResolverBasicContext;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.ResolvedContent;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.dependency.LastDependent;
import com.vladsch.flexmark.util.misc.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUriContentResolver
implements UriContentResolver {
    public FileUriContentResolver(LinkResolverBasicContext context) {
    }

    @Override
    @NotNull
    public ResolvedContent resolveContent(@NotNull Node node, @NotNull LinkResolverBasicContext context, @NotNull ResolvedContent content) {
        String substring;
        File includedFile;
        String url;
        ResolvedLink resolvedLink = content.getResolvedLink();
        if (resolvedLink.getStatus() == LinkStatus.VALID && (url = resolvedLink.getUrl()).startsWith("file:/") && (includedFile = new File(substring = url.startsWith("file://") ? url.substring("file://".length()) : (File.separatorChar == '\\' ? url.substring("file:/".length()) : url.substring("file:".length())))).isFile() && includedFile.exists()) {
            try {
                return content.withContent(FileUtil.getFileContentBytesWithExceptions((File)includedFile)).withStatus(LinkStatus.VALID);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    public static class Factory
    implements UriContentResolverFactory {
        @Override
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return Collections.singleton(LastDependent.class);
        }

        @Override
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        @NotNull
        public UriContentResolver apply(@NotNull LinkResolverBasicContext context) {
            return new FileUriContentResolver(context);
        }
    }
}

