/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class WebdavIfHeader {
    private static final Log log = LogFactory.getLog(WebdavIfHeader.class);
    private static final StringManager sm = StringManager.getManager((String)WebdavIfHeader.class.getPackage().getName());
    private final String headerValue;
    private final IfHeaderInterface ifHeader;
    private final List<String> resources = new ArrayList<String>();
    private final List<String> allTokens = new ArrayList<String>();
    private final List<String> allNotTokens = new ArrayList<String>();
    private String uriPrefix;

    public WebdavIfHeader(String[] tokens) throws IOException {
        this.allTokens.addAll(Arrays.asList(tokens));
        StringBuilder b = new StringBuilder();
        for (String token : tokens) {
            b.append("(").append("<");
            b.append(token);
            b.append(">").append(")");
        }
        this.headerValue = b.toString();
        this.ifHeader = this.parse();
    }

    public WebdavIfHeader(String uriPrefix, String ifHeaderValue) throws IOException {
        this.uriPrefix = uriPrefix;
        this.headerValue = ifHeaderValue;
        this.ifHeader = this.parse();
    }

    public String getHeaderName() {
        return "If";
    }

    public String getHeaderValue() {
        return this.headerValue;
    }

    public boolean hasValue() {
        return this.ifHeader != null;
    }

    public boolean matches(String tag, List<String> tokens, String etag) {
        if (this.ifHeader == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"matches: No If header, assume match");
            }
            return true;
        }
        return this.ifHeader.matches(tag, tokens, etag);
    }

    public Iterator<String> getResources() {
        return this.resources.iterator();
    }

    public Iterator<String> getAllTokens() {
        return this.allTokens.iterator();
    }

    public Iterator<String> getAllNotTokens() {
        return this.allNotTokens.iterator();
    }

    private IfHeaderInterface parse() throws IOException {
        Cloneable ifHeader;
        if (this.headerValue != null && !this.headerValue.isEmpty()) {
            int firstChar = 0;
            try (StringReader reader = new StringReader(this.headerValue);){
                try {
                    reader.mark(1);
                    firstChar = this.readWhiteSpace(reader);
                    reader.reset();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (firstChar == 40) {
                    ifHeader = this.parseUntagged(reader);
                }
                if (firstChar == 60) {
                    ifHeader = this.parseTagged(reader);
                }
                this.logIllegalState("If", firstChar, "(<", null);
                ifHeader = null;
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)"IfHeader: No If header in request");
            }
            ifHeader = null;
        }
        return ifHeader;
    }

    private IfHeaderMap parseTagged(StringReader reader) throws IOException {
        int c;
        IfHeaderMap map = new IfHeaderMap();
        while ((c = this.readWhiteSpace(reader)) >= 0) {
            if (c == 60) {
                String resource = this.readWord(reader, '>');
                if (resource == null) break;
                map.put(resource, this.parseUntagged(reader));
                this.resources.add(resource);
                continue;
            }
            this.logIllegalState("Tagged", c, "<", reader);
        }
        return map;
    }

    private IfHeaderList parseUntagged(StringReader reader) throws IOException {
        IfHeaderList list = new IfHeaderList();
        while (true) {
            reader.mark(1);
            int c = this.readWhiteSpace(reader);
            if (c < 0) break;
            if (c == 40) {
                list.add(this.parseIfList(reader));
                continue;
            }
            if (c == 60) {
                reader.reset();
                break;
            }
            this.logIllegalState("Untagged", c, "(", reader);
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IfList parseIfList(StringReader reader) throws IOException {
        IfList res = new IfList();
        boolean positive = true;
        block6: while (true) {
            int nextChar = this.readWhiteSpace(reader);
            switch (nextChar) {
                case 78: 
                case 110: {
                    int not = reader.read();
                    if (not != 111 && not != 79) {
                        this.logIllegalState("IfList-Not", not, "o", null);
                        continue block6;
                    }
                    not = reader.read();
                    if (not != 116 && not != 84) {
                        this.logIllegalState("IfList-Not", not, "t", null);
                        continue block6;
                    }
                    positive = false;
                    continue block6;
                }
                case 60: {
                    String word = this.readWord(reader, '>');
                    if (word == null) continue block6;
                    res.add(new IfListEntryToken(word, positive));
                    if (positive) {
                        this.allTokens.add(word);
                    } else {
                        this.allNotTokens.add(word);
                    }
                    positive = true;
                    continue block6;
                }
                case 91: {
                    String word = this.readWord(reader, ']');
                    if (word == null) continue block6;
                    res.add(new IfListEntryEtag(word, positive));
                    positive = true;
                    continue block6;
                }
                case 41: {
                    if (!log.isTraceEnabled()) return res;
                    log.trace((Object)"parseIfList: End of If list, terminating loop");
                    return res;
                }
                default: {
                    this.logIllegalState("IfList", nextChar, "nN<[)", reader);
                    if (nextChar < 0) return res;
                    continue block6;
                }
            }
            break;
        }
    }

    private int readWhiteSpace(Reader reader) throws IOException {
        int c = reader.read();
        while (c >= 0 && Character.isWhitespace((char)c)) {
            c = reader.read();
        }
        return c;
    }

    private String readWord(Reader reader, char end) throws IOException {
        StringBuilder buf = new StringBuilder();
        int c = reader.read();
        while (c >= 0 && c != end) {
            buf.append((char)c);
            c = reader.read();
        }
        if (c < 0) {
            log.error((Object)"readWord: Unexpected end of input reading word");
            return null;
        }
        return buf.toString();
    }

    private void logIllegalState(String state, int effChar, String expChar, StringReader reader) {
        String effString = effChar < 0 ? "<EOF>" : String.valueOf((char)effChar);
        log.error((Object)sm.getString("webdavifheader.unexpectedCharacter", new Object[]{effString, state, expChar}));
        if (reader != null && effChar >= 0) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("logIllegalState: Catch up to any of " + expChar));
                }
                do {
                    reader.mark(1);
                } while ((effChar = reader.read()) >= 0 && expChar.indexOf(effChar) < 0);
                if (effChar >= 0) {
                    reader.reset();
                }
            }
            catch (IOException ioe) {
                log.error((Object)sm.getString("webdavifheader.ioError", new Object[]{expChar}));
            }
        }
    }

    private static interface IfHeaderInterface {
        public boolean matches(String var1, List<String> var2, String var3);
    }

    private static class IfHeaderList
    extends ArrayList<IfList>
    implements IfHeaderInterface {
        private static final long serialVersionUID = 1L;

        private IfHeaderList() {
        }

        @Override
        public boolean matches(String resource, List<String> tokens, String etag) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("matches: Trying to match token=" + tokens + ", etag=" + etag));
            }
            for (IfList il : this) {
                if (!il.match(tokens, etag)) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("matches: Found match with " + il));
                }
                return true;
            }
            return false;
        }
    }

    private class IfHeaderMap
    extends HashMap<String, IfHeaderList>
    implements IfHeaderInterface {
        private static final long serialVersionUID = 1L;

        private IfHeaderMap() {
        }

        @Override
        public boolean matches(String resource, List<String> tokens, String etag) {
            String uri;
            String path;
            if (log.isTraceEnabled()) {
                log.trace((Object)("matches: Trying to match resource=" + resource + ", token=" + tokens + "," + etag));
            }
            if (resource.startsWith("/")) {
                path = resource;
                uri = WebdavIfHeader.this.uriPrefix + resource;
            } else {
                path = resource.substring(WebdavIfHeader.this.uriPrefix.length());
                uri = resource;
            }
            IfHeaderList list = (IfHeaderList)this.get(path);
            if (list == null) {
                list = (IfHeaderList)this.get(uri);
            }
            if (list == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("matches: No entry for tag " + resource + ", assuming mismatch"));
                }
                return false;
            }
            return list.matches(resource, tokens, etag);
        }
    }

    private static class IfList
    extends ArrayList<IfListEntry> {
        private static final long serialVersionUID = 1L;

        private IfList() {
        }

        @Override
        public boolean add(IfListEntry entry) {
            return super.add(entry);
        }

        @Override
        public void add(int index, IfListEntry entry) {
            super.add(index, entry);
        }

        public boolean match(List<String> tokens, String etag) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("match: Trying to match token=" + tokens + ", etag=" + etag));
            }
            for (int i = 0; i < this.size(); ++i) {
                IfListEntry ile = (IfListEntry)this.get(i);
                boolean match = false;
                for (String token : tokens) {
                    if (!ile.match(token, etag)) continue;
                    match = true;
                }
                if (match) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("match: Entry " + i + "-" + ile + " does not match"));
                }
                return false;
            }
            return true;
        }
    }

    private static class IfListEntryToken
    extends IfListEntry {
        IfListEntryToken(String token, boolean positive) {
            super(token, positive);
        }

        @Override
        public boolean match(String token, String etag) {
            return token == null || super.match(token);
        }

        @Override
        protected String getType() {
            return "Token";
        }
    }

    private static abstract class IfListEntry {
        protected final String value;
        protected final boolean positive;
        protected String stringValue;

        protected IfListEntry(String value, boolean positive) {
            this.value = value;
            this.positive = positive;
        }

        protected boolean match(String value) {
            return this.positive == this.value.equals(value);
        }

        public abstract boolean match(String var1, String var2);

        protected abstract String getType();

        protected String getValue() {
            return this.value;
        }

        public String toString() {
            if (this.stringValue == null) {
                this.stringValue = this.getType() + ": " + (this.positive ? "" : "!") + this.getValue();
            }
            return this.stringValue;
        }
    }

    private static class IfListEntryEtag
    extends IfListEntry {
        IfListEntryEtag(String etag, boolean positive) {
            super(etag, positive);
        }

        @Override
        public boolean match(String token, String etag) {
            return super.match(etag);
        }

        @Override
        protected String getType() {
            return "ETag";
        }
    }
}

