/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.model.Command;

public class HuaShengProtocolEncoder
extends BaseProtocolEncoder {
    public HuaShengProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private ByteBuf encodeContent(int type, ByteBuf content) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(192);
        buf.writeShort(0);
        buf.writeShort(12 + content.readableBytes());
        buf.writeShort(type);
        buf.writeShort(0);
        buf.writeInt(1);
        buf.writeBytes(content);
        content.release();
        buf.writeByte(192);
        return buf;
    }

    @Override
    protected Object encodeCommand(Command command) {
        ByteBuf content = Unpooled.buffer((int)0);
        switch (command.getType()) {
            case "positionPeriodic": {
                content.writeShort(2);
                content.writeShort(6);
                content.writeShort(command.getInteger("frequency"));
                return this.encodeContent(43524, content);
            }
            case "outputControl": {
                content.writeByte((command.getInteger("index") - 1) * 2 + (2 - command.getInteger("data")));
                return this.encodeContent(43542, content);
            }
            case "alarmArm": 
            case "alarmDisarm": {
                content.writeShort(1);
                content.writeShort(5);
                content.writeByte(command.getType().equals("alarmArm") ? 1 : 0);
                return this.encodeContent(43524, content);
            }
            case "setSpeedLimit": {
                content.writeShort(4);
                content.writeShort(6);
                content.writeShort(command.getInteger("data"));
                return this.encodeContent(43524, content);
            }
        }
        return null;
    }
}

