/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SchemaRef;
import com.networknt.schema.annotation.Annotation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.utils.SchemaRefs;

public class ItemsValidator
extends BaseKeywordValidator {
    private final Schema schema;
    private final int prefixCount;
    private final boolean additionalItems;

    public ItemsValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.ITEMS, schemaNode, schemaLocation, parentSchema, schemaContext);
        JsonNode prefixItems = parentSchema.getSchemaNode().get("prefixItems");
        if (prefixItems instanceof ArrayNode) {
            this.prefixCount = prefixItems.size();
        } else if (null == prefixItems) {
            this.prefixCount = 0;
        } else {
            throw new IllegalArgumentException("The value of 'prefixItems' must be an array of JSON Schema.");
        }
        if (!schemaNode.isObject() && !schemaNode.isBoolean()) {
            throw new IllegalArgumentException("The value of 'items' MUST be a valid JSON Schema.");
        }
        this.schema = schemaContext.newSchema(schemaLocation, schemaNode, parentSchema);
        this.additionalItems = schemaNode.isBoolean() ? schemaNode.booleanValue() : true;
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        if (node.isArray()) {
            boolean evaluated = false;
            for (int i = this.prefixCount; i < node.size(); ++i) {
                NodePath path = instanceLocation.append(i);
                if (this.additionalItems) {
                    this.schema.validate(executionContext, node.get(i), rootNode, path);
                } else {
                    int x = i;
                    executionContext.addError(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(node)).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).locale(executionContext.getExecutionConfig().getLocale())).index(x)).arguments(x)).build());
                }
                evaluated = true;
            }
            if (evaluated && (this.hasUnevaluatedItemsInEvaluationPath(executionContext) || this.collectAnnotations(executionContext))) {
                executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(true).build());
            }
        }
    }

    @Override
    public void walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean shouldValidateSchema) {
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            JsonNode defaultNode = null;
            if (executionContext.getWalkConfig().getApplyDefaultsStrategy().shouldApplyArrayDefaults() && this.schema != null) {
                defaultNode = ItemsValidator.getDefaultNode(this.schema, executionContext);
            }
            boolean evaluated = false;
            for (int i = this.prefixCount; i < node.size(); ++i) {
                JsonNode n = node.get(i);
                if (n.isNull() && defaultNode != null) {
                    arrayNode.set(i, defaultNode);
                    n = defaultNode;
                }
                this.walkSchema(executionContext, this.schema, n, rootNode, instanceLocation.append(i), shouldValidateSchema);
                if (n == null) continue;
                evaluated = true;
            }
            if (evaluated && (this.hasUnevaluatedItemsInEvaluationPath(executionContext) || this.collectAnnotations(executionContext))) {
                executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(true).build());
            }
        } else {
            this.walkSchema(executionContext, this.schema, null, rootNode, instanceLocation.append(this.prefixCount), shouldValidateSchema);
        }
    }

    private static JsonNode getDefaultNode(Schema schema, ExecutionContext executionContext) {
        SchemaRef schemaRef;
        JsonNode result = schema.getSchemaNode().get("default");
        if (result == null && (schemaRef = SchemaRefs.from(schema, executionContext)) != null) {
            result = ItemsValidator.getDefaultNode(schemaRef.getSchema(), executionContext);
        }
        return result;
    }

    private void walkSchema(ExecutionContext executionContext, Schema walkSchema, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean shouldValidateSchema) {
        boolean executeWalk = executionContext.getWalkConfig().getItemWalkHandler().preWalk(executionContext, KeywordType.ITEMS.getValue(), node, rootNode, instanceLocation, walkSchema, this);
        int currentErrors = executionContext.getErrors().size();
        if (executeWalk) {
            walkSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
        }
        executionContext.getWalkConfig().getItemWalkHandler().postWalk(executionContext, KeywordType.ITEMS.getValue(), node, rootNode, instanceLocation, walkSchema, this, executionContext.getErrors().subList(currentErrors, executionContext.getErrors().size()));
    }

    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void preloadSchema() {
        this.schema.initializeValidators();
    }
}

