/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.output;

import com.networknt.schema.Error;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.annotation.Annotation;
import com.networknt.schema.output.OutputUnitKey;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class OutputUnitData {
    private final Map<OutputUnitKey, Boolean> valid = new LinkedHashMap<OutputUnitKey, Boolean>();
    private final Map<OutputUnitKey, Map<String, Object>> errors = new LinkedHashMap<OutputUnitKey, Map<String, Object>>();
    private final Map<OutputUnitKey, Map<String, Object>> annotations = new LinkedHashMap<OutputUnitKey, Map<String, Object>>();
    private final Map<OutputUnitKey, Map<String, Object>> droppedAnnotations = new LinkedHashMap<OutputUnitKey, Map<String, Object>>();

    public Map<OutputUnitKey, Boolean> getValid() {
        return this.valid;
    }

    public Map<OutputUnitKey, Map<String, Object>> getErrors() {
        return this.errors;
    }

    public Map<OutputUnitKey, Map<String, Object>> getAnnotations() {
        return this.annotations;
    }

    public Map<OutputUnitKey, Map<String, Object>> getDroppedAnnotations() {
        return this.droppedAnnotations;
    }

    public static String formatError(Error error) {
        return error.getMessage();
    }

    public static OutputUnitData from(List<Error> validationErrors, ExecutionContext executionContext, Function<Error, Object> errorMapper) {
        OutputUnitData data = new OutputUnitData();
        Map<OutputUnitKey, Boolean> valid = data.valid;
        Map<OutputUnitKey, Map<String, Object>> errors = data.errors;
        Map<OutputUnitKey, Map<String, Object>> annotations = data.annotations;
        Map<OutputUnitKey, Map<String, Object>> droppedAnnotations = data.droppedAnnotations;
        for (Error error : validationErrors) {
            SchemaLocation assertionSchemaLocation = new SchemaLocation(error.getSchemaLocation().getAbsoluteIri(), error.getSchemaLocation().getFragment().getParent());
            OutputUnitKey key = new OutputUnitKey(error.getEvaluationPath().getParent(), assertionSchemaLocation, error.getInstanceLocation());
            valid.put(key, false);
            Map errorMap = errors.computeIfAbsent(key, k -> new LinkedHashMap());
            Object value = errorMap.get(error.getKeyword());
            if (value == null) {
                errorMap.put(error.getKeyword(), errorMapper.apply(error));
                continue;
            }
            if (value instanceof List) {
                ((List)value).add(errorMapper.apply(error));
                continue;
            }
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(value.toString());
            values.add(errorMapper.apply(error));
            errorMap.put(error.getKeyword(), values);
        }
        for (List list : executionContext.getAnnotations().asMap().values()) {
            for (Annotation annotation : list) {
                if (!executionContext.getExecutionConfig().getAnnotationCollectionFilter().test(annotation.getKeyword())) continue;
                SchemaLocation annotationSchemaLocation = new SchemaLocation(annotation.getSchemaLocation().getAbsoluteIri(), annotation.getSchemaLocation().getFragment().getParent());
                OutputUnitKey key = new OutputUnitKey(annotation.getEvaluationPath().getParent(), annotationSchemaLocation, annotation.getInstanceLocation());
                boolean validResult = annotation.isValid();
                valid.put(key, validResult);
                if (validResult) {
                    Map annotationMap = annotations.computeIfAbsent(key, k -> new LinkedHashMap());
                    annotationMap.put(annotation.getKeyword(), annotation.getValue());
                    continue;
                }
                Map droppedAnnotationMap = droppedAnnotations.computeIfAbsent(key, k -> new LinkedHashMap());
                droppedAnnotationMap.put(annotation.getKeyword(), annotation.getValue());
            }
        }
        return data;
    }
}

