/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.json.schema;

import io.modelcontextprotocol.json.schema.JsonSchemaValidator;
import io.modelcontextprotocol.json.schema.JsonSchemaValidatorSupplier;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;

final class JsonSchemaInternal {
    private static JsonSchemaValidator defaultValidator = null;

    JsonSchemaInternal() {
    }

    static JsonSchemaValidator getDefaultValidator() {
        if (defaultValidator == null) {
            defaultValidator = JsonSchemaInternal.createDefaultValidator();
        }
        return defaultValidator;
    }

    static JsonSchemaValidator createDefaultValidator() {
        AtomicReference ex = new AtomicReference();
        return (JsonSchemaValidator)ServiceLoader.load(JsonSchemaValidatorSupplier.class).stream().flatMap(p -> {
            try {
                JsonSchemaValidatorSupplier supplier = (JsonSchemaValidatorSupplier)p.get();
                return Stream.ofNullable(supplier);
            }
            catch (Exception e) {
                JsonSchemaInternal.addException(ex, e);
                return Stream.empty();
            }
        }).flatMap(jsonMapperSupplier -> {
            try {
                return Stream.of((JsonSchemaValidator)jsonMapperSupplier.get());
            }
            catch (Exception e) {
                JsonSchemaInternal.addException(ex, e);
                return Stream.empty();
            }
        }).findFirst().orElseThrow(() -> {
            if (ex.get() != null) {
                return (IllegalStateException)ex.get();
            }
            return new IllegalStateException("No default JsonSchemaValidatorSupplier implementation found");
        });
    }

    private static void addException(AtomicReference<IllegalStateException> ref, Exception toAdd) {
        ref.updateAndGet(existing -> {
            if (existing == null) {
                return new IllegalStateException("Failed to initialize default JsonSchemaValidatorSupplier", toAdd);
            }
            existing.addSuppressed(toAdd);
            return existing;
        });
    }
}

