/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3.fontface;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLayerList;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssSrc
extends org.w3c.css.properties.css.fontface.CssSrc {
    public static final CssIdent[] allowed_font_format;
    public static final CssIdent[] allowed_font_technologies;
    public static final CssIdent[] allowed_font_feature_technologies;
    public static final CssIdent[] allowed_color_font_technologies;
    public static final CssIdent supports;

    public static CssIdent getMatchingFontFormat(CssIdent ident) {
        for (CssIdent id : allowed_font_format) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static CssIdent getMatchingColorFontTechnology(CssIdent ident) {
        for (CssIdent id : allowed_color_font_technologies) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static CssIdent getMatchingFontTechnology(CssIdent ident) {
        for (CssIdent id : allowed_font_technologies) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static CssIdent getMatchingFontFeatureTechnology(CssIdent ident) {
        for (CssIdent id : allowed_font_feature_technologies) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssSrc() {
        this.value = initial;
    }

    public CssSrc(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        this.setByUser();
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        while (!expression.end()) {
            CssExpression nex = new CssExpression();
            while (!expression.end() && expression.getOperator() == ' ') {
                nex.addValue(expression.getValue());
                expression.next();
            }
            if (!expression.end()) {
                nex.addValue(expression.getValue());
            }
            values.add(this.parseSrcLayer(ac, nex, check));
            if (expression.end()) continue;
            char op = expression.getOperator();
            if (op != ',') {
                throw new InvalidParamException("operator", Character.valueOf(op), this.getPropertyName(), ac);
            }
            expression.next();
        }
        this.value = values.size() == 1 ? (CssValue)values.get(0) : new CssLayerList(values);
    }

    protected CssValue parseSrcLayer(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        boolean gotUrl = false;
        boolean gotFormat = false;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            block0 : switch (val.getType()) {
                case 2: {
                    if (gotUrl) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                    gotUrl = true;
                    values.add(val);
                    break;
                }
                case 11: {
                    String funcName;
                    CssFunction f = val.getFunction();
                    switch (funcName = f.getName().toLowerCase()) {
                        case "local": {
                            if (expression.getCount() > 1) {
                                throw new InvalidParamException("unrecognize", ac);
                            }
                            this.parseLocalFunction(ac, f);
                            values.add(f);
                            break block0;
                        }
                        case "format": {
                            if (gotFormat) {
                                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                            }
                            this.parseFormatFunction(ac, f);
                            gotFormat = true;
                            values.add(val);
                            break block0;
                        }
                    }
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
            }
            expression.next();
        }
        return values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
    }

    protected void parseFormatFunction(ApplContext ac, CssFunction f) throws InvalidParamException {
        CssExpression exp = f.getParameters();
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        switch (val.getType()) {
            case 1: {
                break;
            }
            case 0: {
                if (CssSrc.getMatchingFontFormat(val.getIdent()) != null) break;
            }
            default: {
                throw new InvalidParamException("value", val.toString(), f.getName(), ac);
            }
        }
        exp.next();
        if (!exp.end()) {
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.valueOf(op), f.getName(), ac);
            }
            val = exp.getValue();
            op = exp.getOperator();
            if (val.getType() != 0 || !supports.equals(val.getIdent())) {
                throw new InvalidParamException("value", val.toString(), f.getName(), ac);
            }
            exp.next();
            if (op != ' ' || exp.end()) {
                throw new InvalidParamException("operator", Character.valueOf(op), f.getName(), ac);
            }
            while (!exp.end()) {
                val = exp.getValue();
                op = exp.getOperator();
                block4 : switch (val.getType()) {
                    case 11: {
                        String subfname;
                        CssFunction subf = val.getFunction();
                        switch (subfname = subf.getName().toLowerCase()) {
                            case "features": {
                                this.parseFontFeatureTechnology(ac, subf);
                                break block4;
                            }
                            case "color": {
                                this.parseColorFontTechnology(ac, subf);
                                break block4;
                            }
                        }
                        throw new InvalidParamException("value", val.toString(), f.getName(), ac);
                    }
                    case 0: {
                        CssIdent ident = val.getIdent();
                        if (CssSrc.getMatchingFontTechnology(ident) != null) break;
                    }
                    default: {
                        throw new InvalidParamException("value", val.toString(), f.getName(), ac);
                    }
                }
                exp.next();
                if (op == ',' || exp.end()) continue;
                throw new InvalidParamException("operator", Character.valueOf(op), f.getName(), ac);
            }
        }
    }

    protected void parseFontFeatureTechnology(ApplContext ac, CssFunction f) throws InvalidParamException {
        CssExpression exp = f.getParameters();
        if (exp.getCount() > 1) {
            throw new InvalidParamException("value", exp.toStringFromStart(), f.getName(), ac);
        }
        CssValue val = exp.getValue();
        if (val.getType() != 0) {
            throw new InvalidParamException("value", val.toString(), f.getName(), ac);
        }
        if (CssSrc.getMatchingFontFeatureTechnology(val.getIdent()) == null) {
            throw new InvalidParamException("value", val.toString(), f.getName(), ac);
        }
        exp.next();
    }

    protected void parseColorFontTechnology(ApplContext ac, CssFunction f) throws InvalidParamException {
        CssExpression exp = f.getParameters();
        if (exp.getCount() > 1) {
            throw new InvalidParamException("value", exp.toStringFromStart(), f.getName(), ac);
        }
        CssValue val = exp.getValue();
        if (val.getType() != 0) {
            throw new InvalidParamException("value", val.toString(), f.getName(), ac);
        }
        if (CssSrc.getMatchingColorFontTechnology(val.getIdent()) == null) {
            throw new InvalidParamException("value", val.toString(), f.getName(), ac);
        }
        exp.next();
    }

    protected void parseLocalFunction(ApplContext ac, CssFunction f) throws InvalidParamException {
        CssExpression exp = f.getParameters();
        while (!exp.end()) {
            CssValue val = exp.getValue();
            char op = exp.getOperator();
            switch (val.getType()) {
                case 1: {
                    if (exp.getCount() <= 1) break;
                    throw new InvalidParamException("unrecognize", ac);
                }
                case 0: {
                    break;
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), f.getName(), ac);
                }
            }
            if (op != ' ' && exp.getRemainingCount() > 1) {
                throw new InvalidParamException("operator", Character.valueOf(op), f.getName(), ac);
            }
            exp.next();
        }
    }

    public CssSrc(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        supports = CssIdent.getIdent("supports");
        int i = 0;
        String[] _allowed_font_format_values = new String[]{"woff", "truetype", "opentype", "woff2", "embedded-opentype", "collection", "svg"};
        allowed_font_format = new CssIdent[_allowed_font_format_values.length];
        for (String s : _allowed_font_format_values) {
            CssSrc.allowed_font_format[i++] = CssIdent.getIdent(s);
        }
        i = 0;
        String[] _allowed_font_technologies = new String[]{"variations", "palettes"};
        allowed_font_technologies = new CssIdent[_allowed_font_technologies.length];
        for (String s : _allowed_font_technologies) {
            CssSrc.allowed_font_technologies[i++] = CssIdent.getIdent(s);
        }
        i = 0;
        String[] _allowed_font_feature_technologies = new String[]{"opentype", "aat", "graphite"};
        allowed_font_feature_technologies = new CssIdent[_allowed_font_feature_technologies.length];
        for (String s : _allowed_font_feature_technologies) {
            CssSrc.allowed_font_feature_technologies[i++] = CssIdent.getIdent(s);
        }
        i = 0;
        String[] _allowed_color_font_technologies = new String[]{"COLRv0", "COLRv1", "SVG", "sbix", "CBDT"};
        allowed_color_font_technologies = new CssIdent[_allowed_color_font_technologies.length];
        for (String s : _allowed_color_font_technologies) {
            CssSrc.allowed_color_font_technologies[i++] = CssIdent.getIdent(s);
        }
    }
}

