/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.ArrayType;
import sun.jvm.hotspot.debugger.cdbg.FieldIdentifier;
import sun.jvm.hotspot.debugger.cdbg.ObjectVisitor;
import sun.jvm.hotspot.debugger.cdbg.Type;
import sun.jvm.hotspot.debugger.cdbg.TypeVisitor;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCDebugInfoDataBase;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicIndexableFieldIdentifier;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicType;
import sun.jvm.hotspot.debugger.cdbg.basic.ResolveListener;

public class BasicArrayType
extends BasicType
implements ArrayType {
    private Type elementType;
    private int length;

    public BasicArrayType(String name, Type elementType, int sizeInBytes) {
        this(name, elementType, sizeInBytes, 0, 0);
    }

    private BasicArrayType(String name, Type elementType, int sizeInBytes, int length, int cvAttributes) {
        super(name, sizeInBytes, cvAttributes);
        this.elementType = elementType;
        this.length = length;
    }

    @Override
    public ArrayType asArray() {
        return this;
    }

    @Override
    public Type getElementType() {
        return this.elementType;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    Type resolveTypes(BasicCDebugInfoDataBase db, ResolveListener listener) {
        super.resolveTypes(db, listener);
        this.elementType = db.resolveType(this, this.elementType, listener, "resolving array element type");
        if (!((BasicType)this.elementType).isLazy()) {
            this.length = this.getSize() / this.elementType.getSize();
        }
        return this;
    }

    @Override
    public void iterateObject(Address a, ObjectVisitor v, FieldIdentifier f) {
        if (f == null) {
            v.enterType(this, a);
            for (int i = 0; i < this.getLength(); ++i) {
                ((BasicType)this.getElementType()).iterateObject(a.addOffsetTo(i * this.getElementType().getSize()), v, new BasicIndexableFieldIdentifier(this.getElementType(), i));
            }
            v.exitType();
        } else {
            v.doArray(f, a);
        }
    }

    @Override
    protected Type createCVVariant(int cvAttributes) {
        return new BasicArrayType(this.getName(), this.getElementType(), this.getSize(), this.getLength(), cvAttributes);
    }

    @Override
    public void visit(TypeVisitor v) {
        v.doArrayType(this);
    }
}

