"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Crosshair = void 0;
var react_1 = __importDefault(require("react"));
var react_redux_1 = require("react-redux");
var specs_1 = require("../../../../specs");
var constants_1 = require("../../../../specs/constants");
var get_chart_rotation_1 = require("../../../../state/selectors/get_chart_rotation");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var get_internal_is_intialized_1 = require("../../../../state/selectors/get_internal_is_intialized");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var light_theme_1 = require("../../../../utils/themes/light_theme");
var get_cursor_band_1 = require("../../state/selectors/get_cursor_band");
var get_cursor_line_1 = require("../../state/selectors/get_cursor_line");
function canRenderBand(type, visible, fromExternalEvent) {
    return visible && (type === constants_1.TooltipType.Crosshairs || type === constants_1.TooltipType.VerticalCursor || fromExternalEvent);
}
function canRenderHelpLine(type, visible) {
    return visible && type === constants_1.TooltipType.Crosshairs;
}
var CrosshairComponent = (function (_super) {
    __extends(CrosshairComponent, _super);
    function CrosshairComponent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CrosshairComponent.prototype.renderCursor = function () {
        var _a = this.props, zIndex = _a.zIndex, _b = _a.theme.crosshair, band = _b.band, line = _b.line, cursorPosition = _a.cursorPosition, tooltipType = _a.tooltipType, fromExternalEvent = _a.fromExternalEvent;
        if (!cursorPosition || !canRenderBand(tooltipType, band.visible, fromExternalEvent)) {
            return null;
        }
        var x = cursorPosition.x, y = cursorPosition.y, width = cursorPosition.width, height = cursorPosition.height;
        var isLine = width === 0 || height === 0;
        var strokeWidth = line.strokeWidth, stroke = line.stroke, dash = line.dash;
        var fill = band.fill;
        var strokeDasharray = (dash !== null && dash !== void 0 ? dash : []).join(' ');
        return (react_1.default.createElement("svg", { className: "echCrosshair__cursor", width: "100%", height: "100%", style: { zIndex: cursorPosition && isLine ? zIndex : undefined } },
            isLine && react_1.default.createElement("line", __assign({}, { x1: x, x2: x + width, y1: y, y2: y + height, strokeWidth: strokeWidth, stroke: stroke, strokeDasharray: strokeDasharray })),
            !isLine && react_1.default.createElement("rect", __assign({}, { x: x, y: y, width: width, height: height, fill: fill }))));
    };
    CrosshairComponent.prototype.renderCrossLine = function () {
        var _a = this.props, zIndex = _a.zIndex, crossLine = _a.theme.crosshair.crossLine, cursorCrossLinePosition = _a.cursorCrossLinePosition, tooltipType = _a.tooltipType;
        if (!cursorCrossLinePosition || !canRenderHelpLine(tooltipType, crossLine.visible)) {
            return null;
        }
        var strokeWidth = crossLine.strokeWidth, stroke = crossLine.stroke, dash = crossLine.dash;
        var style = {
            strokeWidth: strokeWidth,
            stroke: stroke,
            strokeDasharray: (dash !== null && dash !== void 0 ? dash : []).join(' '),
        };
        return (react_1.default.createElement("svg", { className: "echCrosshair__crossLine", width: "100%", height: "100%", style: { zIndex: zIndex } },
            react_1.default.createElement("line", __assign({}, cursorCrossLinePosition, style))));
    };
    CrosshairComponent.prototype.render = function () {
        return (react_1.default.createElement(react_1.default.Fragment, null,
            this.renderCursor(),
            this.renderCrossLine()));
    };
    CrosshairComponent.displayName = 'Crosshair';
    return CrosshairComponent;
}(react_1.default.Component));
var mapStateToProps = function (state) {
    if (get_internal_is_intialized_1.getInternalIsInitializedSelector(state) !== get_internal_is_intialized_1.InitStatus.Initialized) {
        return {
            theme: light_theme_1.LIGHT_THEME,
            chartRotation: 0,
            tooltipType: constants_1.TooltipType.None,
            zIndex: 0,
        };
    }
    var settings = get_settings_specs_1.getSettingsSpecSelector(state);
    var cursorBandPosition = get_cursor_band_1.getCursorBandPositionSelector(state);
    var fromExternalEvent = cursorBandPosition === null || cursorBandPosition === void 0 ? void 0 : cursorBandPosition.fromExternalEvent;
    var tooltipType = specs_1.getTooltipType(settings, fromExternalEvent);
    return {
        theme: get_chart_theme_1.getChartThemeSelector(state),
        chartRotation: get_chart_rotation_1.getChartRotationSelector(state),
        cursorPosition: cursorBandPosition,
        cursorCrossLinePosition: get_cursor_line_1.getCursorLinePositionSelector(state),
        tooltipType: tooltipType,
        fromExternalEvent: fromExternalEvent,
        zIndex: state.zIndex,
    };
};
exports.Crosshair = react_redux_1.connect(mapStateToProps)(CrosshairComponent);
//# sourceMappingURL=crosshair.js.map