/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleExtendedText;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleTextSequence;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DropMode;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.Keymap;
import javax.swing.text.NavigationFilter;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import sun.awt.AppContext;
import sun.swing.PrintingStatus;
import sun.swing.SwingUtilities2;
import sun.swing.text.TextComponentPrintable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JTextComponent
extends JComponent
implements Scrollable,
Accessible {
    public static final String FOCUS_ACCELERATOR_KEY = "focusAcceleratorKey";
    private Document model;
    private transient Caret caret;
    private NavigationFilter navigationFilter;
    private transient Highlighter highlighter;
    private transient Keymap keymap;
    private transient MutableCaretEvent caretEvent;
    private Color caretColor;
    private Color selectionColor;
    private Color selectedTextColor;
    private Color disabledTextColor;
    private boolean editable;
    private Insets margin;
    private char focusAccelerator;
    private boolean dragEnabled;
    private DropMode dropMode = DropMode.USE_SELECTION;
    private transient DropLocation dropLocation;
    private static DefaultTransferHandler defaultTransferHandler;
    private static Map overrideMap;
    private static final Object KEYMAP_TABLE;
    private JTextComponent editor;
    private transient InputMethodRequests inputMethodRequestsHandler;
    private SimpleAttributeSet composedTextAttribute;
    private String composedTextContent;
    private Position composedTextStart;
    private Position composedTextEnd;
    private Position latestCommittedTextStart;
    private Position latestCommittedTextEnd;
    private ComposedTextCaret composedTextCaret;
    private transient Caret originalCaret;
    private boolean checkedInputOverride;
    private boolean needToSendKeyTypedEvent;
    private static final Object FOCUSED_COMPONENT;
    public static final String DEFAULT_KEYMAP = "default";

    public JTextComponent() {
        this.enableEvents(2056L);
        this.caretEvent = new MutableCaretEvent(this);
        this.addMouseListener(this.caretEvent);
        this.addFocusListener(this.caretEvent);
        this.setEditable(true);
        this.setDragEnabled(false);
        this.setLayout(null);
        this.updateUI();
    }

    public TextUI getUI() {
        return (TextUI)this.ui;
    }

    public void setUI(TextUI textUI) {
        super.setUI(textUI);
    }

    @Override
    public void updateUI() {
        this.setUI((TextUI)UIManager.getUI(this));
        this.invalidate();
    }

    public void addCaretListener(CaretListener caretListener) {
        this.listenerList.add(CaretListener.class, caretListener);
    }

    public void removeCaretListener(CaretListener caretListener) {
        this.listenerList.remove(CaretListener.class, caretListener);
    }

    public CaretListener[] getCaretListeners() {
        return (CaretListener[])this.listenerList.getListeners(CaretListener.class);
    }

    protected void fireCaretUpdate(CaretEvent caretEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CaretListener.class) continue;
            ((CaretListener)objectArray[i + 1]).caretUpdate(caretEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDocument(Document document) {
        Document document2 = this.model;
        try {
            Boolean bl;
            if (document2 instanceof AbstractDocument) {
                ((AbstractDocument)document2).readLock();
            }
            if (this.accessibleContext != null) {
                this.model.removeDocumentListener((AccessibleJTextComponent)this.accessibleContext);
            }
            if (this.inputMethodRequestsHandler != null) {
                this.model.removeDocumentListener((DocumentListener)((Object)this.inputMethodRequestsHandler));
            }
            this.model = document;
            Boolean bl2 = bl = this.getComponentOrientation().isLeftToRight() ? TextAttribute.RUN_DIRECTION_LTR : TextAttribute.RUN_DIRECTION_RTL;
            if (bl != document.getProperty(TextAttribute.RUN_DIRECTION)) {
                document.putProperty(TextAttribute.RUN_DIRECTION, bl);
            }
            this.firePropertyChange("document", document2, document);
        }
        finally {
            if (document2 instanceof AbstractDocument) {
                ((AbstractDocument)document2).readUnlock();
            }
        }
        this.revalidate();
        this.repaint();
        if (this.accessibleContext != null) {
            this.model.addDocumentListener((AccessibleJTextComponent)this.accessibleContext);
        }
        if (this.inputMethodRequestsHandler != null) {
            this.model.addDocumentListener((DocumentListener)((Object)this.inputMethodRequestsHandler));
        }
    }

    public Document getDocument() {
        return this.model;
    }

    @Override
    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        Document document = this.getDocument();
        if (document != null) {
            Boolean bl = componentOrientation.isLeftToRight() ? TextAttribute.RUN_DIRECTION_LTR : TextAttribute.RUN_DIRECTION_RTL;
            document.putProperty(TextAttribute.RUN_DIRECTION, bl);
        }
        super.setComponentOrientation(componentOrientation);
    }

    public Action[] getActions() {
        return this.getUI().getEditorKit(this).getActions();
    }

    public void setMargin(Insets insets) {
        Insets insets2 = this.margin;
        this.margin = insets;
        this.firePropertyChange("margin", insets2, insets);
        this.invalidate();
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setNavigationFilter(NavigationFilter navigationFilter) {
        this.navigationFilter = navigationFilter;
    }

    public NavigationFilter getNavigationFilter() {
        return this.navigationFilter;
    }

    public Caret getCaret() {
        return this.caret;
    }

    public void setCaret(Caret caret) {
        if (this.caret != null) {
            this.caret.removeChangeListener(this.caretEvent);
            this.caret.deinstall(this);
        }
        Caret caret2 = this.caret;
        this.caret = caret;
        if (this.caret != null) {
            this.caret.install(this);
            this.caret.addChangeListener(this.caretEvent);
        }
        this.firePropertyChange("caret", caret2, this.caret);
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(Highlighter highlighter) {
        if (this.highlighter != null) {
            this.highlighter.deinstall(this);
        }
        Highlighter highlighter2 = this.highlighter;
        this.highlighter = highlighter;
        if (this.highlighter != null) {
            this.highlighter.install(this);
        }
        this.firePropertyChange("highlighter", highlighter2, highlighter);
    }

    public void setKeymap(Keymap keymap) {
        Keymap keymap2 = this.keymap;
        this.keymap = keymap;
        this.firePropertyChange("keymap", keymap2, this.keymap);
        this.updateInputMap(keymap2, keymap);
    }

    public void setDragEnabled(boolean bl) {
        if (bl && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = bl;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public final void setDropMode(DropMode dropMode) {
        if (dropMode != null) {
            switch (dropMode) {
                case USE_SELECTION: 
                case INSERT: {
                    this.dropMode = dropMode;
                    return;
                }
            }
        }
        throw new IllegalArgumentException((Object)((Object)dropMode) + ": Unsupported drop mode for text");
    }

    public final DropMode getDropMode() {
        return this.dropMode;
    }

    DropLocation dropLocationForPoint(Point point) {
        Position.Bias[] biasArray = new Position.Bias[1];
        int n = this.getUI().viewToModel(this, point, biasArray);
        if (biasArray[0] == null) {
            biasArray[0] = Position.Bias.Forward;
        }
        return new DropLocation(point, n, biasArray[0]);
    }

    Object setDropLocation(TransferHandler.DropLocation dropLocation, Object objectArray, boolean bl) {
        Object[] objectArray2;
        Object[] objectArray3 = null;
        DropLocation dropLocation2 = (DropLocation)dropLocation;
        if (this.dropMode == DropMode.USE_SELECTION) {
            if (dropLocation2 == null) {
                if (objectArray != null) {
                    objectArray2 = objectArray;
                    if (!bl) {
                        if (this.caret instanceof DefaultCaret) {
                            ((DefaultCaret)this.caret).setDot((Integer)objectArray2[0], (Position.Bias)objectArray2[3]);
                            ((DefaultCaret)this.caret).moveDot((Integer)objectArray2[1], (Position.Bias)objectArray2[4]);
                        } else {
                            this.caret.setDot((Integer)objectArray2[0]);
                            this.caret.moveDot((Integer)objectArray2[1]);
                        }
                    }
                    this.caret.setVisible((Boolean)objectArray2[2]);
                }
            } else {
                if (this.dropLocation == null) {
                    boolean bl2;
                    if (this.caret instanceof DefaultCaret) {
                        DefaultCaret defaultCaret = (DefaultCaret)this.caret;
                        bl2 = defaultCaret.isActive();
                        objectArray3 = new Object[]{defaultCaret.getMark(), defaultCaret.getDot(), bl2, defaultCaret.getMarkBias(), defaultCaret.getDotBias()};
                    } else {
                        bl2 = this.caret.isVisible();
                        objectArray3 = new Object[]{this.caret.getMark(), this.caret.getDot(), bl2};
                    }
                    this.caret.setVisible(true);
                } else {
                    objectArray3 = objectArray;
                }
                if (this.caret instanceof DefaultCaret) {
                    ((DefaultCaret)this.caret).setDot(dropLocation2.getIndex(), dropLocation2.getBias());
                } else {
                    this.caret.setDot(dropLocation2.getIndex());
                }
            }
        } else if (dropLocation2 == null) {
            if (objectArray != null) {
                this.caret.setVisible((Boolean)objectArray);
            }
        } else if (this.dropLocation == null) {
            boolean bl3 = this.caret instanceof DefaultCaret ? ((DefaultCaret)this.caret).isActive() : this.caret.isVisible();
            objectArray3 = bl3;
            this.caret.setVisible(false);
        } else {
            objectArray3 = objectArray;
        }
        objectArray2 = this.dropLocation;
        this.dropLocation = dropLocation2;
        this.firePropertyChange("dropLocation", objectArray2, this.dropLocation);
        return objectArray3;
    }

    public final DropLocation getDropLocation() {
        return this.dropLocation;
    }

    void updateInputMap(Keymap keymap, Keymap keymap2) {
        Serializable serializable;
        InputMap inputMap;
        InputMap inputMap2 = inputMap = this.getInputMap(0);
        while (inputMap != null && !(inputMap instanceof KeymapWrapper)) {
            inputMap2 = inputMap;
            inputMap = inputMap.getParent();
        }
        if (inputMap != null) {
            if (keymap2 == null) {
                if (inputMap2 != inputMap) {
                    inputMap2.setParent(inputMap.getParent());
                } else {
                    inputMap2.setParent(null);
                }
            } else {
                serializable = new KeymapWrapper(keymap2);
                inputMap2.setParent((InputMap)serializable);
                if (inputMap2 != inputMap) {
                    ((InputMap)serializable).setParent(inputMap.getParent());
                }
            }
        } else if (keymap2 != null && (inputMap = this.getInputMap(0)) != null) {
            serializable = new KeymapWrapper(keymap2);
            ((InputMap)serializable).setParent(inputMap.getParent());
            inputMap.setParent((InputMap)serializable);
        }
        ActionMap actionMap = serializable;
        for (serializable = this.getActionMap(); serializable != null && !(serializable instanceof KeymapActionMap); serializable = ((ActionMap)serializable).getParent()) {
            actionMap = serializable;
        }
        if (serializable != null) {
            if (keymap2 == null) {
                if (actionMap != serializable) {
                    actionMap.setParent(((ActionMap)serializable).getParent());
                } else {
                    actionMap.setParent(null);
                }
            } else {
                KeymapActionMap keymapActionMap = new KeymapActionMap(keymap2);
                actionMap.setParent(keymapActionMap);
                if (actionMap != serializable) {
                    keymapActionMap.setParent(((ActionMap)serializable).getParent());
                }
            }
        } else if (keymap2 != null && (serializable = this.getActionMap()) != null) {
            KeymapActionMap keymapActionMap = new KeymapActionMap(keymap2);
            keymapActionMap.setParent(((ActionMap)serializable).getParent());
            ((ActionMap)serializable).setParent(keymapActionMap);
        }
    }

    public Keymap getKeymap() {
        return this.keymap;
    }

    public static Keymap addKeymap(String string, Keymap keymap) {
        DefaultKeymap defaultKeymap = new DefaultKeymap(string, keymap);
        if (string != null) {
            JTextComponent.getKeymapTable().put(string, defaultKeymap);
        }
        return defaultKeymap;
    }

    public static Keymap removeKeymap(String string) {
        return JTextComponent.getKeymapTable().remove(string);
    }

    public static Keymap getKeymap(String string) {
        return JTextComponent.getKeymapTable().get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, Keymap> getKeymapTable() {
        Object object = KEYMAP_TABLE;
        synchronized (object) {
            AppContext appContext = AppContext.getAppContext();
            HashMap hashMap = (HashMap)appContext.get(KEYMAP_TABLE);
            if (hashMap == null) {
                hashMap = new HashMap(17);
                appContext.put(KEYMAP_TABLE, hashMap);
                Keymap keymap = JTextComponent.addKeymap(DEFAULT_KEYMAP, null);
                keymap.setDefaultAction(new DefaultEditorKit.DefaultKeyTypedAction());
            }
            return hashMap;
        }
    }

    public static void loadKeymap(Keymap keymap, KeyBinding[] keyBindingArray, Action[] actionArray) {
        Action action;
        int n;
        Hashtable<String, Action> hashtable = new Hashtable<String, Action>();
        for (n = 0; n < actionArray.length; ++n) {
            action = actionArray[n];
            String string = (String)action.getValue("Name");
            hashtable.put(string != null ? string : "", action);
        }
        for (n = 0; n < keyBindingArray.length; ++n) {
            action = (Action)hashtable.get(keyBindingArray[n].actionName);
            if (action == null) continue;
            keymap.addActionForKeyStroke(keyBindingArray[n].key, action);
        }
    }

    private static Boolean isProcessInputMethodEventOverridden(Class clazz) {
        if (clazz == JTextComponent.class) {
            return Boolean.FALSE;
        }
        Boolean bl = (Boolean)overrideMap.get(clazz.getName());
        if (bl != null) {
            return bl;
        }
        Boolean bl2 = JTextComponent.isProcessInputMethodEventOverridden(clazz.getSuperclass());
        if (bl2.booleanValue()) {
            overrideMap.put(clazz.getName(), bl2);
            return bl2;
        }
        try {
            Class[] classArray = new Class[]{InputMethodEvent.class};
            Method method = clazz.getDeclaredMethod("processInputMethodEvent", classArray);
            bl = Boolean.TRUE;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl = Boolean.FALSE;
        }
        overrideMap.put(clazz.getName(), bl);
        return bl;
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public void setCaretColor(Color color) {
        Color color2 = this.caretColor;
        this.caretColor = color;
        this.firePropertyChange("caretColor", color2, this.caretColor);
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        Color color2 = this.selectionColor;
        this.selectionColor = color;
        this.firePropertyChange("selectionColor", color2, this.selectionColor);
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public void setSelectedTextColor(Color color) {
        Color color2 = this.selectedTextColor;
        this.selectedTextColor = color;
        this.firePropertyChange("selectedTextColor", color2, this.selectedTextColor);
    }

    public Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void setDisabledTextColor(Color color) {
        Color color2 = this.disabledTextColor;
        this.disabledTextColor = color;
        this.firePropertyChange("disabledTextColor", color2, this.disabledTextColor);
    }

    public void replaceSelection(String string) {
        Document document = this.getDocument();
        if (document != null) {
            try {
                boolean bl = this.saveComposedText(this.caret.getDot());
                int n = Math.min(this.caret.getDot(), this.caret.getMark());
                int n2 = Math.max(this.caret.getDot(), this.caret.getMark());
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).replace(n, n2 - n, string, null);
                } else {
                    if (n != n2) {
                        document.remove(n, n2 - n);
                    }
                    if (string != null && string.length() > 0) {
                        document.insertString(n, string, null);
                    }
                }
                if (bl) {
                    this.restoreComposedText();
                }
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
            }
        }
    }

    public String getText(int n, int n2) throws BadLocationException {
        return this.getDocument().getText(n, n2);
    }

    public Rectangle modelToView(int n) throws BadLocationException {
        return this.getUI().modelToView(this, n);
    }

    public int viewToModel(Point point) {
        return this.getUI().viewToModel(this, point);
    }

    public void cut() {
        if (this.isEditable() && this.isEnabled()) {
            this.invokeAction("cut", TransferHandler.getCutAction());
        }
    }

    public void copy() {
        this.invokeAction("copy", TransferHandler.getCopyAction());
    }

    public void paste() {
        if (this.isEditable() && this.isEnabled()) {
            this.invokeAction("paste", TransferHandler.getPasteAction());
        }
    }

    private void invokeAction(String string, Action action) {
        ActionMap actionMap = this.getActionMap();
        Action action2 = null;
        if (actionMap != null) {
            action2 = actionMap.get(string);
        }
        if (action2 == null) {
            this.installDefaultTransferHandlerIfNecessary();
            action2 = action;
        }
        action2.actionPerformed(new ActionEvent(this, 1001, (String)action2.getValue("Name"), EventQueue.getMostRecentEventTime(), this.getCurrentEventModifiers()));
    }

    private void installDefaultTransferHandlerIfNecessary() {
        if (this.getTransferHandler() == null) {
            if (defaultTransferHandler == null) {
                defaultTransferHandler = new DefaultTransferHandler();
            }
            this.setTransferHandler(defaultTransferHandler);
        }
    }

    public void moveCaretPosition(int n) {
        Document document = this.getDocument();
        if (document != null) {
            if (n > document.getLength() || n < 0) {
                throw new IllegalArgumentException("bad position: " + n);
            }
            this.caret.moveDot(n);
        }
    }

    public void setFocusAccelerator(char c) {
        c = Character.toUpperCase(c);
        char c2 = this.focusAccelerator;
        this.focusAccelerator = c;
        this.firePropertyChange(FOCUS_ACCELERATOR_KEY, c2, this.focusAccelerator);
        this.firePropertyChange("focusAccelerator", c2, this.focusAccelerator);
    }

    public char getFocusAccelerator() {
        return this.focusAccelerator;
    }

    public void read(Reader reader, Object object) throws IOException {
        EditorKit editorKit = this.getUI().getEditorKit(this);
        Document document = editorKit.createDefaultDocument();
        if (object != null) {
            document.putProperty("stream", object);
        }
        try {
            editorKit.read(reader, document, 0);
            this.setDocument(document);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    public void write(Writer writer) throws IOException {
        Document document = this.getDocument();
        try {
            this.getUI().getEditorKit(this).write(writer, document, 0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (JTextComponent.getFocusedComponent() == this) {
            AppContext.getAppContext().remove(FOCUSED_COMPONENT);
        }
    }

    public void setCaretPosition(int n) {
        Document document = this.getDocument();
        if (document != null) {
            if (n > document.getLength() || n < 0) {
                throw new IllegalArgumentException("bad position: " + n);
            }
            this.caret.setDot(n);
        }
    }

    public int getCaretPosition() {
        return this.caret.getDot();
    }

    public void setText(String string) {
        try {
            Document document = this.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).replace(0, document.getLength(), string, null);
            } else {
                document.remove(0, document.getLength());
                document.insertString(0, string, null);
            }
        }
        catch (BadLocationException badLocationException) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        }
    }

    public String getText() {
        String string;
        Document document = this.getDocument();
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            string = null;
        }
        return string;
    }

    public String getSelectedText() {
        int n;
        String string = null;
        int n2 = Math.min(this.caret.getDot(), this.caret.getMark());
        if (n2 != (n = Math.max(this.caret.getDot(), this.caret.getMark()))) {
            try {
                Document document = this.getDocument();
                string = document.getText(n2, n - n2);
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException(badLocationException.getMessage());
            }
        }
        return string;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        if (bl != this.editable) {
            boolean bl2 = this.editable;
            this.editable = bl;
            this.enableInputMethods(this.editable);
            this.firePropertyChange("editable", (Object)bl2, (Object)this.editable);
            this.repaint();
        }
    }

    public int getSelectionStart() {
        int n = Math.min(this.caret.getDot(), this.caret.getMark());
        return n;
    }

    public void setSelectionStart(int n) {
        this.select(n, this.getSelectionEnd());
    }

    public int getSelectionEnd() {
        int n = Math.max(this.caret.getDot(), this.caret.getMark());
        return n;
    }

    public void setSelectionEnd(int n) {
        this.select(this.getSelectionStart(), n);
    }

    public void select(int n, int n2) {
        int n3 = this.getDocument().getLength();
        if (n < 0) {
            n = 0;
        }
        if (n > n3) {
            n = n3;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        if (n2 < n) {
            n2 = n;
        }
        this.setCaretPosition(n);
        this.moveCaretPosition(n2);
    }

    public void selectAll() {
        Document document = this.getDocument();
        if (document != null) {
            this.setCaretPosition(0);
            this.moveCaretPosition(document.getLength());
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        TextUI textUI;
        String string = super.getToolTipText(mouseEvent);
        if (string == null && (textUI = this.getUI()) != null) {
            string = textUI.getToolTipText(this, new Point(mouseEvent.getX(), mouseEvent.getY()));
        }
        return string;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return rectangle.height / 10;
            }
            case 0: {
                return rectangle.width / 10;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return rectangle.height;
            }
            case 0: {
                return rectangle.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public boolean print() throws PrinterException {
        return this.print(null, null, true, null, null, true);
    }

    public boolean print(MessageFormat messageFormat, MessageFormat messageFormat2) throws PrinterException {
        return this.print(messageFormat, messageFormat2, true, null, null, true);
    }

    public boolean print(MessageFormat messageFormat, MessageFormat messageFormat2, boolean bl, PrintService printService, PrintRequestAttributeSet printRequestAttributeSet, boolean bl2) throws PrinterException {
        PrintRequestAttributeSet printRequestAttributeSet2;
        Printable printable;
        PrintingStatus printingStatus;
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        boolean bl3 = GraphicsEnvironment.isHeadless();
        final boolean bl4 = SwingUtilities.isEventDispatchThread();
        Printable printable2 = this.getPrintable(messageFormat, messageFormat2);
        if (bl2 && !bl3) {
            printingStatus = PrintingStatus.createPrintingStatus(this, printerJob);
            printable = printingStatus.createNotificationPrintable(printable2);
        } else {
            printingStatus = null;
            printable = printable2;
        }
        if (printService != null) {
            printerJob.setPrintService(printService);
        }
        printerJob.setPrintable(printable);
        PrintRequestAttributeSet printRequestAttributeSet3 = printRequestAttributeSet2 = printRequestAttributeSet == null ? new HashPrintRequestAttributeSet() : printRequestAttributeSet;
        if (bl && !bl3 && !printerJob.printDialog(printRequestAttributeSet2)) {
            return false;
        }
        Callable<Object> callable = new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                try {
                    printerJob.print(printRequestAttributeSet2);
                }
                finally {
                    if (printingStatus != null) {
                        printingStatus.dispose();
                    }
                }
                return null;
            }
        };
        final FutureTask<Object> futureTask = new FutureTask<Object>(callable);
        Runnable runnable = new Runnable(){

            public void run() {
                boolean bl = false;
                if (bl4) {
                    if (JTextComponent.this.isEnabled()) {
                        bl = true;
                        JTextComponent.this.setEnabled(false);
                    }
                } else {
                    try {
                        bl = SwingUtilities2.submit(new Callable<Boolean>(){

                            @Override
                            public Boolean call() throws Exception {
                                boolean bl = JTextComponent.this.isEnabled();
                                if (bl) {
                                    JTextComponent.this.setEnabled(false);
                                }
                                return bl;
                            }
                        }).get();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException(interruptedException);
                    }
                    catch (ExecutionException executionException) {
                        Throwable throwable = executionException.getCause();
                        if (throwable instanceof Error) {
                            throw (Error)throwable;
                        }
                        if (throwable instanceof RuntimeException) {
                            throw (RuntimeException)throwable;
                        }
                        throw new AssertionError((Object)throwable);
                    }
                }
                JTextComponent.this.getDocument().render(futureTask);
                if (bl) {
                    if (bl4) {
                        JTextComponent.this.setEnabled(true);
                    } else {
                        try {
                            SwingUtilities2.submit(new Runnable(){

                                public void run() {
                                    JTextComponent.this.setEnabled(true);
                                }
                            }, null).get();
                        }
                        catch (InterruptedException interruptedException) {
                            throw new RuntimeException(interruptedException);
                        }
                        catch (ExecutionException executionException) {
                            Throwable throwable = executionException.getCause();
                            if (throwable instanceof Error) {
                                throw (Error)throwable;
                            }
                            if (throwable instanceof RuntimeException) {
                                throw (RuntimeException)throwable;
                            }
                            throw new AssertionError((Object)throwable);
                        }
                    }
                }
            }
        };
        if (!bl2 || bl3) {
            runnable.run();
        } else if (bl4) {
            new Thread(runnable).start();
            printingStatus.showModal(true);
        } else {
            printingStatus.showModal(false);
            runnable.run();
        }
        try {
            futureTask.get();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof PrinterAbortException) {
                if (printingStatus != null && printingStatus.isAborted()) {
                    return false;
                }
                throw (PrinterAbortException)throwable;
            }
            if (throwable instanceof PrinterException) {
                throw (PrinterException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new AssertionError((Object)throwable);
        }
        return true;
    }

    public Printable getPrintable(MessageFormat messageFormat, MessageFormat messageFormat2) {
        return TextComponentPrintable.getPrintable(this, messageFormat, messageFormat2);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTextComponent();
        }
        return this.accessibleContext;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.caretEvent = new MutableCaretEvent(this);
        this.addMouseListener(this.caretEvent);
        this.addFocusListener(this.caretEvent);
    }

    @Override
    protected String paramString() {
        String string = this.editable ? "true" : "false";
        String string2 = this.caretColor != null ? this.caretColor.toString() : "";
        String string3 = this.selectionColor != null ? this.selectionColor.toString() : "";
        String string4 = this.selectedTextColor != null ? this.selectedTextColor.toString() : "";
        String string5 = this.disabledTextColor != null ? this.disabledTextColor.toString() : "";
        String string6 = this.margin != null ? this.margin.toString() : "";
        return super.paramString() + ",caretColor=" + string2 + ",disabledTextColor=" + string5 + ",editable=" + string + ",margin=" + string6 + ",selectedTextColor=" + string4 + ",selectionColor=" + string3;
    }

    static final JTextComponent getFocusedComponent() {
        return (JTextComponent)AppContext.getAppContext().get(FOCUSED_COMPONENT);
    }

    private int getCurrentEventModifiers() {
        int n = 0;
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        if (aWTEvent instanceof InputEvent) {
            n = ((InputEvent)aWTEvent).getModifiers();
        } else if (aWTEvent instanceof ActionEvent) {
            n = ((ActionEvent)aWTEvent).getModifiers();
        }
        return n;
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        super.processInputMethodEvent(inputMethodEvent);
        if (!inputMethodEvent.isConsumed()) {
            if (!this.isEditable()) {
                return;
            }
            switch (inputMethodEvent.getID()) {
                case 1100: {
                    this.replaceInputMethodText(inputMethodEvent);
                }
                case 1101: {
                    this.setInputMethodCaretPosition(inputMethodEvent);
                }
            }
            inputMethodEvent.consume();
        }
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (this.inputMethodRequestsHandler == null) {
            this.inputMethodRequestsHandler = new InputMethodRequestsHandler();
            Document document = this.getDocument();
            if (document != null) {
                document.addDocumentListener((DocumentListener)((Object)this.inputMethodRequestsHandler));
            }
        }
        return this.inputMethodRequestsHandler;
    }

    @Override
    public void addInputMethodListener(InputMethodListener inputMethodListener) {
        super.addInputMethodListener(inputMethodListener);
        if (inputMethodListener != null) {
            this.needToSendKeyTypedEvent = false;
            this.checkedInputOverride = true;
        }
    }

    private void replaceInputMethodText(InputMethodEvent inputMethodEvent) {
        int n = inputMethodEvent.getCommittedCharacterCount();
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        Document document = this.getDocument();
        if (this.composedTextExists()) {
            try {
                document.remove(this.composedTextStart.getOffset(), this.composedTextEnd.getOffset() - this.composedTextStart.getOffset());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.composedTextEnd = null;
            this.composedTextStart = null;
            this.composedTextAttribute = null;
            this.composedTextContent = null;
        }
        if (attributedCharacterIterator != null) {
            int n2;
            attributedCharacterIterator.first();
            int n3 = 0;
            int n4 = 0;
            if (n > 0) {
                n3 = this.caret.getDot();
                if (this.shouldSynthensizeKeyEvents()) {
                    char c = attributedCharacterIterator.current();
                    while (n > 0) {
                        KeyEvent keyEvent = new KeyEvent(this, 400, EventQueue.getMostRecentEventTime(), 0, 0, c);
                        this.processKeyEvent(keyEvent);
                        c = attributedCharacterIterator.next();
                        --n;
                    }
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    char c = attributedCharacterIterator.current();
                    while (n > 0) {
                        stringBuffer.append(c);
                        c = attributedCharacterIterator.next();
                        --n;
                    }
                    this.mapCommittedTextToAction(new String(stringBuffer));
                }
                n4 = this.caret.getDot();
            }
            if ((n2 = attributedCharacterIterator.getIndex()) < attributedCharacterIterator.getEndIndex()) {
                this.createComposedTextAttribute(n2, attributedCharacterIterator);
                try {
                    this.replaceSelection(null);
                    document.insertString(this.caret.getDot(), this.composedTextContent, this.composedTextAttribute);
                    this.composedTextStart = document.createPosition(this.caret.getDot() - this.composedTextContent.length());
                    this.composedTextEnd = document.createPosition(this.caret.getDot());
                }
                catch (BadLocationException badLocationException) {
                    this.composedTextEnd = null;
                    this.composedTextStart = null;
                    this.composedTextAttribute = null;
                    this.composedTextContent = null;
                }
            }
            if (n3 != n4) {
                try {
                    this.latestCommittedTextStart = document.createPosition(n3);
                    this.latestCommittedTextEnd = document.createPosition(n4);
                }
                catch (BadLocationException badLocationException) {
                    this.latestCommittedTextEnd = null;
                    this.latestCommittedTextStart = null;
                }
            } else {
                this.latestCommittedTextEnd = null;
                this.latestCommittedTextStart = null;
            }
        }
    }

    private void createComposedTextAttribute(int n, AttributedCharacterIterator attributedCharacterIterator) {
        Document document = this.getDocument();
        StringBuffer stringBuffer = new StringBuffer();
        char c = attributedCharacterIterator.setIndex(n);
        while (c != '\uffff') {
            stringBuffer.append(c);
            c = attributedCharacterIterator.next();
        }
        this.composedTextContent = new String(stringBuffer);
        this.composedTextAttribute = new SimpleAttributeSet();
        this.composedTextAttribute.addAttribute(StyleConstants.ComposedTextAttribute, new AttributedString(attributedCharacterIterator, n, attributedCharacterIterator.getEndIndex()));
    }

    private boolean saveComposedText(int n) {
        if (this.composedTextExists()) {
            int n2 = this.composedTextStart.getOffset();
            int n3 = this.composedTextEnd.getOffset() - this.composedTextStart.getOffset();
            if (n >= n2 && n <= n2 + n3) {
                try {
                    this.getDocument().remove(n2, n3);
                    return true;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private void restoreComposedText() {
        Document document = this.getDocument();
        try {
            document.insertString(this.caret.getDot(), this.composedTextContent, this.composedTextAttribute);
            this.composedTextStart = document.createPosition(this.caret.getDot() - this.composedTextContent.length());
            this.composedTextEnd = document.createPosition(this.caret.getDot());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void mapCommittedTextToAction(String string) {
        Keymap keymap = this.getKeymap();
        if (keymap != null) {
            Serializable serializable;
            Action action = null;
            if (string.length() == 1) {
                serializable = KeyStroke.getKeyStroke(string.charAt(0));
                action = keymap.getAction((KeyStroke)serializable);
            }
            if (action == null) {
                action = keymap.getDefaultAction();
            }
            if (action != null) {
                serializable = new ActionEvent(this, 1001, string, EventQueue.getMostRecentEventTime(), this.getCurrentEventModifiers());
                action.actionPerformed((ActionEvent)serializable);
            }
        }
    }

    private void setInputMethodCaretPosition(InputMethodEvent inputMethodEvent) {
        if (this.composedTextExists()) {
            TextHitInfo textHitInfo;
            int n = this.composedTextStart.getOffset();
            if (!(this.caret instanceof ComposedTextCaret)) {
                if (this.composedTextCaret == null) {
                    this.composedTextCaret = new ComposedTextCaret();
                }
                this.originalCaret = this.caret;
                this.exchangeCaret(this.originalCaret, this.composedTextCaret);
            }
            if ((textHitInfo = inputMethodEvent.getCaret()) != null) {
                int n2 = textHitInfo.getInsertionIndex();
                n += n2;
                if (n2 == 0) {
                    try {
                        Rectangle rectangle = this.modelToView(n);
                        Rectangle rectangle2 = this.modelToView(this.composedTextEnd.getOffset());
                        Rectangle rectangle3 = this.getBounds();
                        rectangle.x += Math.min(rectangle2.x - rectangle.x, rectangle3.width);
                        this.scrollRectToVisible(rectangle);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            this.caret.setDot(n);
        } else if (this.caret instanceof ComposedTextCaret) {
            int n = this.caret.getDot();
            this.exchangeCaret(this.caret, this.originalCaret);
            this.caret.setDot(n);
        }
    }

    private void exchangeCaret(Caret caret, Caret caret2) {
        int n = caret.getBlinkRate();
        this.setCaret(caret2);
        this.caret.setBlinkRate(n);
        this.caret.setVisible(this.hasFocus());
    }

    private boolean shouldSynthensizeKeyEvents() {
        if (!this.checkedInputOverride) {
            this.checkedInputOverride = true;
            this.needToSendKeyTypedEvent = !this.isProcessInputMethodEventOverridden();
        }
        return this.needToSendKeyTypedEvent;
    }

    private boolean isProcessInputMethodEventOverridden() {
        Boolean bl;
        if (overrideMap == null) {
            overrideMap = Collections.synchronizedMap(new HashMap());
        }
        if ((bl = (Boolean)overrideMap.get(this.getClass().getName())) != null) {
            return bl;
        }
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return JTextComponent.isProcessInputMethodEventOverridden(JTextComponent.this.getClass());
            }
        });
        return bl2;
    }

    boolean composedTextExists() {
        return this.composedTextStart != null;
    }

    static {
        KEYMAP_TABLE = new StringBuilder("JTextComponent_KeymapTable");
        FOCUSED_COMPONENT = new StringBuilder("JTextComponent_FocusedComponent");
    }

    public class AccessibleJTextComponent
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    CaretListener,
    DocumentListener,
    AccessibleAction,
    AccessibleEditableText,
    AccessibleExtendedText {
        int caretPos;
        Point oldLocationOnScreen;

        public AccessibleJTextComponent() {
            super(JTextComponent.this);
            Document document = JTextComponent.this.getDocument();
            if (document != null) {
                document.addDocumentListener(this);
            }
            JTextComponent.this.addCaretListener(this);
            this.caretPos = this.getCaretPosition();
            try {
                this.oldLocationOnScreen = this.getLocationOnScreen();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
            JTextComponent.this.addComponentListener(new ComponentAdapter(){

                public void componentMoved(ComponentEvent componentEvent) {
                    try {
                        Point point = AccessibleJTextComponent.this.getLocationOnScreen();
                        AccessibleJTextComponent.this.firePropertyChange("AccessibleVisibleData", AccessibleJTextComponent.this.oldLocationOnScreen, point);
                        AccessibleJTextComponent.this.oldLocationOnScreen = point;
                    }
                    catch (IllegalComponentStateException illegalComponentStateException) {
                        // empty catch block
                    }
                }
            });
        }

        public void caretUpdate(CaretEvent caretEvent) {
            int n = caretEvent.getDot();
            int n2 = caretEvent.getMark();
            if (this.caretPos != n) {
                this.firePropertyChange("AccessibleCaret", new Integer(this.caretPos), new Integer(n));
                this.caretPos = n;
                try {
                    this.oldLocationOnScreen = this.getLocationOnScreen();
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
            }
            if (n2 != n) {
                this.firePropertyChange("AccessibleSelection", null, this.getSelectedText());
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            final Integer n = new Integer(documentEvent.getOffset());
            if (SwingUtilities.isEventDispatchThread()) {
                this.firePropertyChange("AccessibleText", null, n);
            } else {
                Runnable runnable = new Runnable(){

                    public void run() {
                        AccessibleJTextComponent.this.firePropertyChange("AccessibleText", null, n);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            final Integer n = new Integer(documentEvent.getOffset());
            if (SwingUtilities.isEventDispatchThread()) {
                this.firePropertyChange("AccessibleText", null, n);
            } else {
                Runnable runnable = new Runnable(){

                    public void run() {
                        AccessibleJTextComponent.this.firePropertyChange("AccessibleText", null, n);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            final Integer n = new Integer(documentEvent.getOffset());
            if (SwingUtilities.isEventDispatchThread()) {
                this.firePropertyChange("AccessibleText", null, n);
            } else {
                Runnable runnable = new Runnable(){

                    public void run() {
                        AccessibleJTextComponent.this.firePropertyChange("AccessibleText", null, n);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JTextComponent.this.isEditable()) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public AccessibleText getAccessibleText() {
            return this;
        }

        public int getIndexAtPoint(Point point) {
            if (point == null) {
                return -1;
            }
            return JTextComponent.this.viewToModel(point);
        }

        Rectangle getRootEditorRect() {
            Rectangle rectangle = JTextComponent.this.getBounds();
            if (rectangle.width > 0 && rectangle.height > 0) {
                rectangle.y = 0;
                rectangle.x = 0;
                Insets insets = JTextComponent.this.getInsets();
                rectangle.x += insets.left;
                rectangle.y += insets.top;
                rectangle.width -= insets.left + insets.right;
                rectangle.height -= insets.top + insets.bottom;
                return rectangle;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Rectangle getCharacterBounds(int n) {
            if (n < 0 || n > JTextComponent.this.model.getLength() - 1) {
                return null;
            }
            TextUI textUI = JTextComponent.this.getUI();
            if (textUI == null) {
                return null;
            }
            Rectangle rectangle = null;
            Rectangle rectangle2 = this.getRootEditorRect();
            if (rectangle2 == null) {
                return null;
            }
            if (JTextComponent.this.model instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.this.model).readLock();
            }
            try {
                View view = textUI.getRootView(JTextComponent.this);
                if (view != null) {
                    view.setSize(rectangle2.width, rectangle2.height);
                    Shape shape = view.modelToView(n, Position.Bias.Forward, n + 1, Position.Bias.Backward, rectangle2);
                    rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                }
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                if (JTextComponent.this.model instanceof AbstractDocument) {
                    ((AbstractDocument)JTextComponent.this.model).readUnlock();
                }
            }
            return rectangle;
        }

        public int getCharCount() {
            return JTextComponent.this.model.getLength();
        }

        public int getCaretPosition() {
            return JTextComponent.this.getCaretPosition();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeSet getCharacterAttribute(int n) {
            Element element = null;
            if (JTextComponent.this.model instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.this.model).readLock();
            }
            try {
                element = JTextComponent.this.model.getDefaultRootElement();
                while (!element.isLeaf()) {
                    int n2 = element.getElementIndex(n);
                    element = element.getElement(n2);
                }
            }
            finally {
                if (JTextComponent.this.model instanceof AbstractDocument) {
                    ((AbstractDocument)JTextComponent.this.model).readUnlock();
                }
            }
            return element.getAttributes();
        }

        public int getSelectionStart() {
            return JTextComponent.this.getSelectionStart();
        }

        public int getSelectionEnd() {
            return JTextComponent.this.getSelectionEnd();
        }

        public String getSelectedText() {
            return JTextComponent.this.getSelectedText();
        }

        public String getAtIndex(int n, int n2) {
            return this.getAtIndex(n, n2, 0);
        }

        public String getAfterIndex(int n, int n2) {
            return this.getAtIndex(n, n2, 1);
        }

        public String getBeforeIndex(int n, int n2) {
            return this.getAtIndex(n, n2, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String getAtIndex(int n, int n2, int n3) {
            if (JTextComponent.this.model instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.this.model).readLock();
            }
            try {
                if (n2 < 0 || n2 >= JTextComponent.this.model.getLength()) {
                    String string = null;
                    return string;
                }
                switch (n) {
                    case 1: {
                        if (n2 + n3 >= JTextComponent.this.model.getLength()) return null;
                        if (n2 + n3 < 0) return null;
                        String string = JTextComponent.this.model.getText(n2 + n3, 1);
                        return string;
                    }
                    case 2: 
                    case 3: {
                        IndexedSegment indexedSegment = this.getSegmentAt(n, n2);
                        if (indexedSegment == null) return null;
                        if (n3 != 0) {
                            int n4 = n3 < 0 ? indexedSegment.modelOffset - 1 : indexedSegment.modelOffset + n3 * indexedSegment.count;
                            indexedSegment = n4 >= 0 && n4 <= JTextComponent.this.model.getLength() ? this.getSegmentAt(n, n4) : null;
                        }
                        if (indexedSegment == null) return null;
                        String string = new String(indexedSegment.array, indexedSegment.offset, indexedSegment.count);
                        return string;
                    }
                }
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
            finally {
                if (JTextComponent.this.model instanceof AbstractDocument) {
                    ((AbstractDocument)JTextComponent.this.model).readUnlock();
                }
            }
        }

        private Element getParagraphElement(int n) {
            if (JTextComponent.this.model instanceof PlainDocument) {
                PlainDocument plainDocument = (PlainDocument)JTextComponent.this.model;
                return plainDocument.getParagraphElement(n);
            }
            if (JTextComponent.this.model instanceof StyledDocument) {
                StyledDocument styledDocument = (StyledDocument)JTextComponent.this.model;
                return styledDocument.getParagraphElement(n);
            }
            Element element = null;
            element = JTextComponent.this.model.getDefaultRootElement();
            while (!element.isLeaf()) {
                int n2 = element.getElementIndex(n);
                element = element.getElement(n2);
            }
            if (element == null) {
                return null;
            }
            return element.getParentElement();
        }

        private IndexedSegment getParagraphElementText(int n) throws BadLocationException {
            Element element = this.getParagraphElement(n);
            if (element != null) {
                IndexedSegment indexedSegment = new IndexedSegment();
                try {
                    int n2 = element.getEndOffset() - element.getStartOffset();
                    JTextComponent.this.model.getText(element.getStartOffset(), n2, indexedSegment);
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                indexedSegment.modelOffset = element.getStartOffset();
                return indexedSegment;
            }
            return null;
        }

        private IndexedSegment getSegmentAt(int n, int n2) throws BadLocationException {
            BreakIterator breakIterator;
            IndexedSegment indexedSegment = this.getParagraphElementText(n2);
            if (indexedSegment == null) {
                return null;
            }
            switch (n) {
                case 2: {
                    breakIterator = BreakIterator.getWordInstance(this.getLocale());
                    break;
                }
                case 3: {
                    breakIterator = BreakIterator.getSentenceInstance(this.getLocale());
                    break;
                }
                default: {
                    return null;
                }
            }
            indexedSegment.first();
            breakIterator.setText(indexedSegment);
            int n3 = breakIterator.following(n2 - indexedSegment.modelOffset + indexedSegment.offset);
            if (n3 == -1) {
                return null;
            }
            if (n3 > indexedSegment.offset + indexedSegment.count) {
                return null;
            }
            int n4 = breakIterator.previous();
            if (n4 == -1 || n4 >= indexedSegment.offset + indexedSegment.count) {
                return null;
            }
            indexedSegment.modelOffset = indexedSegment.modelOffset + n4 - indexedSegment.offset;
            indexedSegment.offset = n4;
            indexedSegment.count = n3 - n4;
            return indexedSegment;
        }

        public AccessibleEditableText getAccessibleEditableText() {
            return this;
        }

        public void setTextContents(String string) {
            JTextComponent.this.setText(string);
        }

        public void insertTextAtIndex(int n, String string) {
            Document document = JTextComponent.this.getDocument();
            if (document != null) {
                try {
                    if (string != null && string.length() > 0) {
                        boolean bl = JTextComponent.this.saveComposedText(n);
                        document.insertString(n, string, null);
                        if (bl) {
                            JTextComponent.this.restoreComposedText();
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(JTextComponent.this);
                }
            }
        }

        public String getTextRange(int n, int n2) {
            int n3;
            String string = null;
            int n4 = Math.min(n, n2);
            if (n4 != (n3 = Math.max(n, n2))) {
                try {
                    Document document = JTextComponent.this.getDocument();
                    string = document.getText(n4, n3 - n4);
                }
                catch (BadLocationException badLocationException) {
                    throw new IllegalArgumentException(badLocationException.getMessage());
                }
            }
            return string;
        }

        public void delete(int n, int n2) {
            if (JTextComponent.this.isEditable() && this.isEnabled()) {
                try {
                    int n3 = Math.min(n, n2);
                    int n4 = Math.max(n, n2);
                    if (n3 != n4) {
                        Document document = JTextComponent.this.getDocument();
                        document.remove(n3, n4 - n3);
                    }
                }
                catch (BadLocationException badLocationException) {}
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(JTextComponent.this);
            }
        }

        public void cut(int n, int n2) {
            this.selectText(n, n2);
            JTextComponent.this.cut();
        }

        public void paste(int n) {
            JTextComponent.this.setCaretPosition(n);
            JTextComponent.this.paste();
        }

        public void replaceText(int n, int n2, String string) {
            this.selectText(n, n2);
            JTextComponent.this.replaceSelection(string);
        }

        public void selectText(int n, int n2) {
            JTextComponent.this.select(n, n2);
        }

        public void setAttributes(int n, int n2, AttributeSet attributeSet) {
            Document document = JTextComponent.this.getDocument();
            if (document != null && document instanceof StyledDocument) {
                StyledDocument styledDocument = (StyledDocument)document;
                int n3 = n;
                int n4 = n2 - n;
                styledDocument.setCharacterAttributes(n3, n4, attributeSet, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AccessibleTextSequence getSequenceAtIndex(int n, int n2, int n3) {
            if (n2 < 0 || n2 >= JTextComponent.this.model.getLength()) {
                return null;
            }
            if (n3 < -1 || n3 > 1) {
                return null;
            }
            switch (n) {
                case 1: {
                    if (JTextComponent.this.model instanceof AbstractDocument) {
                        ((AbstractDocument)JTextComponent.this.model).readLock();
                    }
                    AccessibleTextSequence accessibleTextSequence = null;
                    try {
                        if (n2 + n3 < JTextComponent.this.model.getLength() && n2 + n3 >= 0) {
                            accessibleTextSequence = new AccessibleTextSequence(n2 + n3, n2 + n3 + 1, JTextComponent.this.model.getText(n2 + n3, 1));
                        }
                    }
                    catch (BadLocationException badLocationException) {
                    }
                    finally {
                        if (JTextComponent.this.model instanceof AbstractDocument) {
                            ((AbstractDocument)JTextComponent.this.model).readUnlock();
                        }
                    }
                    return accessibleTextSequence;
                }
                case 2: 
                case 3: {
                    if (JTextComponent.this.model instanceof AbstractDocument) {
                        ((AbstractDocument)JTextComponent.this.model).readLock();
                    }
                    AccessibleTextSequence accessibleTextSequence = null;
                    try {
                        IndexedSegment indexedSegment = this.getSegmentAt(n, n2);
                        if (indexedSegment != null) {
                            if (n3 != 0) {
                                int n4 = n3 < 0 ? indexedSegment.modelOffset - 1 : indexedSegment.modelOffset + indexedSegment.count;
                                indexedSegment = n4 >= 0 && n4 <= JTextComponent.this.model.getLength() ? this.getSegmentAt(n, n4) : null;
                            }
                            if (indexedSegment != null && indexedSegment.offset + indexedSegment.count <= JTextComponent.this.model.getLength()) {
                                accessibleTextSequence = new AccessibleTextSequence(indexedSegment.offset, indexedSegment.offset + indexedSegment.count, new String(indexedSegment.array, indexedSegment.offset, indexedSegment.count));
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                    }
                    finally {
                        if (JTextComponent.this.model instanceof AbstractDocument) {
                            ((AbstractDocument)JTextComponent.this.model).readUnlock();
                        }
                    }
                    return accessibleTextSequence;
                }
                case 4: {
                    AccessibleTextSequence accessibleTextSequence = null;
                    if (JTextComponent.this.model instanceof AbstractDocument) {
                        ((AbstractDocument)JTextComponent.this.model).readLock();
                    }
                    try {
                        int n5 = Utilities.getRowStart(JTextComponent.this, n2);
                        int n6 = Utilities.getRowEnd(JTextComponent.this, n2);
                        if (n5 >= 0 && n6 >= n5) {
                            if (n3 == 0) {
                                accessibleTextSequence = new AccessibleTextSequence(n5, n6, JTextComponent.this.model.getText(n5, n6 - n5 + 1));
                            } else if (n3 == -1 && n5 > 0) {
                                n6 = Utilities.getRowEnd(JTextComponent.this, n5 - 1);
                                if ((n5 = Utilities.getRowStart(JTextComponent.this, n5 - 1)) >= 0 && n6 >= n5) {
                                    accessibleTextSequence = new AccessibleTextSequence(n5, n6, JTextComponent.this.model.getText(n5, n6 - n5 + 1));
                                }
                            } else if (n3 == 1 && n6 < JTextComponent.this.model.getLength()) {
                                n5 = Utilities.getRowStart(JTextComponent.this, n6 + 1);
                                n6 = Utilities.getRowEnd(JTextComponent.this, n6 + 1);
                                if (n5 >= 0 && n6 >= n5) {
                                    accessibleTextSequence = new AccessibleTextSequence(n5, n6, JTextComponent.this.model.getText(n5, n6 - n5 + 1));
                                }
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                    }
                    finally {
                        if (JTextComponent.this.model instanceof AbstractDocument) {
                            ((AbstractDocument)JTextComponent.this.model).readUnlock();
                        }
                    }
                    return accessibleTextSequence;
                }
                case 5: {
                    int n7;
                    int n8;
                    String string = null;
                    if (JTextComponent.this.model instanceof AbstractDocument) {
                        ((AbstractDocument)JTextComponent.this.model).readLock();
                    }
                    try {
                        n8 = Integer.MIN_VALUE;
                        n7 = Integer.MIN_VALUE;
                        int n9 = n2;
                        switch (n3) {
                            case -1: {
                                n8 = this.getRunEdge(n2, n3);
                                n9 = n8 - 1;
                                break;
                            }
                            case 1: {
                                n9 = n7 = this.getRunEdge(n2, n3);
                                break;
                            }
                            case 0: {
                                break;
                            }
                            default: {
                                throw new AssertionError(n3);
                            }
                        }
                        n7 = n7 != Integer.MIN_VALUE ? n7 : this.getRunEdge(n9, -1);
                        n8 = n8 != Integer.MIN_VALUE ? n8 : this.getRunEdge(n9, 1);
                        string = JTextComponent.this.model.getText(n7, n8 - n7);
                    }
                    catch (BadLocationException badLocationException) {
                        AccessibleTextSequence accessibleTextSequence = null;
                        return accessibleTextSequence;
                    }
                    finally {
                        if (JTextComponent.this.model instanceof AbstractDocument) {
                            ((AbstractDocument)JTextComponent.this.model).readUnlock();
                        }
                    }
                    return new AccessibleTextSequence(n7, n8, string);
                }
            }
            return null;
        }

        private int getRunEdge(int n, int n2) throws BadLocationException {
            if (n < 0 || n >= JTextComponent.this.model.getLength()) {
                throw new BadLocationException("Location out of bounds", n);
            }
            Element element = null;
            int n3 = -1;
            element = JTextComponent.this.model.getDefaultRootElement();
            while (!element.isLeaf()) {
                n3 = element.getElementIndex(n);
                element = element.getElement(n3);
            }
            if (n3 == -1) {
                throw new AssertionError(n);
            }
            AttributeSet attributeSet = element.getAttributes();
            Element element2 = element.getParentElement();
            Element element3 = element;
            switch (n2) {
                case -1: 
                case 1: {
                    int n4 = n3;
                    int n5 = element2.getElementCount();
                    while (n4 + n2 > 0 && n4 + n2 < n5 && element2.getElement(n4 + n2).getAttributes().isEqual(attributeSet)) {
                        n4 += n2;
                    }
                    element3 = element2.getElement(n4);
                    break;
                }
                default: {
                    throw new AssertionError(n2);
                }
            }
            switch (n2) {
                case -1: {
                    return element3.getStartOffset();
                }
                case 1: {
                    return element3.getEndOffset();
                }
            }
            return Integer.MIN_VALUE;
        }

        public AccessibleTextSequence getTextSequenceAt(int n, int n2) {
            return this.getSequenceAtIndex(n, n2, 0);
        }

        public AccessibleTextSequence getTextSequenceAfter(int n, int n2) {
            return this.getSequenceAtIndex(n, n2, 1);
        }

        public AccessibleTextSequence getTextSequenceBefore(int n, int n2) {
            return this.getSequenceAtIndex(n, n2, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Rectangle getTextBounds(int n, int n2) {
            if (n < 0 || n > JTextComponent.this.model.getLength() - 1 || n2 < 0 || n2 > JTextComponent.this.model.getLength() - 1 || n > n2) {
                return null;
            }
            TextUI textUI = JTextComponent.this.getUI();
            if (textUI == null) {
                return null;
            }
            Rectangle rectangle = null;
            Rectangle rectangle2 = this.getRootEditorRect();
            if (rectangle2 == null) {
                return null;
            }
            if (JTextComponent.this.model instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.this.model).readLock();
            }
            try {
                View view = textUI.getRootView(JTextComponent.this);
                if (view != null) {
                    Shape shape = view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, rectangle2);
                    rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                }
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                if (JTextComponent.this.model instanceof AbstractDocument) {
                    ((AbstractDocument)JTextComponent.this.model).readUnlock();
                }
            }
            return rectangle;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public int getAccessibleActionCount() {
            Action[] actionArray = JTextComponent.this.getActions();
            return actionArray.length;
        }

        public String getAccessibleActionDescription(int n) {
            Action[] actionArray = JTextComponent.this.getActions();
            if (n < 0 || n >= actionArray.length) {
                return null;
            }
            return (String)actionArray[n].getValue("Name");
        }

        public boolean doAccessibleAction(int n) {
            Action[] actionArray = JTextComponent.this.getActions();
            if (n < 0 || n >= actionArray.length) {
                return false;
            }
            ActionEvent actionEvent = new ActionEvent(JTextComponent.this, 1001, null, EventQueue.getMostRecentEventTime(), JTextComponent.this.getCurrentEventModifiers());
            actionArray[n].actionPerformed(actionEvent);
            return true;
        }

        private class IndexedSegment
        extends Segment {
            public int modelOffset;

            private IndexedSegment() {
            }
        }
    }

    class ComposedTextCaret
    extends DefaultCaret
    implements Serializable {
        Color bg;

        ComposedTextCaret() {
        }

        public void install(JTextComponent jTextComponent) {
            super.install(jTextComponent);
            Document document = jTextComponent.getDocument();
            if (document instanceof StyledDocument) {
                StyledDocument styledDocument = (StyledDocument)document;
                Element element = styledDocument.getCharacterElement(jTextComponent.composedTextStart.getOffset());
                AttributeSet attributeSet = element.getAttributes();
                this.bg = styledDocument.getBackground(attributeSet);
            }
            if (this.bg == null) {
                this.bg = jTextComponent.getBackground();
            }
        }

        public void paint(Graphics graphics) {
            if (this.isVisible()) {
                try {
                    Rectangle rectangle = this.component.modelToView(this.getDot());
                    graphics.setXORMode(this.bg);
                    graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
                    graphics.setPaintMode();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        protected void positionCaret(MouseEvent mouseEvent) {
            int n;
            JTextComponent jTextComponent = this.component;
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n2 = jTextComponent.viewToModel(point);
            if (n2 < (n = jTextComponent.composedTextStart.getOffset()) || n2 > JTextComponent.this.composedTextEnd.getOffset()) {
                try {
                    Position position = jTextComponent.getDocument().createPosition(n2);
                    jTextComponent.getInputContext().endComposition();
                    EventQueue.invokeLater(new DoSetCaretPosition(jTextComponent, position));
                }
                catch (BadLocationException badLocationException) {
                    System.err.println(badLocationException);
                }
            } else {
                super.positionCaret(mouseEvent);
            }
        }
    }

    static class DefaultKeymap
    implements Keymap {
        String nm;
        Keymap parent;
        Hashtable bindings;
        Action defaultAction;

        DefaultKeymap(String string, Keymap keymap) {
            this.nm = string;
            this.parent = keymap;
            this.bindings = new Hashtable();
        }

        public Action getDefaultAction() {
            if (this.defaultAction != null) {
                return this.defaultAction;
            }
            return this.parent != null ? this.parent.getDefaultAction() : null;
        }

        public void setDefaultAction(Action action) {
            this.defaultAction = action;
        }

        public String getName() {
            return this.nm;
        }

        public Action getAction(KeyStroke keyStroke) {
            Action action = (Action)this.bindings.get(keyStroke);
            if (action == null && this.parent != null) {
                action = this.parent.getAction(keyStroke);
            }
            return action;
        }

        public KeyStroke[] getBoundKeyStrokes() {
            KeyStroke[] keyStrokeArray = new KeyStroke[this.bindings.size()];
            int n = 0;
            Enumeration enumeration = this.bindings.keys();
            while (enumeration.hasMoreElements()) {
                keyStrokeArray[n++] = (KeyStroke)enumeration.nextElement();
            }
            return keyStrokeArray;
        }

        public Action[] getBoundActions() {
            Action[] actionArray = new Action[this.bindings.size()];
            int n = 0;
            Enumeration enumeration = this.bindings.elements();
            while (enumeration.hasMoreElements()) {
                actionArray[n++] = (Action)enumeration.nextElement();
            }
            return actionArray;
        }

        public KeyStroke[] getKeyStrokesForAction(Action action) {
            if (action == null) {
                return null;
            }
            Object[] objectArray = null;
            Vector vector = null;
            KeyStroke[] keyStrokeArray = this.bindings.keys();
            while (keyStrokeArray.hasMoreElements()) {
                Object k = keyStrokeArray.nextElement();
                if (this.bindings.get(k) != action) continue;
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement(k);
            }
            if (this.parent != null && (keyStrokeArray = this.parent.getKeyStrokesForAction(action)) != null) {
                int n;
                int n2 = 0;
                for (n = keyStrokeArray.length - 1; n >= 0; --n) {
                    if (!this.isLocallyDefined(keyStrokeArray[n])) continue;
                    keyStrokeArray[n] = null;
                    ++n2;
                }
                if (n2 > 0 && n2 < keyStrokeArray.length) {
                    if (vector == null) {
                        vector = new Vector();
                    }
                    for (n = keyStrokeArray.length - 1; n >= 0; --n) {
                        if (keyStrokeArray[n] == null) continue;
                        vector.addElement(keyStrokeArray[n]);
                    }
                } else if (n2 == 0) {
                    if (vector == null) {
                        objectArray = keyStrokeArray;
                    } else {
                        objectArray = new KeyStroke[vector.size() + keyStrokeArray.length];
                        vector.copyInto(objectArray);
                        System.arraycopy(keyStrokeArray, 0, objectArray, vector.size(), keyStrokeArray.length);
                        vector = null;
                    }
                }
            }
            if (vector != null) {
                objectArray = new KeyStroke[vector.size()];
                vector.copyInto(objectArray);
            }
            return objectArray;
        }

        public boolean isLocallyDefined(KeyStroke keyStroke) {
            return this.bindings.containsKey(keyStroke);
        }

        public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
            this.bindings.put(keyStroke, action);
        }

        public void removeKeyStrokeBinding(KeyStroke keyStroke) {
            this.bindings.remove(keyStroke);
        }

        public void removeBindings() {
            this.bindings.clear();
        }

        public Keymap getResolveParent() {
            return this.parent;
        }

        public void setResolveParent(Keymap keymap) {
            this.parent = keymap;
        }

        public String toString() {
            return "Keymap[" + this.nm + "]" + this.bindings;
        }
    }

    static class DefaultTransferHandler
    extends TransferHandler
    implements UIResource {
        DefaultTransferHandler() {
        }

        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) throws IllegalStateException {
            int n2;
            JTextComponent jTextComponent;
            int n3;
            if (jComponent instanceof JTextComponent && (n3 = (jTextComponent = (JTextComponent)jComponent).getSelectionStart()) != (n2 = jTextComponent.getSelectionEnd())) {
                try {
                    Document document = jTextComponent.getDocument();
                    String string = document.getText(n3, n2 - n3);
                    StringSelection stringSelection = new StringSelection(string);
                    clipboard.setContents(stringSelection, null);
                    if (n == 2) {
                        document.remove(n3, n2 - n3);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            DataFlavor dataFlavor;
            if (jComponent instanceof JTextComponent && (dataFlavor = this.getFlavor(transferable.getTransferDataFlavors())) != null) {
                InputContext inputContext = jComponent.getInputContext();
                if (inputContext != null) {
                    inputContext.endComposition();
                }
                try {
                    String string = (String)transferable.getTransferData(dataFlavor);
                    ((JTextComponent)jComponent).replaceSelection(string);
                    return true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                return false;
            }
            return this.getFlavor(dataFlavorArray) != null;
        }

        public int getSourceActions(JComponent jComponent) {
            return 0;
        }

        private DataFlavor getFlavor(DataFlavor[] dataFlavorArray) {
            if (dataFlavorArray != null) {
                for (int i = 0; i < dataFlavorArray.length; ++i) {
                    if (!dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
                    return dataFlavorArray[i];
                }
            }
            return null;
        }
    }

    private class DoSetCaretPosition
    implements Runnable {
        JTextComponent host;
        Position newPos;

        DoSetCaretPosition(JTextComponent jTextComponent2, Position position) {
            this.host = jTextComponent2;
            this.newPos = position;
        }

        public void run() {
            this.host.setCaretPosition(this.newPos.getOffset());
        }
    }

    public static final class DropLocation
    extends TransferHandler.DropLocation {
        private final int index;
        private final Position.Bias bias;

        private DropLocation(Point point, int n, Position.Bias bias) {
            super(point);
            this.index = n;
            this.bias = bias;
        }

        public int getIndex() {
            return this.index;
        }

        public Position.Bias getBias() {
            return this.bias;
        }

        public String toString() {
            return this.getClass().getName() + "[dropPoint=" + this.getDropPoint() + "," + "index=" + this.index + "," + "bias=" + this.bias + "]";
        }
    }

    class InputMethodRequestsHandler
    implements InputMethodRequests,
    DocumentListener {
        InputMethodRequestsHandler() {
        }

        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
            Document document = JTextComponent.this.getDocument();
            if (document != null && JTextComponent.this.latestCommittedTextStart != null && !JTextComponent.this.latestCommittedTextStart.equals(JTextComponent.this.latestCommittedTextEnd)) {
                try {
                    int n = JTextComponent.this.latestCommittedTextStart.getOffset();
                    int n2 = JTextComponent.this.latestCommittedTextEnd.getOffset();
                    String string = document.getText(n, n2 - n);
                    document.remove(n, n2 - n);
                    return new AttributedString(string).getIterator();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return null;
        }

        public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
            String string;
            int n3 = 0;
            int n4 = 0;
            if (JTextComponent.this.composedTextExists()) {
                n3 = JTextComponent.this.composedTextStart.getOffset();
                n4 = JTextComponent.this.composedTextEnd.getOffset();
            }
            try {
                if (n < n3) {
                    if (n2 <= n3) {
                        string = JTextComponent.this.getText(n, n2 - n);
                    } else {
                        int n5 = n3 - n;
                        string = JTextComponent.this.getText(n, n5) + JTextComponent.this.getText(n4, n2 - n - n5);
                    }
                } else {
                    string = JTextComponent.this.getText(n + (n4 - n3), n2 - n);
                }
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException("Invalid range");
            }
            return new AttributedString(string).getIterator();
        }

        public int getCommittedTextLength() {
            Document document = JTextComponent.this.getDocument();
            int n = 0;
            if (document != null) {
                n = document.getLength();
                if (JTextComponent.this.composedTextContent != null) {
                    n = JTextComponent.this.composedTextEnd == null || JTextComponent.this.composedTextStart == null ? (n -= JTextComponent.this.composedTextContent.length()) : (n -= JTextComponent.this.composedTextEnd.getOffset() - JTextComponent.this.composedTextStart.getOffset());
                }
            }
            return n;
        }

        public int getInsertPositionOffset() {
            int n;
            int n2 = 0;
            int n3 = 0;
            if (JTextComponent.this.composedTextExists()) {
                n2 = JTextComponent.this.composedTextStart.getOffset();
                n3 = JTextComponent.this.composedTextEnd.getOffset();
            }
            if ((n = JTextComponent.this.getCaretPosition()) < n2) {
                return n;
            }
            if (n < n3) {
                return n2;
            }
            return n - (n3 - n2);
        }

        public TextHitInfo getLocationOffset(int n, int n2) {
            if (JTextComponent.this.composedTextAttribute == null) {
                return null;
            }
            Point point = JTextComponent.this.getLocationOnScreen();
            point.x = n - point.x;
            point.y = n2 - point.y;
            int n3 = JTextComponent.this.viewToModel(point);
            if (n3 >= JTextComponent.this.composedTextStart.getOffset() && n3 <= JTextComponent.this.composedTextEnd.getOffset()) {
                return TextHitInfo.leading(n3 - JTextComponent.this.composedTextStart.getOffset());
            }
            return null;
        }

        public Rectangle getTextLocation(TextHitInfo textHitInfo) {
            Rectangle rectangle;
            try {
                rectangle = JTextComponent.this.modelToView(JTextComponent.this.getCaretPosition());
                if (rectangle != null) {
                    Point point = JTextComponent.this.getLocationOnScreen();
                    rectangle.translate(point.x, point.y);
                }
            }
            catch (BadLocationException badLocationException) {
                rectangle = null;
            }
            if (rectangle == null) {
                rectangle = new Rectangle();
            }
            return rectangle;
        }

        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
            String string = JTextComponent.this.getSelectedText();
            if (string != null) {
                return new AttributedString(string).getIterator();
            }
            return null;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            JTextComponent.this.latestCommittedTextStart = (JTextComponent.this.latestCommittedTextEnd = null);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            JTextComponent.this.latestCommittedTextStart = (JTextComponent.this.latestCommittedTextEnd = null);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            JTextComponent.this.latestCommittedTextStart = (JTextComponent.this.latestCommittedTextEnd = null);
        }
    }

    public static class KeyBinding {
        public KeyStroke key;
        public String actionName;

        public KeyBinding(KeyStroke keyStroke, String string) {
            this.key = keyStroke;
            this.actionName = string;
        }
    }

    static class KeymapActionMap
    extends ActionMap {
        private Keymap keymap;

        KeymapActionMap(Keymap keymap) {
            this.keymap = keymap;
        }

        public Object[] keys() {
            boolean bl;
            Object[] objectArray = super.keys();
            Object[] objectArray2 = this.keymap.getBoundActions();
            int n = objectArray == null ? 0 : objectArray.length;
            int n2 = objectArray2 == null ? 0 : objectArray2.length;
            boolean bl2 = bl = this.keymap.getDefaultAction() != null;
            if (bl) {
                ++n2;
            }
            if (n == 0) {
                if (bl) {
                    Object[] objectArray3 = new Object[n2];
                    if (n2 > 1) {
                        System.arraycopy(objectArray2, 0, objectArray3, 0, n2 - 1);
                    }
                    objectArray3[n2 - 1] = KeymapWrapper.DefaultActionKey;
                    return objectArray3;
                }
                return objectArray2;
            }
            if (n2 == 0) {
                return objectArray;
            }
            Object[] objectArray4 = new Object[n + n2];
            System.arraycopy(objectArray, 0, objectArray4, 0, n);
            if (bl) {
                if (n2 > 1) {
                    System.arraycopy(objectArray2, 0, objectArray4, n, n2 - 1);
                }
                objectArray4[n + n2 - 1] = KeymapWrapper.DefaultActionKey;
            } else {
                System.arraycopy(objectArray2, 0, objectArray4, n, n2);
            }
            return objectArray4;
        }

        public int size() {
            int n;
            Action[] actionArray = this.keymap.getBoundActions();
            int n2 = n = actionArray == null ? 0 : actionArray.length;
            if (this.keymap.getDefaultAction() != null) {
                ++n;
            }
            return super.size() + n;
        }

        public Action get(Object object) {
            Action action = super.get(object);
            if (action == null) {
                if (object == KeymapWrapper.DefaultActionKey) {
                    action = this.keymap.getDefaultAction();
                } else if (object instanceof Action) {
                    action = (Action)object;
                }
            }
            return action;
        }
    }

    static class KeymapWrapper
    extends InputMap {
        static final Object DefaultActionKey = new Object();
        private Keymap keymap;

        KeymapWrapper(Keymap keymap) {
            this.keymap = keymap;
        }

        public KeyStroke[] keys() {
            int n;
            KeyStroke[] keyStrokeArray = super.keys();
            KeyStroke[] keyStrokeArray2 = this.keymap.getBoundKeyStrokes();
            int n2 = keyStrokeArray == null ? 0 : keyStrokeArray.length;
            int n3 = n = keyStrokeArray2 == null ? 0 : keyStrokeArray2.length;
            if (n2 == 0) {
                return keyStrokeArray2;
            }
            if (n == 0) {
                return keyStrokeArray;
            }
            KeyStroke[] keyStrokeArray3 = new KeyStroke[n2 + n];
            System.arraycopy(keyStrokeArray, 0, keyStrokeArray3, 0, n2);
            System.arraycopy(keyStrokeArray2, 0, keyStrokeArray3, n2, n);
            return keyStrokeArray3;
        }

        public int size() {
            KeyStroke[] keyStrokeArray = this.keymap.getBoundKeyStrokes();
            int n = keyStrokeArray == null ? 0 : keyStrokeArray.length;
            return super.size() + n;
        }

        public Object get(KeyStroke keyStroke) {
            Object object = this.keymap.getAction(keyStroke);
            if (object == null && (object = super.get(keyStroke)) == null && keyStroke.getKeyChar() != '\uffff' && this.keymap.getDefaultAction() != null) {
                object = DefaultActionKey;
            }
            return object;
        }
    }

    static class MutableCaretEvent
    extends CaretEvent
    implements ChangeListener,
    FocusListener,
    MouseListener {
        private boolean dragActive;
        private int dot;
        private int mark;

        MutableCaretEvent(JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        final void fire() {
            JTextComponent jTextComponent = (JTextComponent)this.getSource();
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                this.dot = caret.getDot();
                this.mark = caret.getMark();
                jTextComponent.fireCaretUpdate(this);
            }
        }

        public final String toString() {
            return "dot=" + this.dot + "," + "mark=" + this.mark;
        }

        public final int getDot() {
            return this.dot;
        }

        public final int getMark() {
            return this.mark;
        }

        public final void stateChanged(ChangeEvent changeEvent) {
            if (!this.dragActive) {
                this.fire();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            AppContext.getAppContext().put(FOCUSED_COMPONENT, focusEvent.getSource());
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public final void mousePressed(MouseEvent mouseEvent) {
            this.dragActive = true;
        }

        public final void mouseReleased(MouseEvent mouseEvent) {
            this.dragActive = false;
            this.fire();
        }

        public final void mouseClicked(MouseEvent mouseEvent) {
        }

        public final void mouseEntered(MouseEvent mouseEvent) {
        }

        public final void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

