/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.util;

import java.io.File;
import sun.plugin2.util.SystemUtil;

public class NativeLibLoader {
    private static final boolean DEBUG = SystemUtil.debug("NativeLibLoader");

    private NativeLibLoader() {
    }

    public static synchronized void load(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new InternalError("Wrong library name passed to load method");
        }
        String[] stringArray2 = SystemUtil.getSystemProperty("sun.boot.class.path").split(File.pathSeparator);
        String[] stringArray3 = NativeLibLoader.getPossibleSubdirs();
        if (!(NativeLibLoader.tryLoadingFromJRE(stringArray, stringArray3, NativeLibLoader.findSuffix(stringArray2, "plugin.jar")) || NativeLibLoader.tryLoadingFromJRE(stringArray, stringArray3, NativeLibLoader.findSuffix(stringArray2, "deploy.jar")) || NativeLibLoader.tryLoadingFromJRE(stringArray, stringArray3, NativeLibLoader.findSuffix(stringArray2, "javaws.jar")))) {
            throw new InternalError("Unable to find plugin native libraries");
        }
    }

    private static boolean tryLoadingFromJRE(String[] stringArray, String[] stringArray2, String string) {
        File file = new File(string).getParentFile();
        File file2 = file.getParentFile();
        File file3 = null;
        if (file2 != null) {
            file3 = file2.getParentFile();
        }
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl2 = false;
            for (int j = 0; j < stringArray2.length && !bl2; ++j) {
                bl2 = NativeLibLoader.tryLoading(stringArray[i], file, stringArray2[j]);
                if (!bl2) {
                    bl2 = NativeLibLoader.tryLoading(stringArray[i], file2, stringArray2[j]);
                }
                if (bl2) continue;
                bl2 = NativeLibLoader.tryLoading(stringArray[i], file3, stringArray2[j]);
            }
            if (bl2) continue;
            bl = false;
        }
        return bl;
    }

    private static String[] getPossibleSubdirs() {
        String string;
        String string2 = SystemUtil.getSystemProperty("os.name").toLowerCase();
        if (string2.startsWith("mac os x")) {
            return new String[]{null};
        }
        String string3 = SystemUtil.getSystemProperty("sun.boot.library.path");
        if (!string3.startsWith(string = SystemUtil.getJavaHome())) {
            throw new InternalError("sun.boot.library.path (\"" + string3 + "\") did not start with java.home (\"" + string + "\")");
        }
        String string4 = string3.substring(string.length());
        if (string4.startsWith(File.separator)) {
            string4 = string4.substring(1);
        }
        String string5 = "jre" + File.separator + string4;
        String string6 = string4 + File.separator + "new_plugin";
        String string7 = string5 + File.separator + "new_plugin";
        return new String[]{string4, string5, string6, string7};
    }

    private static boolean tryLoading(String string, File file, String string2) {
        File file2;
        if (file == null) {
            return false;
        }
        File file3 = file;
        if (string2 != null) {
            file3 = new File(file, string2);
        }
        if (!(file2 = new File(file3, SystemUtil.formatNativeLibraryName(string))).exists()) {
            if (DEBUG) {
                System.err.println("NativeLibLoader: " + file2.getAbsolutePath() + " doesn't exist");
            }
            return false;
        }
        if (DEBUG) {
            System.err.println("NativeLibLoader: trying to load " + file2.getAbsolutePath());
        }
        System.load(file2.getAbsolutePath());
        if (DEBUG) {
            System.err.println("  (Succeeded)");
        }
        return true;
    }

    private static String findSuffix(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(string)) continue;
            return stringArray[i];
        }
        return null;
    }
}

