/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Controller;

import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.Installer.Installer;
import org.openoffice.setup.Installer.InstallerFactory;
import org.openoffice.setup.Panel.UninstallationPrologue;
import org.openoffice.setup.PanelController;
import org.openoffice.setup.ResourceManager;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.SetupData.SetupDataProvider;
import org.openoffice.setup.SetupFrame;
import org.openoffice.setup.Util.Converter;
import org.openoffice.setup.Util.Dumper;
import org.openoffice.setup.Util.Informer;
import org.openoffice.setup.Util.LogManager;
import org.openoffice.setup.Util.ModuleCtrl;
import org.openoffice.setup.Util.SystemManager;

public class UninstallationPrologueCtrl
extends PanelController {
    private String helpFile = "String_Helpfile_UninstallationPrologue";

    public UninstallationPrologueCtrl() {
        super("UninstallationPrologue", new UninstallationPrologue());
    }

    public String getNext() {
        return new String("ChooseUninstallationType");
    }

    public String getPrevious() {
        return null;
    }

    public final String getHelpFileName() {
        return this.helpFile;
    }

    private HashMap getInfoFileData() {
        InstallData data = InstallData.getInstance();
        File infoRootDir = data.getInfoRoot();
        String infoFilename = "infoFile";
        File infoFile = new File(infoRootDir, infoFilename);
        Vector infoFileContent = SystemManager.readCharFileVector(infoFile.getPath());
        HashMap map = Converter.convertVectorToHashmap(infoFileContent);
        return map;
    }

    private void setNewInstallData(HashMap map) {
        InstallData data = InstallData.getInstance();
        data.setPackagePath((String)map.get("PackagePath"));
        data.setAdminFileNameReloc((String)map.get("AdminFileReloc"));
        data.setAdminFileNameNoReloc((String)map.get("AdminFileNoReloc"));
        data.setDatabasePath((String)map.get("DatabasePath"));
        data.setInstallDir((String)map.get("InstallationDir"));
        data.setStoredInstallationPrivileges((String)map.get("InstallationPrivileges"));
        data.setGetUidPath((String)map.get("GetUidFile"));
    }

    private void readInfoFile() {
        HashMap map = this.getInfoFileData();
        this.setNewInstallData(map);
        Dumper.dumpNewInstallData();
    }

    private void checkUninstallPrivileges() {
        InstallData data = InstallData.getInstance();
        String originalPrivileges = data.getStoredInstallationPrivileges();
        String currentPrivileges = data.getInstallationPrivileges();
        if (!currentPrivileges.equalsIgnoreCase(originalPrivileges)) {
            if (currentPrivileges.equalsIgnoreCase("root")) {
                String message = ResourceManager.getString("String_UninstallationPrologue_Wrong_Privileges_Current_Root");
                String title = ResourceManager.getString("String_Error");
                Informer.showErrorMessage(message, title);
                String log = "<b>Error: Wrong uninstallation privileges (currently Root)!</b><br>";
                System.err.println(log);
            } else {
                String message = ResourceManager.getString("String_UninstallationPrologue_Wrong_Privileges_Current_User");
                String title = ResourceManager.getString("String_Error");
                Informer.showErrorMessage(message, title);
                String log = "<b>Error: Wrong uninstallation privileges (currently User)!</b><br>";
                System.err.println(log);
            }
            System.exit(1);
        }
    }

    public void beforeShow() {
        SetupFrame setupFrame = this.getSetupFrame();
        this.getSetupFrame();
        setupFrame.setButtonEnabled(false, 2);
        SetupFrame setupFrame2 = this.getSetupFrame();
        this.getSetupFrame();
        setupFrame2.setButtonSelected(1);
    }

    public void duringShow() {
        Thread t = new Thread(){

            public void run() {
                InstallData installData = InstallData.getInstance();
                if (!installData.databaseAnalyzed()) {
                    SetupFrame setupFrame = UninstallationPrologueCtrl.this.getSetupFrame();
                    UninstallationPrologueCtrl.this.getSetupFrame();
                    setupFrame.setButtonEnabled(false, 1);
                    UninstallationPrologueCtrl.this.readInfoFile();
                    UninstallationPrologueCtrl.this.checkUninstallPrivileges();
                    PackageDescription packageData = SetupDataProvider.getPackageDescription();
                    Installer installer = InstallerFactory.getInstance();
                    installer.preUninstall(packageData);
                    LogManager.setCommandsHeaderLine("Analyzing system database");
                    ModuleCtrl.setDatabaseSettings(packageData, installData, installer);
                    installData.setDatabaseAnalyzed(true);
                    ModuleCtrl.setDontUninstallFlags(packageData);
                    if (installData.isRootInstallation()) {
                        ModuleCtrl.setDontUninstallUserInstallOnylFlags(packageData);
                    }
                    ModuleCtrl.setParentDefaultModuleSettings(packageData);
                    SetupFrame setupFrame2 = UninstallationPrologueCtrl.this.getSetupFrame();
                    UninstallationPrologueCtrl.this.getSetupFrame();
                    setupFrame2.setButtonEnabled(true, 1);
                    SetupFrame setupFrame3 = UninstallationPrologueCtrl.this.getSetupFrame();
                    UninstallationPrologueCtrl.this.getSetupFrame();
                    setupFrame3.setButtonSelected(1);
                }
            }
        };
        t.start();
    }

    public boolean afterShow(boolean nextButtonPressed) {
        boolean repeatDialog = false;
        SetupFrame setupFrame = this.getSetupFrame();
        this.getSetupFrame();
        setupFrame.setButtonEnabled(true, 2);
        return repeatDialog;
    }
}

