/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StringQuoteUtil {
    private static final boolean DEBUG = false;
    protected static final String _winPathBugVal = "C:\\windows\\Documents, and, Stuff\\";
    protected static final String _winPathFixedVal = "C:\\windows\\Documents, and, Stuff";
    protected static final String _winPathQuotedBugVal = "\"C:\\windows\\Documents, and, Stuff\\\"";
    protected static final String[] _testCleanVal = new String[]{"C:\\windows\\Documents, and, Stuff", "C:\\windows\\Documents, and, Stuff\\jre.exe"};
    protected static final String[] _testCmdLine = new String[]{"-Dababa=2222", "-Dlala=C:\\windows\\Documents, and, Stuff", "-DresponseString.0=yes", "-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe", "-DexecString=/bin/sh {1} {0} {2}"};
    protected static final String[] _testPropVal = new String[]{"C:\\windows\\Documents, and, Stuff", "-Dlala=C:\\windows\\Documents, and, Stuff", "C:\\windows\\Documents, and, Stuff\\jre.exe"};
    protected static final String[] _testPropValQuoted = new String[]{"\"C:\\windows\\Documents, and, Stuff\"", "\"-Dlala=C:\\windows\\Documents, and, Stuff\"", "\"C:\\windows\\Documents, and, Stuff\\jre.exe\""};
    protected static final String _testJvmArgs = "-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat \"-DexecString=/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE \"-DwaitString.0=[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes \"-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe\"";
    protected static final String _testJvmArgsQuoted = "\"-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat \\\"-DexecString=/bin/sh {1} {0} {2}\\\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE \\\"-DwaitString.0=[yes or no]\\\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes \\\"-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe\\\"\"";
    protected static final String _testJvmArgsUnix = "-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat -DexecString=\"/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE -DwaitString.0=\"[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes -DwinPath=\"c:\\windows\\Documents, and Stuff\\java.exe\"";
    protected static final String _testJvmArgsUnixQuoted = "\"-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat -DexecString=\\\"/bin/sh {1} {0} {2}\\\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE -DwaitString.0=\\\"[yes or no]\\\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes -DwinPath=\\\"c:\\windows\\Documents, and Stuff\\java.exe\\\"\"";

    public static final boolean isEscape(char c) {
        return c == '\\';
    }

    public static final boolean isQuote(char c) {
        return c == '\"';
    }

    public static final boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f';
    }

    public static final boolean needsQuote(String string) {
        return string.indexOf(32) != -1 || string.indexOf(9) != -1 || string.indexOf(34) != -1;
    }

    public static final boolean needsQuote(StringBuffer stringBuffer) {
        return StringQuoteUtil.needsQuote(stringBuffer.toString());
    }

    public static final String quote(String string) {
        if (string == null) {
            return null;
        }
        return StringQuoteUtil.quote(new StringBuffer(string)).toString();
    }

    public static final StringBuffer quote(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = stringBuffer.length();
        stringBuffer2.append("\"");
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            if (i == n - 1 && c == '\\') continue;
            if (c == '\"') {
                stringBuffer2.append('\\');
            }
            stringBuffer2.append(c);
        }
        stringBuffer2.append("\"");
        return stringBuffer2;
    }

    public static final int digestNextQuote(StringBuffer stringBuffer, int n, StringBuffer stringBuffer2, boolean bl, boolean bl2) {
        int n2;
        if (stringBuffer == null) {
            return -1;
        }
        int n3 = stringBuffer.length();
        if (n > n3 - 1) {
            return -1;
        }
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        for (n2 = n; n2 < n3; ++n2) {
            char c = stringBuffer.charAt(n2);
            if (n4 < 0) {
                if (StringQuoteUtil.isQuote(c)) {
                    n4 = n2;
                    if (null == stringBuffer2 || bl) continue;
                    stringBuffer2.append(c);
                    continue;
                }
                if (null == stringBuffer2 || n2 == n3 - 1 && c == '\\') continue;
                stringBuffer2.append(c);
                continue;
            }
            if (StringQuoteUtil.isEscape(c)) {
                if (n5 >= 0) {
                    n5 = -1;
                    if (null == stringBuffer2) continue;
                    if (!bl) {
                        stringBuffer2.append('\\');
                    }
                    stringBuffer2.append('\\');
                    continue;
                }
                n5 = n2;
                continue;
            }
            if (StringQuoteUtil.isQuote(c)) {
                if (n5 >= 0) {
                    n5 = -1;
                    int n7 = n6 = n6 >= 0 ? -1 : n2;
                    if (null == stringBuffer2) continue;
                    if (!bl) {
                        stringBuffer2.append('\\');
                    }
                    stringBuffer2.append('\"');
                    continue;
                }
                if (null != stringBuffer2 && !bl) {
                    stringBuffer2.append(c);
                }
                if (bl2) {
                    stringBuffer.delete(n4, n2 + 1);
                    return n4;
                }
                return n2 + 1;
            }
            if (n5 >= 0) {
                n5 = -1;
                if (null != stringBuffer2) {
                    stringBuffer2.append('\\');
                }
            }
            if (null == stringBuffer2) continue;
            stringBuffer2.append(c);
        }
        if (n6 >= 0) {
            if (n4 >= 0) {
                if (!bl) {
                    stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
                }
                stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
                return n3;
            }
            throw new IllegalArgumentException("unclosed inner quote: <" + stringBuffer.substring(n6, n3).toString() + ">\n\t(innerQuoteStart: " + n6 + ", scanPos: " + n2 + ", len: " + n3 + ")\n\tres: " + (stringBuffer2 != null ? stringBuffer2.toString() : null));
        }
        if (n4 >= 0) {
            throw new IllegalArgumentException("unclosed string literal: <" + stringBuffer.substring(n4, n3).toString() + ">\n\t(quoteStart: " + n4 + ", scanPos: " + n2 + ", len: " + n3 + ")\n\tres: " + (stringBuffer2 != null ? stringBuffer2.toString() : null));
        }
        return -1;
    }

    public static final String unquoteIfEnclosedInQuotes(String string) {
        if (string == null) {
            return null;
        }
        return StringQuoteUtil.unquoteIfEnclosedInQuotes(new StringBuffer(string)).toString();
    }

    public static final StringBuffer unquoteIfEnclosedInQuotes(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        int n = stringBuffer.length();
        if (n < 2) {
            return stringBuffer;
        }
        if (StringQuoteUtil.isQuote(stringBuffer.charAt(0)) && StringQuoteUtil.isQuote(stringBuffer.charAt(n - 1))) {
            StringBuffer stringBuffer2 = new StringBuffer();
            int n2 = 0;
            int n3 = 0;
            while ((n2 = StringQuoteUtil.digestNextQuote(stringBuffer, n2, stringBuffer2, true, false)) >= 0) {
                ++n3;
            }
            if (n3 == 1) {
                return stringBuffer2;
            }
        }
        return stringBuffer;
    }

    public static final String unquote(String string) {
        if (string == null) {
            return null;
        }
        return StringQuoteUtil.unquote(new StringBuffer(string)).toString();
    }

    public static final StringBuffer unquote(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while ((n = StringQuoteUtil.digestNextQuote(stringBuffer, n, stringBuffer2, true, false)) >= 0) {
        }
        return stringBuffer2;
    }

    public static final String removeQuotedPart(String string) {
        if (string == null) {
            return null;
        }
        return StringQuoteUtil.removeQuotedPart(new StringBuffer(string)).toString();
    }

    public static final StringBuffer removeQuotedPart(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while ((n = StringQuoteUtil.digestNextQuote(stringBuffer, n, null, false, true)) >= 0) {
        }
        return stringBuffer;
    }

    public static final String quoteIfNeeded(String string) {
        if (string == null) {
            return null;
        }
        return StringQuoteUtil.quoteIfNeeded(new StringBuffer(string)).toString();
    }

    public static final StringBuffer quoteIfNeeded(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        if (!StringQuoteUtil.needsQuote(stringBuffer)) {
            return stringBuffer;
        }
        int n = stringBuffer.length();
        if (n < 2) {
            return StringQuoteUtil.quote(stringBuffer);
        }
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
        int n2 = 0;
        boolean bl = false;
        while ((n2 = StringQuoteUtil.digestNextQuote(stringBuffer2, n2, null, false, true)) >= 0) {
        }
        if (StringQuoteUtil.needsQuote(stringBuffer2)) {
            return StringQuoteUtil.quote(stringBuffer);
        }
        return stringBuffer;
    }

    public static final List getCommandLineArgs(String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return arrayList;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = stringBuffer.length();
        StringBuffer stringBuffer2 = null;
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            char c = stringBuffer.charAt(n);
            if (!bl) {
                if (stringBuffer2 != null) {
                    throw new IllegalArgumentException("ooops");
                }
                if (StringQuoteUtil.isWhiteSpace(c)) continue;
                bl = true;
                stringBuffer2 = new StringBuffer();
                --n;
                continue;
            }
            if (stringBuffer2 == null) {
                throw new IllegalArgumentException("ooops");
            }
            if (StringQuoteUtil.isWhiteSpace(c)) {
                bl = false;
            } else if (StringQuoteUtil.isQuote(c)) {
                int n3 = StringQuoteUtil.digestNextQuote(stringBuffer, n, stringBuffer2, true, false);
                if (n < 0) {
                    throw new IllegalArgumentException("Quote Error: " + n + ".." + n3 + ", size: " + n2 + ",\n\t input: " + stringBuffer + ",\n\tincomplete argument: " + stringBuffer2);
                }
                n = n3 - 1;
            } else {
                stringBuffer2.append(c);
            }
            if (bl && n != n2 - 1) continue;
            arrayList.add(stringBuffer2.toString());
            bl = false;
            stringBuffer2 = null;
        }
        if (stringBuffer2 != null) {
            throw new IllegalArgumentException("Quote Error: at end: " + n + ", size: " + n2 + ",\n\t input: " + stringBuffer + ",\n\t incomplete argument: " + stringBuffer2);
        }
        return arrayList;
    }

    public static final String getStringByCommandList(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                stringBuffer.append(" ");
            } else {
                bl = true;
            }
            String string = (String)iterator.next();
            stringBuffer.append(StringQuoteUtil.quoteIfNeeded(string));
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        System.exit(StringQuoteUtil.test() ? 0 : 1);
    }

    protected static boolean test() {
        String string;
        int n;
        int n2;
        List list;
        int n3;
        String string2 = "-Djnlpx.vmargs=-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat \"-DexecString=/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE \"-DwaitString.0=[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes \"-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe\"";
        String string3 = StringQuoteUtil.quoteIfNeeded(string2) + " " + _testJvmArgs;
        boolean bl = true;
        String string4 = StringQuoteUtil.unquote(StringQuoteUtil.quote(_winPathBugVal));
        if (string4.equals(_winPathFixedVal)) {
            System.out.println("Test 0.0 passed");
        } else {
            System.out.println("Test 0.0 FAILED");
            System.out.println("\t orig     : <C:\\windows\\Documents, and, Stuff\\>");
            System.out.println("\t expected : <C:\\windows\\Documents, and, Stuff>");
            System.out.println("\t result   : <" + string4 + ">");
        }
        string4 = StringQuoteUtil.unquote(_winPathBugVal);
        if (string4.equals(_winPathFixedVal)) {
            System.out.println("Test 0.1 passed");
        } else {
            System.out.println("Test 0.1 FAILED");
            System.out.println("\t orig     : <C:\\windows\\Documents, and, Stuff\\>");
            System.out.println("\t expected : <C:\\windows\\Documents, and, Stuff>");
            System.out.println("\t result   : <" + string4 + ">");
        }
        string4 = StringQuoteUtil.unquoteIfEnclosedInQuotes(_winPathQuotedBugVal);
        if (string4.equals(_winPathFixedVal)) {
            System.out.println("Test 0.2 passed");
        } else {
            System.out.println("Test 0.2 FAILED");
            System.out.println("\t orig     : <\"C:\\windows\\Documents, and, Stuff\\\">");
            System.out.println("\t expected : <C:\\windows\\Documents, and, Stuff>");
            System.out.println("\t result   : <" + string4 + ">");
        }
        for (n3 = 0; n3 < _testCleanVal.length; ++n3) {
            string4 = StringQuoteUtil.unquote(_testCleanVal[n3]);
            if (string4.equals(_testCleanVal[n3])) {
                System.out.println("Test 1." + n3 + " passed");
                continue;
            }
            System.out.println("Test 1." + n3 + " FAILED");
            System.out.println("\t expected : <" + _testCleanVal[n3] + ">");
            System.out.println("\t result   : <" + string4 + ">");
            bl = false;
        }
        for (n3 = 0; n3 < _testPropVal.length; ++n3) {
            string4 = StringQuoteUtil.quote(_testPropVal[n3]);
            if (string4.equals(_testPropValQuoted[n3])) {
                System.out.println("Test 2." + n3 + ".0 passed");
            } else {
                System.out.println("Test 2." + n3 + ".0 FAILED");
                System.out.println("\t orig     : <" + _testPropVal[n3] + ">");
                System.out.println("\t expected : <" + _testPropValQuoted[n3] + ">");
                System.out.println("\t result   : <" + string4 + ">");
                bl = false;
            }
            string4 = StringQuoteUtil.unquoteIfEnclosedInQuotes(_testPropValQuoted[n3]);
            if (string4.equals(_testPropVal[n3])) {
                System.out.println("Test 2." + n3 + ".1 passed");
                continue;
            }
            System.out.println("Test 2." + n3 + ".1 FAILED");
            System.out.println("\t orig     : <" + _testPropValQuoted[n3] + ">");
            System.out.println("\t expected : <" + _testPropVal[n3] + ">");
            System.out.println("\t result   : <" + string4 + ">");
            bl = false;
        }
        string4 = StringQuoteUtil.quote(_testJvmArgs);
        if (string4.equals(_testJvmArgsQuoted)) {
            System.out.println("Test 3.1 passed");
        } else {
            System.out.println("Test 3.1 FAILED");
            System.out.println("\t orig     : <-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat \"-DexecString=/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE \"-DwaitString.0=[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes \"-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe\">");
            System.out.println("\t expected : <\"-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat \\\"-DexecString=/bin/sh {1} {0} {2}\\\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE \\\"-DwaitString.0=[yes or no]\\\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes \\\"-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe\\\"\">");
            System.out.println("\t result   : <" + string4 + ">");
            bl = false;
        }
        string4 = StringQuoteUtil.unquoteIfEnclosedInQuotes(_testJvmArgsQuoted);
        if (string4.equals(_testJvmArgs)) {
            System.out.println("Test 3.2 passed");
        } else {
            System.out.println("Test 3.2 FAILED");
            System.out.println("\t orig     : <\"-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat \\\"-DexecString=/bin/sh {1} {0} {2}\\\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE \\\"-DwaitString.0=[yes or no]\\\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes \\\"-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe\\\"\">");
            System.out.println("\t expected : <-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat \"-DexecString=/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE \"-DwaitString.0=[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes \"-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe\">");
            System.out.println("\t result   : <" + string4 + ">");
            bl = false;
        }
        string4 = StringQuoteUtil.quote(_testJvmArgsUnix);
        if (string4.equals(_testJvmArgsUnixQuoted)) {
            System.out.println("Test 3.3 passed");
        } else {
            System.out.println("Test 3.3 FAILED");
            System.out.println("\t orig     : <-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat -DexecString=\"/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE -DwaitString.0=\"[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes -DwinPath=\"c:\\windows\\Documents, and Stuff\\java.exe\">");
            System.out.println("\t expected : <\"-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat -DexecString=\\\"/bin/sh {1} {0} {2}\\\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE -DwaitString.0=\\\"[yes or no]\\\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes -DwinPath=\\\"c:\\windows\\Documents, and Stuff\\java.exe\\\"\">");
            System.out.println("\t result   : <" + string4 + ">");
            bl = false;
        }
        string4 = StringQuoteUtil.unquoteIfEnclosedInQuotes(_testJvmArgsUnixQuoted);
        if (string4.equals(_testJvmArgsUnix)) {
            System.out.println("Test 3.4 passed");
        } else {
            System.out.println("Test 3.4 FAILED");
            System.out.println("\t orig     : <\"-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat -DexecString=\\\"/bin/sh {1} {0} {2}\\\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE -DwaitString.0=\\\"[yes or no]\\\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes -DwinPath=\\\"c:\\windows\\Documents, and Stuff\\java.exe\\\"\">");
            System.out.println("\t expected : <-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat -DexecString=\"/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE -DwaitString.0=\"[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes -DwinPath=\"c:\\windows\\Documents, and Stuff\\java.exe\">");
            System.out.println("\t result   : <" + string4 + ">");
            bl = false;
        }
        string4 = StringQuoteUtil.unquoteIfEnclosedInQuotes("\"-Dlala=li li\" -Dlulu=\"da da\"");
        if (string4.equals("\"-Dlala=li li\" -Dlulu=\"da da\"")) {
            System.out.println("Test 3.5 passed");
        } else {
            System.out.println("Test 3.5 FAILED");
            System.out.println("\t expected : <\"-Dlala=li li\" -Dlulu=\"da da\">");
            System.out.println("\t result   : <" + string4 + ">");
            bl = false;
        }
        for (int i = 0; i < _testCmdLine.length; ++i) {
            list = StringQuoteUtil.getCommandLineArgs(StringQuoteUtil.quoteIfNeeded(_testCmdLine[i]));
            if (list.size() == 1 && _testCmdLine[i].equals((String)list.get(0))) {
                System.out.println("Test 4.0." + i + " passed");
                continue;
            }
            System.out.println("Test 4.0." + i + " FAILED");
            if (list.size() != 1) {
                System.out.println("\t input : <" + _testCmdLine[i] + ">");
                System.out.println("\t cmdline number not 1, is " + list.size());
                for (n2 = 0; n2 < list.size(); ++n2) {
                    System.out.println("\t" + n2 + ": " + (String)list.get(n2));
                }
            } else {
                String string5 = (String)list.get(0);
                System.out.println("\t input : <" + _testCmdLine[i] + ">");
                System.out.println("\t result: <" + string5 + ">");
            }
            bl = false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n2 = 0; n2 < _testCmdLine.length; ++n2) {
            arrayList.add(_testCmdLine[n2]);
        }
        String string6 = StringQuoteUtil.getStringByCommandList(arrayList);
        list = StringQuoteUtil.getCommandLineArgs(string6);
        int n4 = list.size();
        if (list.size() == _testCmdLine.length) {
            System.out.println("Test 4.1._ passed");
        } else {
            System.out.println("Test 4.1._ failed");
            System.out.println("\t input        : " + string6);
            System.out.println("\t expected size: " + _testCmdLine.length);
            System.out.println("\t argList  size: " + list.size());
            if (_testCmdLine.length < n4) {
                n4 = _testCmdLine.length;
            }
        }
        for (n = 0; n < n4; ++n) {
            if (_testCmdLine[n].equals((String)list.get(n))) {
                System.out.println("Test 4.1." + n + " passed");
                continue;
            }
            System.out.println("Test 4.1." + n + " FAILED");
            string = (String)list.get(n);
            System.out.println("\t expected: <" + _testCmdLine[n] + ">");
            System.out.println("\t result  : <" + string + ">");
            bl = false;
        }
        list = StringQuoteUtil.getCommandLineArgs(_testJvmArgs);
        if (list.size() == 12) {
            System.out.println("Test 4.2.0 passed");
        } else {
            System.out.println("Test 4.2.0 FAILED");
            System.out.println("\t expected number : 12");
            System.out.println("\t result   number : " + list.size());
            bl = false;
        }
        for (n = 0; n < list.size(); ++n) {
            string = (String)list.get(n);
            System.out.println("Test 4.2." + (n + 1) + " result : <" + string + ">");
        }
        list = StringQuoteUtil.getCommandLineArgs(_testJvmArgsUnix);
        if (list.size() == 12) {
            System.out.println("Test 4.3.0 passed");
        } else {
            System.out.println("Test 4.3.0 FAILED");
            System.out.println("\t expected number : 12");
            System.out.println("\t result   number : " + list.size());
            bl = false;
        }
        for (n = 0; n < list.size(); ++n) {
            string = (String)list.get(n);
            System.out.println("Test 4.3." + (n + 1) + " result : <" + string + ">");
        }
        list = StringQuoteUtil.getCommandLineArgs(string3);
        if (list.size() == 13) {
            System.out.println("Test 4.4.0 passed");
        } else {
            System.out.println("Test 4.4.0 FAILED");
            System.out.println("\t expected number : 13");
            System.out.println("\t result   number : " + list.size());
            bl = false;
        }
        block11: for (n = 0; n < list.size(); ++n) {
            string = (String)list.get(n);
            switch (n) {
                case 0: {
                    if (string.equals(string2)) {
                        System.out.println("Test 4.4.1 passed");
                        continue block11;
                    }
                    System.out.println("Test 4.4.1 FAILED");
                    System.out.println("\t expected : <" + string2 + ">");
                    System.out.println("\t result   : <" + string + ">");
                    bl = false;
                    continue block11;
                }
                default: {
                    System.out.println("Test 4.4." + (n + 1) + " result : <" + string + ">");
                }
            }
        }
        return bl;
    }
}

