/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Util;

import java.io.File;
import java.util.Enumeration;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.Installer.Installer;
import org.openoffice.setup.ResourceManager;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.Util.Informer;
import org.openoffice.setup.Util.LogManager;

public class ModuleCtrl {
    private ModuleCtrl() {
    }

    public static void setModuleSize(PackageDescription packageData) {
        if (!packageData.isLeaf()) {
            boolean setNewSize = false;
            int size = packageData.getSize();
            Enumeration e = packageData.children();
            while (e.hasMoreElements()) {
                PackageDescription child = (PackageDescription)e.nextElement();
                if (!child.isHidden()) continue;
                setNewSize = true;
                size += child.getSize();
            }
            if (setNewSize) {
                packageData.setSize(size);
            }
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setModuleSize(child);
        }
    }

    public static void setDefaultModuleSettings(PackageDescription data) {
        boolean isInstalled = false;
        InstallData installdata = InstallData.getInstance();
        boolean isUninstall = installdata.isUninstallationMode();
        if (isUninstall) {
            isInstalled = true;
        }
        if (isUninstall) {
            if (isInstalled) {
                data.setSelectionState(3);
            } else {
                data.setSelectionState(6);
                System.err.println("NEVER");
            }
        } else if (isInstalled) {
            data.setSelectionState(6);
            System.err.println("NEVER");
        } else if (data.isDefault()) {
            data.setSelectionState(1);
        } else if (!data.isDefault()) {
            data.setSelectionState(0);
        } else {
            data.setSelectionState(0);
        }
    }

    public static void setParentDefaultModuleSettings(PackageDescription packageData) {
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setParentDefaultModuleSettings(child);
        }
        if (!packageData.isLeaf()) {
            int state = packageData.getSelectionState();
            InstallData installdata = InstallData.getInstance();
            boolean allChildrenIgnored = true;
            boolean atLeastOneInstalled = false;
            boolean allChildrenHidden = true;
            Enumeration e2 = packageData.children();
            while (e2.hasMoreElements()) {
                PackageDescription child = (PackageDescription)e2.nextElement();
                int childState = child.getSelectionState();
                if (childState != 6) {
                    allChildrenIgnored = false;
                }
                if (childState == 1 || childState == 2) {
                    atLeastOneInstalled = true;
                }
                if (!child.isHidden()) {
                    allChildrenHidden = false;
                }
                if (state == 7 || state == 6) {
                    state = childState;
                    continue;
                }
                if (state == childState || childState == 6 || childState == 7) continue;
                if (installdata.isUninstallationMode()) {
                    state = 5;
                    continue;
                }
                state = 2;
            }
            if (allChildrenIgnored) {
                state = 6;
            }
            if (installdata.isInstallationMode() && state == 2 && !atLeastOneInstalled) {
                state = 0;
            }
            if (allChildrenHidden) {
                packageData.setAllChildrenHidden(true);
            }
            packageData.setSelectionState(state);
        }
    }

    public static void setHiddenModuleSettingsInstall(PackageDescription packageData) {
        if (packageData.isHidden()) {
            if (packageData.getSelectionState() != 6) {
                PackageDescription parent = (PackageDescription)packageData.getParent();
                if (parent != null) {
                    packageData.setSelectionState(parent.getSelectionState());
                    if (parent.getName() == "") {
                        packageData.setSelectionState(1);
                    }
                }
                if (packageData.getSelectionState() == 2 && packageData.isLeaf()) {
                    packageData.setSelectionState(1);
                }
            }
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setHiddenModuleSettingsInstall(child);
        }
    }

    public static void setHiddenModuleSettingsUninstall(PackageDescription packageData) {
        InstallData data = InstallData.getInstance();
        if (packageData.isHidden()) {
            if (packageData.getSelectionState() != 6) {
                PackageDescription parent = (PackageDescription)packageData.getParent();
                if (parent != null) {
                    packageData.setSelectionState(parent.getSelectionState());
                    if (parent.getName() == "" && data.isTypicalInstallation()) {
                        packageData.setSelectionState(3);
                    }
                    if (!data.isMaskedCompleteUninstallation() && parent.getName() == "" && data.isCustomInstallation()) {
                        packageData.setSelectionState(6);
                    }
                }
                if (packageData.getSelectionState() == 5 && packageData.isLeaf()) {
                    packageData.setSelectionState(3);
                }
            }
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setHiddenModuleSettingsUninstall(child);
        }
    }

    private static boolean checkRequiredCoreModule(PackageDescription packageData) {
        boolean requiredCoreModule = false;
        if (packageData.isHidden()) {
            PackageDescription parent;
            if (packageData.getSelectionState() != 6 && packageData.getPackageName() != null && (parent = (PackageDescription)packageData.getParent()) != null) {
                PackageDescription grandpa;
                if (parent.getName().equals("") || parent.getName() == null) {
                    requiredCoreModule = true;
                } else if (parent.isHidden() && (grandpa = (PackageDescription)parent.getParent()) != null && (grandpa.getName().equals("") || grandpa.getName() == null)) {
                    requiredCoreModule = true;
                }
            }
        }
        return requiredCoreModule;
    }

    public static void setDatabaseSettings(PackageDescription packageData, InstallData installData, Installer installer) {
        boolean isUninstall = installData.isUninstallationMode();
        boolean isInstalled = installer.isPackageInstalled(packageData, installData);
        if (isUninstall) {
            if (isInstalled) {
                packageData.setSelectionState(3);
            } else {
                packageData.setSelectionState(6);
            }
        } else if (isInstalled) {
            boolean installedPackageIsOlder = installer.isInstalledPackageOlder(packageData, installData);
            if (!installedPackageIsOlder) {
                packageData.setSelectionState(6);
            } else {
                packageData.setSelectionState(1);
            }
        } else {
            boolean isRequiredCoreModule = ModuleCtrl.checkRequiredCoreModule(packageData);
            if (isRequiredCoreModule) {
                packageData.setSelectionState(1);
                LogManager.addLogfileComment("<b>Adding required package:</b> " + packageData.getPackageName() + "</br>");
                if (!ModuleCtrl.packageExists(packageData, installData)) {
                    String packagePath = installData.getPackagePath();
                    if (packageData.getPkgSubdir() != null && !packageData.getPkgSubdir().equals("")) {
                        File completePackageFile = new File(packagePath, packageData.getPkgSubdir());
                        packagePath = completePackageFile.getPath();
                    }
                    String packageName = packageData.getPackageName();
                    File packageFile = new File(packagePath, packageName);
                    String log = "<b>Error: Missing required package " + packageFile.getPath() + "</b><br>";
                    System.err.println(log);
                    String message = ResourceManager.getString("String_File_Not_Found") + ": " + packageFile.getPath();
                    String title = ResourceManager.getString("String_Error");
                    Informer.showErrorMessage(message, title);
                    System.exit(1);
                }
            }
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setDatabaseSettings(child, installData, installer);
        }
    }

    public static void setShowInUserInstallFlags(PackageDescription packageData) {
        if (!packageData.showInUserInstall()) {
            packageData.setSelectionState(6);
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setShowInUserInstallFlags(child);
        }
    }

    private static boolean packageExists(PackageDescription packageData, InstallData installData) {
        String packageName;
        File packageFile;
        boolean fileExists = false;
        String packagePath = installData.getPackagePath();
        if (packageData.getPkgSubdir() != null && !packageData.getPkgSubdir().equals("")) {
            File completePackageFile = new File(packagePath, packageData.getPkgSubdir());
            packagePath = completePackageFile.getPath();
        }
        if ((packageFile = new File(packagePath, packageName = packageData.getPackageName())).exists()) {
            fileExists = true;
        }
        return fileExists;
    }

    public static void disableNonExistingPackages(PackageDescription packageData, InstallData installData) {
        if ((packageData.getPackageName() == null || packageData.getPackageName().equals("")) && packageData.isLeaf()) {
            packageData.setSelectionState(6);
        } else if (!ModuleCtrl.packageExists(packageData, installData)) {
            packageData.setSelectionState(6);
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.disableNonExistingPackages(child, installData);
        }
    }

    public static void setDontUninstallFlags(PackageDescription packageData) {
        if (packageData.dontUninstall()) {
            packageData.setSelectionState(6);
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setDontUninstallFlags(child);
        }
    }

    public static void checkVisibleModulesInstall(PackageDescription packageData, InstallData data) {
        boolean setToTrue = false;
        if (!packageData.isHidden()) {
            if (packageData.getSelectionState() == 1) {
                setToTrue = true;
                data.setVisibleModulesChecked(true);
            }
        }
        if (!setToTrue) {
            Enumeration e = packageData.children();
            while (e.hasMoreElements()) {
                PackageDescription child = (PackageDescription)e.nextElement();
                ModuleCtrl.checkVisibleModulesInstall(child, data);
            }
        }
    }

    public static void checkVisibleModulesUninstall(PackageDescription packageData, InstallData data) {
        boolean setToTrue = false;
        if (!packageData.isHidden()) {
            if (packageData.getSelectionState() == 3 && packageData.getName() != null && !packageData.getName().equals("")) {
                setToTrue = true;
                data.setVisibleModulesChecked(true);
            }
        }
        if (!setToTrue) {
            Enumeration e = packageData.children();
            while (e.hasMoreElements()) {
                PackageDescription child = (PackageDescription)e.nextElement();
                ModuleCtrl.checkVisibleModulesUninstall(child, data);
            }
        }
    }

    public static void checkMaskedCompleteUninstallation(PackageDescription packageData, InstallData data) {
        boolean setToFalse = false;
        if (!packageData.isHidden()) {
            if (packageData.getSelectionState() != 3) {
                if (packageData.getSelectionState() != 6 && packageData.getName() != null && !packageData.getName().equals("")) {
                    setToFalse = true;
                    data.setMaskedCompleteUninstallation(false);
                }
            }
        }
        if (!setToFalse) {
            Enumeration e = packageData.children();
            while (e.hasMoreElements()) {
                PackageDescription child = (PackageDescription)e.nextElement();
                ModuleCtrl.checkMaskedCompleteUninstallation(child, data);
            }
        }
    }

    public static void saveTypicalSelectionStates(PackageDescription packageData) {
        packageData.setTypicalSelectionState(packageData.getSelectionState());
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.saveTypicalSelectionStates(child);
        }
    }

    public static void saveCustomSelectionStates(PackageDescription packageData) {
        packageData.setCustomSelectionState(packageData.getSelectionState());
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.saveCustomSelectionStates(child);
        }
    }

    public static void saveStartSelectionStates(PackageDescription packageData) {
        packageData.setStartSelectionState(packageData.getSelectionState());
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.saveStartSelectionStates(child);
        }
    }

    public static void restoreTypicalSelectionStates(PackageDescription packageData) {
        packageData.setSelectionState(packageData.getTypicalSelectionState());
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.restoreTypicalSelectionStates(child);
        }
    }

    public static void restoreCustomSelectionStates(PackageDescription packageData) {
        packageData.setSelectionState(packageData.getCustomSelectionState());
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.restoreCustomSelectionStates(child);
        }
    }

    public static void restoreStartSelectionStates(PackageDescription packageData) {
        packageData.setSelectionState(packageData.getStartSelectionState());
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.restoreStartSelectionStates(child);
        }
    }

    public static void setUpdateOlderProductSettings(PackageDescription packageData, InstallData data, Installer installer) {
        if (packageData.getPackageName() != null && !packageData.getPackageName().equals("")) {
            if (installer.isPackageInstalled(packageData, data)) {
                packageData.setSelectionState(1);
                if (packageData.isJavaPackage() && !installer.isInstalledPackageOlder(packageData, data)) {
                    packageData.setSelectionState(0);
                }
            } else {
                packageData.setSelectionState(0);
            }
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            ModuleCtrl.setUpdateOlderProductSettings(child, data, installer);
        }
    }
}

