/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.wsdl.parser;

import com.sun.xml.internal.ws.model.Mode;
import com.sun.xml.internal.ws.model.ParameterBinding;
import com.sun.xml.internal.ws.wsdl.parser.Part;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingOperation {
    private String name;
    private Map<String, ParameterBinding> inputParts;
    private Map<String, ParameterBinding> outputParts;
    private Map<String, String> inputMimeTypes;
    private Map<String, String> outputMimeTypes;
    private boolean explicitInputSOAPBodyParts = false;
    private boolean explicitOutputSOAPBodyParts = false;
    private Boolean emptyInputBody;
    private Boolean emptyOutputBody;
    private Map<String, Part> inParts;
    private Map<String, Part> outParts;
    String reqNamespace;
    String respNamespace;

    public BindingOperation(String string) {
        this.name = string;
        this.inputParts = new HashMap<String, ParameterBinding>();
        this.outputParts = new HashMap<String, ParameterBinding>();
        this.inputMimeTypes = new HashMap<String, String>();
        this.outputMimeTypes = new HashMap<String, String>();
        this.inParts = new HashMap<String, Part>();
        this.outParts = new HashMap<String, Part>();
    }

    public String getName() {
        return this.name;
    }

    public Part getPart(String string, Mode mode) {
        if (mode.equals((Object)Mode.IN)) {
            return this.inParts.get(string);
        }
        if (mode.equals((Object)Mode.OUT)) {
            return this.outParts.get(string);
        }
        return null;
    }

    public void addPart(Part part, Mode mode) {
        if (mode.equals((Object)Mode.IN)) {
            this.inParts.put(part.getName(), part);
        } else if (mode.equals((Object)Mode.OUT)) {
            this.outParts.put(part.getName(), part);
        }
    }

    public Map<String, ParameterBinding> getInputParts() {
        return this.inputParts;
    }

    public Map<String, ParameterBinding> getOutputParts() {
        return this.outputParts;
    }

    public Map<String, String> getInputMimeTypes() {
        return this.inputMimeTypes;
    }

    public Map<String, String> getOutputMimeTypes() {
        return this.outputMimeTypes;
    }

    public ParameterBinding getInputBinding(String string) {
        ParameterBinding parameterBinding;
        if (this.emptyInputBody == null) {
            this.emptyInputBody = this.inputParts.get(" ") != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if ((parameterBinding = this.inputParts.get(string)) == null) {
            if (this.explicitInputSOAPBodyParts || this.emptyInputBody.booleanValue()) {
                return ParameterBinding.UNBOUND;
            }
            return ParameterBinding.BODY;
        }
        return parameterBinding;
    }

    public ParameterBinding getOutputBinding(String string) {
        ParameterBinding parameterBinding;
        if (this.emptyOutputBody == null) {
            this.emptyOutputBody = this.outputParts.get(" ") != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if ((parameterBinding = this.outputParts.get(string)) == null) {
            if (this.explicitOutputSOAPBodyParts || this.emptyOutputBody.booleanValue()) {
                return ParameterBinding.UNBOUND;
            }
            return ParameterBinding.BODY;
        }
        return parameterBinding;
    }

    public String getMimeTypeForInputPart(String string) {
        return this.inputMimeTypes.get(string);
    }

    public String getMimeTypeForOutputPart(String string) {
        return this.outputMimeTypes.get(string);
    }

    public void setInputExplicitBodyParts(boolean bl) {
        this.explicitInputSOAPBodyParts = bl;
    }

    public void setOutputExplicitBodyParts(boolean bl) {
        this.explicitOutputSOAPBodyParts = bl;
    }

    public String getRequestNamespace() {
        return this.reqNamespace;
    }

    public String getResponseNamespace() {
        return this.respNamespace;
    }
}

